# Buenos Aires Education Guide

## System Overview

Argentina has **strong public education** at all levels-unusual for Latin America.

| Level | Age | Public | Private |
|-------|-----|--------|---------|
| Jardin (preschool) | 3-5 | Free | $100-500/month |
| Primaria (primary) | 6-12 | Free | $200-1,500/month |
| Secundaria (secondary) | 13-17 | Free | $300-2,000/month |
| Universidad (university) | 18+ | Free (UBA) | $3,000-20,000/year |

---

## Preschool & Kindergarten

### Public (Jardin de Infantes)

| Aspect | Details |
|--------|---------|
| Cost | Free |
| Hours | Half-day typical |
| Quality | Variable |
| Availability | Limited spots, apply early |
| Language | Spanish |

### Private

| Type | Monthly (USD) | Notes |
|------|---------------|-------|
| Basic | $100-250 | Local, Spanish |
| Bilingual | $300-600 | English/Spanish |
| International | $500-1,000 | Multiple languages |

### Finding Spots

- Apply 6-12 months ahead
- January-February inscriptions common
- Research neighborhoods carefully

---

## Primary & Secondary (K-12)

### Public Schools

| Aspect | Reality |
|--------|---------|
| Cost | Free |
| Quality | Variable by school |
| Language | Spanish only |
| Hours | Usually half-day |
| Uniforms | Often required |

### Private School Types

| Type | Description | Monthly (USD) |
|------|-------------|---------------|
| Traditional private | Spanish curriculum | $200-600 |
| Bilingual | English/Spanish | $400-1,000 |
| British | UK curriculum (GCSE/A-Level) | $800-1,500 |
| American | US curriculum | $1,000-2,000 |
| International Baccalaureate | IB program | $1,200-2,000 |
| German/French/Italian | Heritage schools | $600-1,200 |

### Top Private Schools

| School | Type | Location | Annual (USD) |
|--------|------|----------|--------------|
| Lincoln School | American | La Lucila | $20,000-30,000 |
| St. Andrew's Scots School | British | Various | $10,000-15,000 |
| Northlands | British | Olivos | $12,000-18,000 |
| Belgrano Day School | British | Belgrano | $8,000-12,000 |
| Washington School | American | Various | $12,000-18,000 |
| Goethe Schule | German | Various | $8,000-12,000 |
| Colegio Franco Argentino | French | Various | $6,000-10,000 |
| ORT | Technical/Jewish | Various | $8,000-12,000 |
| Escuela Argentina Modelo | Traditional | Centro | $4,000-6,000 |

### School Selection Factors

| Factor | Consider |
|--------|----------|
| Curriculum | Match future plans |
| Language | Bilingual benefits |
| Location | Commute matters |
| Community | Expat vs local |
| Values | Religious, secular |
| Activities | Sports, arts |
| Track record | University placement |

### School Year

| Period | Dates |
|--------|-------|
| Start | Early March |
| Winter break | 2 weeks July |
| End | Mid-December |
| Summer | January-February |

---

## University Education

### Public Universities

**UBA (Universidad de Buenos Aires)** is flagship:

| Aspect | Details |
|--------|---------|
| Cost | Free (even for foreigners) |
| Quality | Excellent in many fields |
| Competition | High, demanding |
| Entry | CBC (entrance year) required |
| Language | Spanish |

### UBA Faculties (Highlights)

| Faculty | Reputation |
|---------|------------|
| Medicine | Top in LATAM |
| Law | Very strong |
| Economics | Well-regarded |
| Engineering | Solid |
| Social Sciences | Strong |
| Architecture | Excellent |

### Private Universities

| University | Specialty | Annual (USD) |
|------------|-----------|--------------|
| Universidad de San Andres | Business, Economics | $15,000-20,000 |
| Universidad Torcuato Di Tella | Business, Polisci | $12,000-18,000 |
| ITBA | Engineering, Tech | $10,000-15,000 |
| Universidad Austral | Business, Law | $10,000-15,000 |
| Universidad de Palermo | Design, Communications | $6,000-10,000 |
| Universidad del Salvador | Various | $5,000-8,000 |
| Universidad Catolica Argentina | Various | $6,000-10,000 |

### MBA Programs

| School | Duration | Cost (USD) |
|--------|----------|------------|
| IAE Business School | 1-2 years | $50,000-80,000 |
| Universidad de San Andres | 1-2 years | $40,000-60,000 |
| UTDT MBA | 1-2 years | $35,000-50,000 |
| UBA MBA | 2 years | Free (competitive entry) |

### Study Abroad / International Students

| Requirement | Notes |
|-------------|-------|
| Visa | Student visa required |
| Language | Spanish (most programs) |
| Credential validation | May be required |
| Living costs | Very affordable |

---

## Language Learning

### Spanish Schools

| School | Type | Monthly (USD) |
|--------|------|---------------|
| Expanish | Large, social | $300-500 |
| Coined | Mid-size | $250-400 |
| VOS Buenos Aires | Smaller, intensive | $200-350 |
| University extension courses | Academic | $100-200 |
| Private tutors | Flexible | $15-25/hour |

### Program Types

| Type | Duration | Intensity |
|------|----------|-----------|
| Intensive | 2-4 weeks | 20+ hours/week |
| Standard | Months | 10-15 hours/week |
| Private | Flexible | Customized |
| Group | Ongoing | 4-8 hours/week |

### Learning Spanish in BA

| Advantage | Details |
|-----------|---------|
| Immersion | Spanish everywhere |
| Affordable | Much cheaper than US/Europe |
| Social | Meet other learners |
| Practical | Use it daily |

**Note:** Rioplatense Spanish differs from Mexican/Spanish-"vos" form, unique pronunciation.

---

## Vocational & Skills Training

### Technical Training

| Area | Options |
|------|---------|
| IT/Coding | Digital House, Henry, Acamica |
| Design | Universidad de Palermo, courses |
| Culinary | IAG, Mausi Sebess |
| Languages | Many institutes |
| Trades | Technical schools |

### Coding Bootcamps

| Bootcamp | Focus | Duration | Cost (USD) |
|----------|-------|----------|------------|
| Digital House | Full-stack, data | 5-6 months | $3,000-5,000 |
| Henry | Full-stack | 4-6 months | ISA model |
| Plataforma 5 | JavaScript | 3-4 months | $2,000-3,000 |
| Coderhouse | Various | Flexible | $500-2,000 |

---

## Homeschooling

### Legal Status

| Factor | Reality |
|--------|---------|
| Legality | Gray area |
| Regulation | Minimal |
| Socialization | Find groups |
| Resources | Growing community |

### Expat Approach

Many expat families:
- Use online international curricula
- Supplement with local activities
- Connect with homeschool networks
- Register with home country schools

---

## Special Needs Education

### Resources

| Type | Availability |
|------|--------------|
| Integrated schools | Growing |
| Specialized schools | Public and private |
| Therapy services | Good availability |
| Advocacy groups | Active |

### Finding Support

- Hospital-based programs
- Private therapy centers
- School support services
- Parent networks

---

## Adult Education

### Options

| Type | Where |
|------|-------|
| University courses | UBA extension, private |
| Language learning | Many institutes |
| Professional development | Industry associations |
| Online learning | Global platforms |

### Continuing Education

| Provider | Focus |
|----------|-------|
| Universidad de San Andres | Executive education |
| ITBA | Tech, engineering |
| IAE | Business, leadership |
| UBA extension | Various |
