# Buenos Aires Driving Guide

## Should You Drive?

### Short Answer: Probably Not

| Factor | Reality |
|--------|---------|
| Public transport | Excellent coverage |
| Taxis/Uber | Cheap and convenient |
| Traffic | Terrible |
| Parking | Nightmare and expensive |
| Stress | High |
| Cost | Adds up significantly |

### When Driving Makes Sense

| Situation | Consider |
|-----------|----------|
| Living in suburbs | With family |
| Regular trips outside city | Tigre, day trips |
| Disabled accessibility | Limited public transit options |
| Business needs | Deliveries, etc. |
| Night work | After transit closes |

---

## Traffic Reality

### What to Expect

| Factor | Reality |
|--------|---------|
| Aggressiveness | High |
| Lane discipline | Loose |
| Speed | Fast when moving |
| Honking | Constant |
| Motorcycles | Everywhere, unpredictable |
| Pedestrians | Jaywalking common |

### Rush Hour

| Time | Traffic Level |
|------|---------------|
| 7:00-10:00 | Very bad |
| 10:00-12:00 | Moderate |
| 12:00-14:00 | Moderate |
| 14:00-17:00 | Moderate |
| 17:00-20:00 | Very bad |
| 20:00+ | Better |

### Problem Areas

| Area | Issue |
|------|-------|
| Libertador | Always congested |
| 9 de Julio | High volume |
| Panamericana | Rush hour crawl |
| Center/Microcentro | Avoid if possible |
| Access routes | Morning/evening |

---

## Licensing

### Foreign License

| Status | Validity |
|--------|----------|
| Tourist | Valid 6 months |
| Resident | Must get local within 90 days |
| International Driving Permit | Recommended backup |

### Getting Argentine License

| Step | Notes |
|------|-------|
| Eye test | At clinic |
| Written test | Study manual |
| Practical test | Sometimes required |
| Documentation | DNI, foreign license, proof of address |

**Where:** Direccion General de Licencias

**Cost:** ~$50-100 USD

---

## Car Ownership

### Buying a Car

| Option | Pros | Cons |
|--------|------|------|
| New | Warranty, financing | Very expensive |
| Used | Cheaper | Risk, paperwork |
| Leasing | Flexibility | Not common |

### New Car Prices

Significantly higher than US due to import taxes:

| Car Type | Price Range (USD) |
|----------|-------------------|
| Economy | $20,000-35,000 |
| Compact | $30,000-50,000 |
| SUV | $40,000-80,000 |
| Luxury | $70,000-150,000+ |

### Used Cars

| Source | Notes |
|--------|-------|
| Concessionarias | Dealerships, more secure |
| MercadoLibre | Online marketplace |
| Private sales | Cheaper, more risk |
| DeMotores | Specialized site |

### Ownership Costs (Monthly)

| Expense | Cost (USD) |
|---------|------------|
| Insurance | $50-150 |
| Patente (registration) | $30-100 |
| Fuel | $100-200 |
| Parking | $100-300 |
| Maintenance | $50-100 average |
| **Total** | **$330-850** |

---

## Insurance

### Types

| Coverage | Description |
|----------|-------------|
| Responsabilidad civil | Liability only (minimum) |
| Terceros completo | Third party + theft/fire |
| Todo riesgo | Full coverage |

### Major Insurers

| Company | Notes |
|---------|-------|
| La Caja | Large, established |
| Mapfre | International |
| Allianz | International |
| San Cristobal | Local |
| Zurich | International |

### Costs

| Coverage Level | Monthly (USD) |
|----------------|---------------|
| Basic liability | $30-50 |
| Third party complete | $50-80 |
| Full coverage | $80-150 |

---

## Parking

### Street Parking

| Type | Cost |
|------|------|
| Metered zones | ~$1/hour |
| Trapitos | Informal "guards," tip $1-2 |
| Free zones | Limited, often full |

### Garages (Playas de Estacionamiento)

| Type | Cost (USD) |
|------|------------|
| Hourly | $2-5 |
| Daily | $10-25 |
| Monthly | $100-300 |

### Residential Parking

| Option | Notes |
|--------|-------|
| Building garage | Best, included or extra |
| Nearby garage | Monthly contract |
| Street | Risky (theft, damage) |

### Parking Reality

- Centro: Nearly impossible
- Palermo: Difficult on weekends
- Residential areas: Varies
- Never leave valuables visible

---

## Fuel

### Fuel Types

| Type | Use |
|------|-----|
| Nafta Super | Most common (91-93 octane) |
| Nafta Premium | Higher octane |
| Diesel | Diesel vehicles |
| GNC | Compressed natural gas (common) |

### Prices (Feb 2026)

| Fuel | Price per Liter (USD) |
|------|----------------------|
| Nafta Super | ~$0.70-0.80 |
| Nafta Premium | ~$0.85-0.95 |
| Diesel | ~$0.75-0.85 |
| GNC | ~$0.30-0.40 |

### GNC (Natural Gas)

Very popular for savings:
- Conversion cost: ~$500-1,000
- Savings: ~50% fuel cost
- Trade-off: Less trunk space, station visits

---

## Road Rules

### Key Rules

| Rule | Details |
|------|---------|
| Side of road | Right |
| Speed limits | Urban 40-60 km/h, highway 100-130 km/h |
| Seat belts | Mandatory front, recommended all |
| Phone use | Prohibited while driving |
| Blood alcohol | 0.05% limit |
| Children | Car seats required |

### Right of Way

| Situation | Rule |
|-----------|------|
| Intersections | Right has priority |
| Roundabouts | Inside has priority |
| Pedestrians | Should have priority (often ignored) |
| Emergency vehicles | Must yield |

### Common Violations

| Violation | Consequence |
|-----------|-------------|
| Speeding | Fines, photo radar |
| Phone use | Fines |
| Wrong parking | Tow, fines |
| DUI | Severe penalties, possible jail |

---

## Safety

### Vehicle Security

| Measure | Importance |
|---------|------------|
| Always lock | Essential |
| Nothing visible | Critical |
| Alarm/GPS tracker | Recommended |
| Secure parking | Important |

### Theft Reality

| Risk | Level |
|------|-------|
| Break-ins | Common |
| Full theft | Moderate |
| Carjacking | Rare but exists |

**Prevention:**
- Park in garages
- Nothing visible
- Lock doors while driving
- Avoid isolated areas

### Insurance Claims

For accidents:
1. Don't move vehicles (if safe)
2. Call insurance
3. Take photos
4. Exchange information
5. File police report if needed

---

## Alternatives to Owning

### Rental

| Type | Cost (USD/day) |
|------|----------------|
| Economy | $25-40 |
| Compact | $35-50 |
| SUV | $50-80 |
| With driver | $80-150 |

### Apps/Ride-share

| Service | Notes |
|---------|-------|
| Uber | Works, affordable |
| Cabify | Similar, sometimes better |
| DiDi | Another option |
| Taxi apps | Radio taxi booking |

### Day Trip Rentals

For occasional use:
- Rent for day trips
- Use taxi/Uber daily
- Much cheaper than owning

---

## Outside Buenos Aires

### Road Trips

| Destination | Distance | Drive Time |
|-------------|----------|------------|
| Tigre | 30 km | 45 min-1.5h |
| San Isidro | 25 km | 40 min-1h |
| La Plata | 60 km | 1-1.5h |
| Mar del Plata | 400 km | 4-5h |
| Mendoza | 1,000 km | 10-12h |
| Bariloche | 1,600 km | 16-18h |

### Highway System

| Road | Route |
|------|-------|
| Autopista | Fast, tolled highways |
| Ruta Nacional | National routes |
| Ruta Provincial | Provincial routes |

### Tolls

- Common on major highways
- Pay at booths (cash or card)
- Some have electronic (TelePase)

### Tips for Road Trips

1. Check vehicle thoroughly
2. Carry cash for tolls
3. Plan gas stops
4. Avoid night driving
5. Weather check (especially mountains)
6. Emergency kit
