# Buenos Aires Culture & Customs Guide

## Cultural Identity

Buenos Aires is unique in Latin America-more European than South American in many ways, yet distinctly Argentine.

### Key Influences

| Origin | Influence |
|--------|-----------|
| Italian | 60%+ ancestry, food, gestures, passion |
| Spanish | Language, architecture, cafe culture |
| Indigenous | Limited in BA (more in north) |
| Other European | French (architecture), British (sports) |
| Jewish | Large community, cultural impact |

### Porteno Identity

**Porteno** = person from Buenos Aires (from "puerto" = port)

| Trait | Expression |
|-------|------------|
| Pride | Sometimes arrogant, love their city |
| Melancholy | Tango, nostalgia, "tristeza portena" |
| Intellectual | Value education, debate, ideas |
| Night owls | Everything happens late |
| Passion | Football, politics, life |
| Therapy-loving | Highest therapists per capita |

---

## Social Customs

### Greetings

| Situation | Greeting |
|-----------|----------|
| Meeting someone | One kiss on right cheek |
| Business (first time) | Handshake |
| Business (established) | Kiss common |
| Friends | Kiss + hug |
| Formal | Handshake |

**Note:** Even men kiss men in greeting (on cheek).

### Personal Space

| Aspect | Reality |
|--------|---------|
| Physical distance | Closer than North American |
| Touching | Common during conversation |
| Eye contact | Direct, maintained |
| Interrupting | Normal in conversation |

### Time

| Concept | Reality |
|---------|---------|
| Punctuality | Flexible (15-30 min late = normal) |
| Business meetings | More punctual expected |
| Social events | Late arrival expected |
| "Ahora" (now) | Could mean later |
| Restaurant reservations | OK to arrive 15 min late |

---

## Conversation

### Good Topics

| Topic | Notes |
|-------|-------|
| Football | Passionate (ask their team first) |
| Food | Always appreciated |
| Travel | Interested in your experiences |
| Culture | Art, music, literature |
| Family | Important value |

### Avoid or Approach Carefully

| Topic | Notes |
|-------|-------|
| Falklands/Malvinas | Sensitive, Argentina claims them |
| Comparing to Brazil | Rivalry exists |
| Politics | Divisive (Peronism vs. anti) |
| Economy | Sensitive, frustrating for locals |
| Calling BA "Latin American" | They see themselves as European |

### Conversation Style

| Aspect | Reality |
|--------|---------|
| Directness | Can be blunt |
| Debate | Enjoyed, not personal |
| Complaining | National pastime |
| Humor | Sarcastic, self-deprecating |
| Volume | Loud by Northern European standards |

---

## Tango

### Understanding Tango

Not just for tourists-real cultural practice.

| Element | Description |
|---------|-------------|
| Music | Melancholic, passionate |
| Dance | Improvised partner dance |
| History | Born in Buenos Aires, working class |
| Today | Both tourist shows and real milongas |

### Experiencing Tango

| Option | For Whom |
|--------|----------|
| Tourist shows | Visitors wanting spectacle |
| Milongas | Serious dancers, authentic |
| Classes | Those wanting to learn |
| Street performances | Free, San Telmo |

### Famous Milongas

| Venue | Vibe |
|-------|------|
| La Catedral | Alternative, young |
| Salon Canning | Traditional, serious |
| La Viruta | Mixed, good for beginners |
| El Beso | Intimate, experienced |
| Confiteria Ideal | Historic, beautiful |

---

## Football (Futbol)

### Understanding the Obsession

Football is not a sport-it's a religion.

| Aspect | Reality |
|--------|---------|
| Importance | Defines identity |
| Teams | Inherited from family |
| Rivalry | Can be intense |
| Match days | City transforms |
| Conversations | Safe topic if respectful |

### Big Teams

| Team | Neighborhood | Character |
|------|--------------|-----------|
| Boca Juniors | La Boca | Working class, passionate |
| River Plate | Nunez | More middle/upper class |
| Independiente | Avellaneda | "Rey de Copas" |
| Racing | Avellaneda | Rival to Independiente |
| San Lorenzo | Boedo | Pope's team |

### The Superclasico

Boca vs. River = one of world's biggest rivalries.
- Ticket nearly impossible
- Entire city affected
- Emotions run extremely high

### Attending Matches

| Aspect | Notes |
|--------|-------|
| Tickets | Official sites only, avoid scalpers |
| Safety | Generally fine in designated areas |
| Experience | Unforgettable atmosphere |
| Tourist sections | Available, more controlled |

---

## Food Culture

### Meal Timing

| Meal | Time | Character |
|------|------|-----------|
| Breakfast | 8-10am | Light, coffee + medialunas |
| Lunch | 1-3pm | Can be substantial |
| Merienda | 5-7pm | Coffee/tea + pastries |
| Dinner | 9-11pm | Main social meal |

### Dining Customs

| Custom | Details |
|--------|---------|
| Arriving | 15-20 min late is fine |
| Seating | Wait to be seated |
| Bread | Often served, may be charged |
| Sharing | Common and expected |
| Rushing | Never rush an Argentine meal |
| Bill | Ask for it ("La cuenta") |
| Tipping | 10% standard |

### Asado Culture

| Element | Significance |
|---------|--------------|
| Sunday asado | Sacred family tradition |
| The asador | Person grilling, honored role |
| Timing | Takes hours, that's the point |
| Conversation | Main activity while waiting |
| No rushing | Never rush the meat |

---

## Social Life

### Making Friends

| Approach | Effectiveness |
|----------|---------------|
| Through activities | Good (classes, sports) |
| At work | Natural |
| Expat groups | Easier initially |
| Going out | Argentines open to meeting |

### Hosting/Being Hosted

| If Invited | Bring |
|------------|-------|
| Dinner party | Wine, dessert |
| Asado | Wine, something to share |
| Casual visit | Nothing required |

**Arrival time:** 30+ minutes late for social events.

### Going Out

| Aspect | Reality |
|--------|---------|
| Pre-gaming | Start at 11pm-12am |
| Clubs | Open 2am, peak 3-5am |
| Dinner then out | Yes, dinner at 10pm |
| Weeknight out | Thursday is new Friday |
| Sunday | Recovery day, family |

---

## Religion

### Overview

| Religion | Presence |
|----------|----------|
| Catholic | Majority (cultural more than practicing) |
| Jewish | Large community, especially Once |
| Protestant | Growing |
| Secular | Many, especially young |

### Religious Holidays

| Holiday | Notes |
|---------|-------|
| Easter | Major, processions |
| Christmas | Family-focused, Dec 24 dinner |
| Dia de los Muertos | Not big (Mexican tradition) |
| Jewish holidays | Community observes |

---

## Art & Intellectualism

### Buenos Aires Values

| Area | Status |
|------|--------|
| Literature | Highly valued (Borges, Cortazar) |
| Theater | Active scene, Corrientes Ave |
| Visual arts | Museums, galleries |
| Philosophy | Widely discussed |
| Psychoanalysis | More therapists per capita than anywhere |

### Cultural Institutions

| Institution | Type |
|-------------|------|
| Teatro Colon | World-class opera |
| MALBA | Modern Latin American art |
| CCK | Massive cultural center |
| Biblioteca Nacional | National library |
| Various theaters | Along Corrientes |

---

## Gender & Relationships

### Dating

| Aspect | Notes |
|--------|-------|
| Apps | Tinder, Bumble popular |
| Meeting in person | Still common |
| Gender roles | Changing but traditional elements |
| PDA | Acceptable |
| Dating culture | Less formal than US |

### Gender Dynamics

| Aspect | Reality |
|--------|---------|
| Machismo | Exists but evolving |
| Feminist movement | Strong, visible |
| Women's rights | Progressive laws |
| LGBTQ+ rights | Very progressive |

### LGBTQ+

Buenos Aires is **the LGBTQ+ capital of Latin America**:
- Same-sex marriage legal since 2010
- Pride parade (November) is huge
- Palermo has LGBTQ+ scene
- Generally welcoming atmosphere

---

## Language Nuances

### Rioplatense Spanish

| Feature | Example |
|---------|---------|
| "Vos" instead of "tu" | "Vos sos" not "tu eres" |
| "Sh" sound for LL/Y | "Calle" = "ca-she" |
| "Che" | Hey, dude (constant use) |
| Italian intonation | Musical, expressive |

### Common Expressions

| Expression | Meaning |
|------------|---------|
| "Che" | Hey, dude |
| "Boludo/a" | Dude (friendly) or idiot (insulting) |
| "Dale" | OK, go ahead |
| "Barbaro" | Great, awesome |
| "Quilombo" | Mess, chaos |
| "Morfar" | Eat (lunfardo slang) |
| "Guita" | Money (slang) |
| "Mina/Tipo" | Girl/Guy (informal) |
