# Buenos Aires Cost of Living Guide 2025-2026

> Last updated: February 2026 | Currency: ARS (Argentine Peso)  
> Blue dollar rate: ~1,200 ARS = $1 USD | Tax: High but income often untaxed for foreigners

## Overview

Buenos Aires is **extremely affordable** for dollar earners. One of the best cost-of-living arbitrage cities in the world. However, locals earning in pesos struggle with 140%+ inflation.

### Quick Summary (USD at Blue Rate)

| Profile | Monthly Cost (USD) | Notes |
|---------|-------------------|-------|
| **Single (budget)** | $800-1,200 | Shared apartment, cook at home |
| **Single (comfortable)** | $1,200-2,000 | Own apartment, eat out regularly |
| **Couple** | $1,500-2,500 | Nice apartment, good lifestyle |
| **Family of 4** | $2,500-5,000 | Depends heavily on school choice |
| **Digital nomad (laptop lifestyle)** | $1,500-2,500 | Coworking, dining, social life |

---

## [House] Housing (30-40% of budget)

### Rental Prices (Monthly USD at Blue Rate)

| Area | Studio | 1BR | 2BR | 3BR |
|------|--------|-----|-----|-----|
| Puerto Madero | $600-800 | $800-1,200 | $1,200-1,800 | $1,800-3,000 |
| Recoleta | $400-550 | $500-800 | $700-1,100 | $1,000-1,600 |
| Palermo Soho | $400-550 | $500-750 | $650-1,000 | $900-1,400 |
| Palermo Hollywood | $380-500 | $450-700 | $600-900 | $850-1,300 |
| Belgrano | $350-450 | $400-600 | $550-850 | $750-1,200 |
| Villa Crespo | $300-400 | $350-500 | $500-750 | $650-1,000 |
| San Telmo | $280-380 | $350-500 | $450-700 | $600-900 |
| Almagro | $220-320 | $280-420 | $380-600 | $500-800 |
| Caballito | $250-350 | $300-450 | $400-650 | $550-850 |

### Additional Housing Costs

| Expense | Monthly (USD) | Notes |
|---------|---------------|-------|
| Expensas (building fees) | $50-200 | Covers building services |
| Utilities (gas, electric) | $20-60 | Subsidized, still cheap |
| Internet | $20-40 | Fiber available |
| Water | ~$5-10 | Very cheap |
| Renter's deposit | 1-2 months | One-time |

### Rent Payment

- **Short-term (tourist):** USD cash common
- **Long-term (contract):** Increasingly USD-indexed
- **Traditional peso contracts:** Adjust with inflation (law changed)
- **Foreigners:** Often pay USD, avoid peso inflation mess

---

## [Food] Food & Dining

### Grocery Prices (USD at Blue Rate)

| Item | Price |
|------|-------|
| Bread (1kg) | $1-2 |
| Milk (1L) | $0.80-1.20 |
| Eggs (dozen) | $2-3 |
| Chicken breast (1kg) | $4-6 |
| Beef (1kg) | $5-10 |
| Rice (1kg) | $1-2 |
| Pasta (500g) | $0.80-1.50 |
| Tomatoes (1kg) | $1-2 |
| Apples (1kg) | $1.50-2.50 |
| Wine (decent bottle) | $3-8 |
| Beer (6-pack) | $3-5 |

### Monthly Grocery Budget

| Style | Monthly (USD) |
|-------|---------------|
| Very budget | $100-150 |
| Normal cooking | $150-250 |
| Quality ingredients | $250-400 |

### Dining Out (USD at Blue Rate)

| Type | Cost |
|------|------|
| Empanada | $1-1.50 each |
| Pizza slice | $1.50-3 |
| Quick lunch (menu del dia) | $5-8 |
| Casual restaurant dinner | $10-20 |
| Nice restaurant dinner | $25-50 |
| Don Julio steak dinner | $50-80 |
| Fine dining tasting menu | $80-150 |
| Coffee (cafe con leche) | $1.50-3 |
| Craft beer (bar) | $3-5 |
| Cocktail | $5-10 |

### Monthly Food Budget

| Style | Groceries + Dining (USD) |
|-------|--------------------------|
| Budget (cook mostly) | $200-300 |
| Balanced | $350-500 |
| Foodie lifestyle | $500-800+ |

---

## [Metro] Transportation

### Public Transit (SUBE Card)

| Type | Cost (USD) |
|------|------------|
| Subte (metro) ride | ~$0.40-0.50 |
| Bus (colectivo) ride | ~$0.30-0.40 |
| Monthly unlimited (estimate) | ~$15-25 |

**Note:** Some of cheapest public transit in the world.

### Taxis & Rideshare

| Type | Cost |
|------|------|
| Short taxi (Palermo to Recoleta) | $3-5 |
| Medium (Palermo to Centro) | $5-8 |
| Long (Airport) | $15-25 |
| Uber/Cabify | Similar to taxi |

### Monthly Transport Budget

| Style | Monthly (USD) |
|-------|---------------|
| Public transit only | $15-30 |
| Mixed (transit + occasional taxi) | $40-80 |
| Regular taxi/Uber use | $100-200 |
| Car ownership | $200-400+ |

---

## [Hospital] Healthcare

### Overview

Argentina has excellent, affordable healthcare:
- **Public hospitals:** Free for everyone (including foreigners)
- **Private healthcare:** High quality, very affordable
- **Pharmacies:** Many medications available without prescription

### Private Healthcare Costs (USD)

| Service | Cost |
|---------|------|
| GP consultation | $20-50 |
| Specialist | $40-80 |
| Dental cleaning | $30-60 |
| Dental filling | $30-50 |
| Blood work (panel) | $30-60 |
| Private health insurance (monthly) | $50-150 |

### Prepaid Medicine (Obra Social Privada)

Monthly plans (USD):
| Plan | Cost |
|------|------|
| Basic (OSDE 210 equivalent) | $50-80 |
| Good (OSDE 310) | $80-120 |
| Premium (OSDE 510) | $120-200 |

---

## [Phone] Communications

| Service | Monthly (USD) |
|---------|---------------|
| Mobile plan (good data) | $10-25 |
| Home internet (fiber) | $20-40 |
| Landline | ~$5 (rare now) |

---

## [Edu] Education

### Private School Fees (Annual USD)

| Type | Range |
|------|-------|
| Argentine bilingual | $3,000-8,000 |
| British curriculum | $8,000-15,000 |
| American curriculum | $10,000-25,000 |
| IB schools | $15,000-30,000 |

### University

| Type | Annual |
|------|--------|
| Public university (UBA) | Free |
| Private university | $5,000-15,000 |
| MBA programs | $10,000-30,000 |

---

## [Fun] Lifestyle & Entertainment

### Monthly Costs (USD)

| Activity | Cost |
|----------|------|
| Gym membership (nice) | $30-60 |
| Yoga/Pilates class | $5-10/class |
| Movie ticket | $5-8 |
| Theater ticket | $10-30 |
| Club entry | $10-20 |
| Tango lesson | $10-20/class |
| Netflix | ~$5 |
| Spotify | ~$3 |

### Coworking

| Type | Monthly (USD) |
|------|---------------|
| Budget coworking | $50-100 |
| Mid-range | $100-150 |
| Premium (WeWork) | $150-250 |
| Day pass | $10-20 |

### Personal Care (USD)

| Service | Cost |
|---------|------|
| Haircut (men) | $8-15 |
| Haircut (women) | $20-50 |
| Massage (1hr) | $20-40 |
| Manicure | $10-20 |

---

## [Clean] Domestic Help

One of BA's great values: affordable domestic help.

| Service | Cost (USD) |
|---------|------------|
| Cleaning (3hrs) | $15-25 |
| Full-day cleaner | $30-50 |
| Live-in domestic | $400-600/month |
| Laundry service (by kilo) | $2-4/kg |
| Dog walker (monthly) | $50-100 |

---

## [Stats] Monthly Budget Examples

### Budget Single ($800-1,200)

| Category | Monthly (USD) |
|----------|---------------|
| Rent (shared/studio outer) | $300-400 |
| Utilities/internet | $40-60 |
| Groceries | $150-200 |
| Dining out (limited) | $100-150 |
| Transport | $30-50 |
| Phone | $15 |
| Entertainment | $50-100 |
| Misc | $50-100 |
| **Total** | **$735-1,075** |

### Comfortable Single ($1,500-2,000)

| Category | Monthly (USD) |
|----------|---------------|
| Rent (1BR Palermo area) | $500-650 |
| Utilities/internet | $60-80 |
| Groceries | $200-250 |
| Dining out (regular) | $250-350 |
| Transport | $60-100 |
| Phone | $20 |
| Gym | $40 |
| Entertainment | $100-200 |
| Misc | $100-150 |
| **Total** | **$1,330-1,850** |

### Couple Comfortable ($2,000-3,000)

| Category | Monthly (USD) |
|----------|---------------|
| Rent (2BR nice area) | $700-1,000 |
| Utilities/internet | $80-100 |
| Groceries | $300-400 |
| Dining out | $400-600 |
| Transport | $100-150 |
| Phones | $40 |
| Gym (2) | $80 |
| Entertainment | $200-300 |
| Misc | $150-250 |
| **Total** | **$2,050-2,920** |

### Family of 4 ($3,500-6,000+)

| Category | Monthly (USD) |
|----------|---------------|
| Rent (3BR good area) | $1,000-1,500 |
| Utilities/internet | $100-150 |
| Groceries | $500-700 |
| Dining out | $300-500 |
| School fees (2 kids) | $800-2,500 |
| Transport | $150-250 |
| Healthcare (family) | $150-300 |
| Entertainment | $200-400 |
| Activities (kids) | $100-200 |
| Misc | $200-300 |
| **Total** | **$3,500-6,800** |

---

## [Tip] Money-Saving Tips

1. **Exchange at blue rate** - Never use official rate
2. **Shop at Carrefour/Coto** - Best supermarket prices
3. **Cook at home** - Quality ingredients, huge savings
4. **Use public transport** - $0.40 vs $5 taxi
5. **Lunch "menu del dia"** - Restaurants offer fixed lunch specials
6. **Feria (street markets)** - Fresh produce cheaper
7. **Local neighborhoods** - Almagro/Caballito cheaper than Palermo
8. **Happy hours** - Many bars have good deals
9. **Buy local brands** - Imported goods expensive
10. **Negotiate rent** - Especially for longer stays

---

## [!] Hidden Costs & Traps

1. **Imported goods:** Electronics, clothes cost 2-3x US prices
2. **Peso contracts:** Can inflate rapidly
3. **Building expensas:** Can be significant
4. **Tipping:** 10% adds up
5. **International shipping:** Very expensive
6. **Private schools:** Fees increase with inflation
7. **Card payments:** Official rate = 30% loss
