# Buenos Aires Climate Guide

## Overview

Buenos Aires has a **humid subtropical climate**. Four distinct seasons, but milder than you might expect.

### Quick Summary

| Season | Months | Temp Range | Notes |
|--------|--------|------------|-------|
| Summer | Dec-Feb | 25-35C (77-95F) | Hot, humid, January exodus |
| Autumn | Mar-May | 15-25C (59-77F) | Best weather |
| Winter | Jun-Aug | 8-17C (46-63F) | Cold, gray, damp |
| Spring | Sep-Nov | 15-25C (59-77F) | Best weather, jacarandas |

---

## Monthly Breakdown

### January-February (Peak Summer)

| Factor | Reality |
|--------|---------|
| Temperature | 28-35C (82-95F) |
| Humidity | High (70-80%) |
| Rain | Occasional thunderstorms |
| City vibe | Empty (locals leave) |
| Prices | Some deals (low season for locals) |

**Survival tips:**
- Air conditioning essential
- Hydrate constantly
- Siesta hours (2-5pm) are real
- Many businesses close in January
- Beach trip to coast (Mar del Plata)

### March-May (Autumn)

| Factor | Reality |
|--------|---------|
| Temperature | 15-25C (59-77F) |
| Humidity | Moderate |
| Rain | Increasing toward May |
| City vibe | Best time, everyone back |
| Prices | Normal |

**Why it's great:**
- Perfect outdoor weather
- All businesses open
- Outdoor dining excellent
- Parks beautiful

### June-August (Winter)

| Factor | Reality |
|--------|---------|
| Temperature | 8-17C (46-63F) |
| Humidity | High (damp cold) |
| Rain | Common |
| City vibe | Indoor activities |
| Prices | Low season |

**Survival tips:**
- Bring layers (buildings poorly heated)
- Expect gray skies
- Indoor heating often minimal
- Great for museums, cafes, tango
- Ski trips to Patagonia possible

### September-November (Spring)

| Factor | Reality |
|--------|---------|
| Temperature | 15-25C (59-77F) |
| Humidity | Moderate |
| Rain | Occasional |
| City vibe | Excellent, jacarandas bloom |
| Prices | Increasing toward December |

**Highlights:**
- Jacarandas (purple trees) in November
- Perfect weather
- Outdoor festivals
- Parks at their best

---

## What to Pack

### Summer (Dec-Feb)

| Essential | Nice to Have |
|-----------|--------------|
| Light cotton clothes | Hat/sunglasses |
| Sandals | Sunscreen |
| Light cardigan (AC is cold) | Portable fan |
| Umbrella (thunderstorms) | Beach gear |

### Winter (Jun-Aug)

| Essential | Nice to Have |
|-----------|--------------|
| Warm jacket | Scarf |
| Layers | Gloves |
| Closed shoes | Hot water bottle |
| Umbrella | Indoor slippers |
| Warm sleepwear | Space heater |

### Shoulder Seasons

| Essential |
|-----------|
| Layers (mornings cold, afternoons warm) |
| Light jacket |
| Mix of short/long sleeves |
| Walking shoes |

---

## Indoor Climate Reality

### Summer

| Challenge | Reality |
|-----------|---------|
| Air conditioning | Common but not universal |
| Electricity | Can be expensive |
| Power cuts | Occasional during heat waves |
| Public transit | Subte can be brutal |

**Tips:**
- Confirm AC before booking apartment
- Budget for electricity
- Shopping malls are free AC
- Cafes are refuge

### Winter

| Challenge | Reality |
|-----------|---------|
| Central heating | Rare in older buildings |
| Space heaters | Common alternative |
| Gas | Can be expensive |
| Hot water | Usually fine |

**Tips:**
- Ask about heating before renting
- Bring warm indoor clothes
- Electric blankets popular
- Cafes are warm refuge

---

## Weather Events

### Sudestada

Strong southeastern wind bringing:
- Heavy rain
- Flooding in some areas (La Boca, Puerto Madero)
- Cold, miserable conditions
- Can last several days

**When:** Most common in autumn/winter

### Summer Storms

- Sudden, intense thunderstorms
- Can cause localized flooding
- Usually pass within hours
- Check forecast before outdoor plans

### Heat Waves

- Occasional 40C+ days in summer
- Can last several days
- Power grid stressed
- Stay hydrated, avoid midday sun

---

## Seasonal Activities

### Summer

| Activity | Notes |
|----------|-------|
| Parks (early morning) | Before heat |
| Outdoor pools | Some buildings have |
| Night dining | Cooler after 9pm |
| Beach trips | Mar del Plata, Uruguay |
| Escape to Patagonia | Cool relief |

### Winter

| Activity | Notes |
|----------|-------|
| Museums | Warm and cultural |
| Indoor markets | Mercado de San Telmo |
| Tango milongas | Perfect season |
| Cafe hopping | Classic porteno activity |
| Theater season | Teatro Colon season |
| Wine bars | Cozy evenings |

### Spring/Autumn

| Activity | Notes |
|----------|-------|
| Walking tours | Perfect weather |
| Outdoor dining | Prime terrace season |
| Park activities | Bosques de Palermo |
| Day trips | Tigre, estancias |
| Photography | Best light |

---

## January: Special Considerations

**The city empties out.** Many portenos take vacation all month.

### What Closes

- Family-owned restaurants
- Some specialty shops
- Local businesses
- Some medical offices

### What Stays Open

- Tourist areas (Palermo, San Telmo)
- Hotels and major restaurants
- Shopping centers
- Cultural attractions

### Why Visit Anyway

- Lower prices
- Fewer crowds at attractions
- Beach access (if you travel)
- Different energy

---

## Best Time to Visit

### For Perfect Weather
**March-April or October-November**

| Factor | Spring/Fall |
|--------|-------------|
| Temperature | 18-25C |
| Crowds | Moderate |
| Prices | Reasonable |
| Everything open | Yes |

### For Budget
**June-August (excluding July school holidays)**

| Factor | Winter |
|--------|--------|
| Hotel prices | Lowest |
| Flight prices | Usually lower |
| Restaurants | Available tables |
| Weather | Cold but manageable |

### For Events

| Event | When |
|-------|------|
| Tango Festival | August |
| Book Fair | April |
| Pride | November |
| Art Week | Multiple |
| Vendimia (wine harvest) | March (Mendoza) |

---

## Climate vs What to Expect

### Common Misconceptions

| Myth | Reality |
|------|---------|
| "It's South America, always hot" | Winter is cold! |
| "Mediterranean climate" | More humid |
| "Just like southern Europe" | Seasons reversed |
| "I won't need AC" | Summer is brutal |
| "Indoor heating is fine" | Often minimal |

### From Different Regions

| If From | Expect |
|---------|--------|
| Northern Europe | Summer much hotter, winter comparable |
| Southern US | Similar humidity, winter colder |
| Australia | Seasons opposite but similar patterns |
| Northern US | Summer similar, winter milder |
| Southeast Asia | Winter is a shock |
