# Buenos Aires Business Setup Guide

## Company Types

### Available Structures

| Structure | Best For | Complexity | Foreign Ownership |
|-----------|----------|------------|-------------------|
| SAS | Startups, SMEs | Low | Yes |
| SRL | Traditional business | Medium | Yes |
| SA | Large companies | High | Yes |
| Sucursal | Foreign branch | Medium | Parent company |
| Sole proprietor | Freelancers | Very low | Individuals |

---

## SAS (Sociedad por Acciones Simplificada)

**The default choice for new businesses.**

### Characteristics

| Feature | Details |
|---------|---------|
| Minimum capital | ~$200 USD |
| Shareholders | 1 or more |
| Registration | Online, fast |
| Governance | Flexible |
| Annual requirements | Moderate |

### Setup Process

| Step | Time | Notes |
|------|------|-------|
| Reserve name | 1 day | Online |
| Digital signature (certificado) | 1-2 days | Required |
| Statute drafting | 1-2 days | Lawyer helps |
| Online submission | 1 day | IGJ portal |
| CUIT (tax ID) | 3-5 days | AFIP |
| Bank account | 1-2 weeks | With CUIT |

**Total:** 2-4 weeks

### Costs

| Item | Cost (USD) |
|------|------------|
| Government fees | $200-400 |
| Legal assistance | $300-1,000 |
| Digital signature | $50 |
| Notary (if needed) | $200-500 |
| **Total** | **$500-2,000** |

---

## SRL (Sociedad de Responsabilidad Limitada)

**Traditional limited liability company.**

### When to Use

- Established business
- More formal structure needed
- Real estate holdings
- Specific regulatory requirements

### Characteristics

| Feature | Details |
|---------|---------|
| Minimum capital | Variable |
| Partners | 2-50 |
| Registration | Notary required |
| Governance | More structured |
| Annual requirements | Higher |

### Costs

Higher than SAS due to notary requirements.

---

## Branch of Foreign Company (Sucursal)

### When to Use

- Foreign company wants legal presence
- No separate legal entity needed
- Parent company liable

### Process

| Step | Notes |
|------|-------|
| Legalize parent documents | Apostille |
| Translate documents | Certified |
| Register with IGJ | Public registry |
| Obtain CUIT | Tax ID |

**Time:** 2-3 months
**Cost:** $3,000-10,000

---

## Registration Requirements

### Essential Registrations

| Registration | Purpose | Where |
|--------------|---------|-------|
| CUIT | Tax identification | AFIP |
| IGJ/DPPJ | Commercial registry | Province |
| IIBB | Gross receipts tax | City/Province |
| IVA | Value-added tax | AFIP (if applicable) |

### City of Buenos Aires Specific

| Registration | For |
|--------------|-----|
| ABL | Property taxes |
| Habilitacion | Physical location permit |
| IIBB CABA | City gross receipts |

---

## Tax Overview

### Main Taxes

| Tax | Rate | Notes |
|-----|------|-------|
| Corporate income (Ganancias) | 25-35% | Progressive |
| VAT (IVA) | 21% | On sales |
| Gross receipts (IIBB) | 1-5% | Varies by activity/location |
| Employer payroll taxes | ~24% | On wages |
| Withholdings | Various | On payments |

### Tax Calendar

| Tax | Frequency |
|-----|-----------|
| VAT | Monthly |
| Income tax | Annual (advances monthly) |
| IIBB | Monthly |
| Payroll | Monthly |

### Tax Complexity

Argentina has **complex taxes**. Essentials:
- Good accountant (contador) from day 1
- Understand withholding requirements
- Plan for cash flow (many advance payments)
- Stay current or face penalties

---

## Hiring Employees

### Employment Law Basics

| Aspect | Reality |
|--------|---------|
| Minimum wage | ~$350 USD/month (2026) |
| Standard hours | 48/week max |
| Vacation | 14-35 days depending on tenure |
| Termination | Severance required |
| Notice period | 15 days - 2 months |

### Employment Costs

| Component | Rate |
|-----------|------|
| Base salary | 100% |
| Employer contributions | ~24% |
| Aguinaldo (13th salary) | 8.33% |
| Vacation provision | 4-8% |
| **Total cost** | **~136-140%** of base |

### Severance

| Tenure | Severance |
|--------|-----------|
| Under 3 months | None (trial period) |
| Under 5 years | 1 month per year |
| Over 5 years | 1 month per year |
| Plus notice | 1-2 months |

### Alternative Arrangements

| Type | Notes |
|------|-------|
| Contractor (monotributista) | Common but risky if misclassified |
| Temporary | Through agencies |
| Part-time | Proportional benefits |

---

## Office & Location

### Commercial Lease

| Factor | Typical Terms |
|--------|---------------|
| Duration | 3 years minimum (commercial) |
| Payment | Monthly, often USD-indexed |
| Deposit | 1-2 months |
| Adjustment | Inflation-indexed |
| Notice | 3-6 months |

### Coworking Alternative

| Type | Monthly (USD) |
|------|---------------|
| Hot desk | $100-150 |
| Dedicated desk | $150-250 |
| Private office | $300-1,000+ |
| Virtual office | $50-100 |

### Location Considerations

| Area | Best For |
|------|----------|
| Microcentro | Banks, professional services |
| Puerto Madero | Corporate, international |
| Palermo | Tech, creative, startups |
| Belgrano | Tech, family businesses |
| Industrial zones | Manufacturing, logistics |

---

## Banking

### Corporate Bank Accounts

| Bank | Type | Notes |
|------|------|-------|
| Santander | International | Good for foreign-owned |
| HSBC | International | Similar |
| Galicia | Local | Large local bank |
| BBVA | International | Good digital |
| Macro | Local | Smaller business focus |

### Account Requirements

| Document | Notes |
|----------|-------|
| Company registration | IGJ certificate |
| CUIT | Tax ID |
| Statute | Company bylaws |
| ID of representatives | Passport/DNI |
| Proof of address | Utility bill or contract |

### Account Types

| Type | For |
|------|-----|
| Cuenta corriente | Operating account |
| Caja de ahorro | Savings |
| Cuenta en USD | Dollar holdings (limited) |
| Payroll account | Employee payments |

---

## Import/Export

### Overview

Argentina has **significant trade barriers**:
- Import duties
- Complex customs
- Foreign exchange controls
- Licensing requirements

### Import Process

| Step | Notes |
|------|-------|
| Customs broker | Required for imports |
| Import license | May be needed |
| Duties | 0-35%+ depending on product |
| VAT on import | 21% |
| Statistical fee | 0.5% |

### Export Incentives

| Incentive | Benefit |
|-----------|---------|
| Export drawback | Duty refunds |
| Free trade zones | Reduced taxes |
| Bilateral agreements | Some preferential treatment |

---

## Accounting & Compliance

### Required Records

| Record | Retention |
|--------|-----------|
| Accounting books | 10 years |
| Tax filings | 10 years |
| Payroll records | 10 years |
| Contracts | Duration + 5 years |

### Annual Requirements

| Requirement | Deadline |
|-------------|----------|
| Financial statements | Within 4 months of fiscal year end |
| Tax returns | April (calendar year) |
| Assembly/shareholder meeting | Annual |
| IGJ filings | Annual |

### Finding an Accountant

| Quality | Cost (Monthly USD) |
|---------|-------------------|
| Basic compliance | $100-200 |
| Full service | $200-400 |
| Larger firm | $400-1,000+ |

---

## Professional Services

### Essential Partners

| Service | When |
|---------|------|
| Contador (accountant) | Day 1 |
| Abogado (lawyer) | Formation, contracts |
| Despachante (customs broker) | If importing |
| Escribano (notary) | Some transactions |

### Finding Professionals

| Source | Notes |
|--------|-------|
| Referrals | Best method |
| Professional associations | Certified |
| Expat networks | English-speaking |
| Chambers of commerce | Vetted lists |
