---
name: Buenos Aires
slug: buenos-aires
version: 1.0.1
changelog: Unicode cleanup for ClawHub compatibility, added Scope section
homepage: https://clawic.com/skills/buenos-aires
description: Navigate Buenos Aires as visitor, resident, tech worker, student, or entrepreneur with neighborhoods, transport, costs, visas, and local insights.
metadata: {"clawdbot":{"emoji":"AR","requires":{"bins":[]},"os":["linux","darwin","win32"]}}
---

## When to Use

User asks about Buenos Aires for any purpose: visiting, moving, working, studying, or starting a business. Agent provides practical guidance with current data.

## Quick Reference

| Topic | File |
|-------|------|
| **Visitors** | |
| Attractions (must-see vs skip) | `visitor-attractions.md` |
| Itineraries (1/3/7 days) | `visitor-itineraries.md` |
| Where to stay | `visitor-lodging.md` |
| Tips & day trips | `visitor-tips.md` |
| **Neighborhoods** | |
| Quick comparison | `neighborhoods-index.md` |
| Palermo, Belgrano, Nunez | `neighborhoods-norte.md` |
| Microcentro, San Nicolas, Retiro | `neighborhoods-centro.md` |
| San Telmo, La Boca, Barracas | `neighborhoods-sur.md` |
| Caballito, Almagro, Villa Crespo | `neighborhoods-oeste.md` |
| Puerto Madero, Recoleta | `neighborhoods-premium.md` |
| Choosing guide | `neighborhoods-choosing.md` |
| **Food** | |
| Overview & dining scene | `food-overview.md` |
| Argentine cuisine | `food-local.md` |
| International & fine dining | `food-international.md` |
| Best areas for dining | `food-areas.md` |
| Dietary, tipping, customs | `food-practical.md` |
| **Practical** | |
| Moving & settling | `resident.md` |
| Transport (subte, colectivos, taxis) | `transport.md` |
| Cost of living | `cost.md` |
| Safety & security | `safety.md` |
| Weather & seasonal tips | `climate.md` |
| Local services (banking, SIM) | `local.md` |
| **Career** | |
| Tech industry & salaries | `tech.md` |
| Business setup & regulations | `business.md` |
| Visas (work, residency, digital nomad) | `visas.md` |
| Startups & funding | `startup.md` |
| **Lifestyle** | |
| Culture & customs | `culture.md` |
| Healthcare & insurance | `healthcare.md` |
| Schools & education | `education.md` |
| Expat lifestyle & social | `lifestyle.md` |
| Driving & car ownership | `driving.md` |

## Core Rules

### 1. Identify User Context First
- **Role**: Tourist, resident, tech worker, student, entrepreneur, digital nomad
- **Timeline**: Short visit, planning to move, already there
- Load relevant auxiliary file for details

### 2. Economic Context (Critical)
Argentina has chronic inflation (~140% annually in 2024) and currency controls:
- **Official rate vs "blue dollar"**: Significant gap (30-40% historically)
- **MEP/CCL rates**: Legal alternatives for better exchange
- **Crypto adoption**: Very high due to currency instability
- **Dollar preference**: Many transactions quoted in USD
See `cost.md` for current rates and strategies.

### 3. Cultural Context
Buenos Aires is the most European city in South America:
- **Spanish influence**: Architecture, cafe culture, late dining
- **Italian influence**: 60%+ of population has Italian ancestry, affects food and gestures
- **Tango**: Cultural institution, not just for tourists
- **Futbol (soccer)**: Religion-level passion, Boca vs River divides the city
- **Late night culture**: Dinner at 10pm, clubs open at 2am
See `culture.md` for detailed guidance.

### 4. Weather Reality
- **Summer (Dec-Feb)**: 28-35C, humid, many locals leave in January
- **Winter (Jun-Aug)**: 8-15C, gray, limited heating in buildings
- **Best months**: March-May (autumn), September-November (spring)
- **No central heating**: Most apartments use space heaters
See `climate.md` for monthly breakdown.

### 5. Current Data (Feb 2026)

| Item | Range (USD at blue rate) |
|------|--------------------------|
| 1BR rent (Palermo) | $400-700/month |
| 1BR rent (Recoleta) | $500-800/month |
| 1BR rent (outer barrios) | $250-400/month |
| Senior SWE salary (USD) | $3,000-6,000/month |
| Subte monthly pass | ~$15 |
| Dinner for 2 (nice restaurant) | $30-60 |
| Asado for 4 at home | $20-30 |

### 6. Cost Reality
Buenos Aires is very affordable for dollar earners:
- **Housing**: 20-30% of budget typical for expats
- **Food**: Excellent quality at low prices (especially beef, wine)
- **Services**: Very cheap (cleaning, laundry, repairs)
- **Tech salaries**: Often paid in USD, huge advantage
- **Hidden costs**: Importing goods expensive, electronics cost 2-3x US prices

### 7. Transit Options
Buenos Aires has good public transport, especially vs other LATAM cities:
- **Subte**: 6 lines, cheap, crowded at rush hour
- **Colectivos (buses)**: 140+ lines, 24/7, covers entire city
- **Taxis/Ride-hailing**: Cheap, Uber/Cabify widely used
- **SUBE card**: Essential for all public transport
Most residents don't own cars in central areas. See `transport.md`.

### 8. Neighborhood Matching

| Profile | Best Areas |
|---------|------------|
| Young professionals/Digital nomads | Palermo Soho, Palermo Hollywood, Villa Crespo |
| Families | Belgrano, Nunez, Caballito |
| Budget-conscious expats | Almagro, Boedo, Villa Crespo |
| Luxury seekers | Puerto Madero, Recoleta |
| Artists/Bohemian | San Telmo, La Boca (Caminito area only) |
| Tech workers | Palermo, Belgrano, Puerto Madero |

## Visa Context

Unlike Dubai, Argentina has relatively easy immigration:
- **Tourist visa**: 90 days, extendable once (180 total)
- **Digital nomad visa**: 6-12 months, renewable
- **Work visa**: Employer-sponsored, becoming more common in tech
- **Residency**: Relatively easy through rentista, investor, or ancestry
- **Citizenship**: Possible after 2 years of residency
See `visas.md` for detailed requirements.

## Buenos Aires-Specific Traps

- **Blue dollar confusion** - Always know the parallel rate. Official rate = losing 30-40%.
- **January exodus** - City empties out. Many businesses close. Plan around it.
- **Crime awareness** - Express kidnapping, phone theft common. Be street smart.
- **Building heating** - Central heating rare. Winter apartments get COLD.
- **Sunday closures** - Many restaurants/shops closed Sundays, especially outside Palermo.
- **Cash dependency** - Despite crypto adoption, many places cash-only (at blue rate).
- **Import taxes** - Electronics, clothes, anything imported costs 2-3x.
- **Restaurant tipping** - 10% expected, but some include "cubierto" (cover charge).
- **Spanish requirement** - Less English spoken than expected. Learn basics.
- **Afternoon closure** - Some businesses close 1-5pm (siesta culture).

## Safety Awareness

Buenos Aires is generally safe but requires street smarts:
- **Tourist areas**: Well-patrolled, relatively safe
- **Phone theft**: Very common, don't use phone obviously on street
- **Express kidnapping**: Rare but real, avoid displaying wealth
- **ATMs**: Use inside banks, never at night
- **Areas to avoid**: La Boca (outside Caminito), Once at night, Constitucion
See `safety.md` for comprehensive guidance.

## Expat Community

Buenos Aires has a large, established expat community:
- **Digital nomad hubs**: Palermo cafes, coworking spaces
- **Expat groups**: Active Facebook groups, meetups
- **Languages spoken**: Spanish dominant, English in tech/tourism
- **Integration**: Easier than many cities due to welcoming culture
- **Dating scene**: Active, Tinder/Bumble popular

## Legal Awareness

Key laws visitors/residents should know:
- **Marijuana**: Decriminalized for personal use, but selling illegal
- **Alcohol**: Legal at 18, widely available
- **Protests**: Common, mostly peaceful, avoid area during
- **Photography**: Generally permitted, ask before photographing people
- **Noise laws**: Exist but loosely enforced, expect late-night noise
- **Consumer rights**: Strong protection laws, refunds possible

## Scope

This skill ONLY:
- Provides information about Buenos Aires for visitors, residents, and workers
- References auxiliary files with detailed neighborhood, food, and practical guides
- Gives current data on costs, visas, and local services

This skill NEVER:
- Makes network requests or API calls
- Accesses calendar, email, or contacts
- Stores data or creates files
- Executes code or scripts
- Modifies its own SKILL.md
