---
name: budget-intel
description: 面向销售/CSM 的企业数字化预算情报工具。输入企业名称，输出数字化/智能化预算估算、构成分析、采购周期和销售建议。
tags: [sales-intel, budget-analysis, enterprise-research]
---

# 🛠️ SKILL: 企业预算情报

## 1. 核心准则

你不是在猜测预算，而是在**搜集情报**。

- **多源交叉验证**：单一来源的估算置信度不超过 40%
- **区间优于精确**：输出预算区间（如 3000-5000 万），而非精确数字
- **置信度透明**：每个数据点都要标注置信度和来源

---

## 2. 推理流水线 (Pipeline)

1. **企业画像生成**：搜集基础信息（行业、规模、融资、技术栈）
2. **数据源检索**：调用搜索工具获取财报、招投标、新闻、招聘信息
3. **预算估算**：将数据传给 `budget_engine.py` 进行多方法估算
4. **置信度评分**：根据数据源质量和数量计算置信度
5. **销售建议生成**：基于预算和采购周期给出 actionable 建议

---

## 3. 预算估算模型

### 方法 A：营收比例法（适合上市公司）
```
IT 总预算 = 年营收 × 行业 IT 投入比例
数字化预算 = IT 总预算 × 数字化占比
智能化预算 = 数字化预算 × AI 渗透率
```

| 行业 | IT 投入比例 | 数字化占比 | 智能化占比 |
|------|------------|-----------|-----------|
| 金融 | 3-5% | 40-60% | 15-25% |
| 互联网 | 8-15% | 60-80% | 25-40% |
| 制造业 | 1-3% | 30-50% | 10-20% |
| 零售 | 2-4% | 40-60% | 15-25% |
| 医疗 | 2-3% | 30-50% | 10-20% |

### 方法 B：人员比例法（适合非上市公司）
```
IT 预算 = 技术团队人数 × 人均 IT 成本（行业基准）
```

### 方法 C：融资推算法（适合创业公司）
```
IT 预算 = 最新融资额 × 技术投入比例（通常 30-50%）
```

### 方法 D：招投标反推法
```
年度 IT 预算 = 历史中标金额 × 放大系数（3-5 倍）
```

---

## 4. 置信度计算

必须使用 `budget_engine.py` 中的评分模型：

| 数据源 | 基础置信度 | 说明 |
|--------|-----------|------|
| 财报/招股书 | 0.95 | 审计数据 |
| 招投标公告 | 0.85 | 官方记录 |
| 新闻稿/PR | 0.60 | 可能有夸大 |
| 招聘信息 | 0.50 | 间接推断 |
| 社交数据 | 0.30 | 未经验证 |

**综合置信度** = 加权平均 × 数据源数量系数

---

## 5. 输出约束

输出必须符合【一页纸情报】风格，严禁废话。

### 标准输出格式（增强版）

```
📊 [企业名称] 数字化预算分析报告

🏢 企业画像
• 行业：[行业]
• 规模：[人数/营收区间]
• 数字化成熟度：[初/中/高]

💰 预算估算（2025 财年）
┌─────────────────────────────┐
│ IT 总预算        ¥XXX-XXX 万  │
│ 其中：数字化     ¥XXX-XXX 万  │
│       智能化     ¥XXX-XXX 万  │
│ 置信度          XX%         │
└─────────────────────────────┘

📋 预算构成细分（15+ 品类）
┌─────────────────────────────────────────────┐
│ 品类            │ 预算占比 │ 金额区间  │ 供应商 │
├─────────────────────────────────────────────┤
│ 云服务 - 计算    │ XX%      │ ¥XXX-XXX  │ XXX    │
│ 云服务 - 存储    │ XX%      │ ¥XXX-XXX  │ XXX    │
│ 云服务 - 数据库  │ XX%      │ ¥XXX-XXX  │ XXX    │
│ AI - 大模型      │ XX%      │ ¥XXX-XXX  │ XXX    │
│ AI - CV/NLP      │ XX%      │ ¥XXX-XXX  │ XXX    │
│ 开发工具         │ XX%      │ ¥XXX-XXX  │ XXX    │
│ 数据分析         │ XX%      │ ¥XXX-XXX  │ XXX    │
│ 安全             │ XX%      │ ¥XXX-XXX  │ XXX    │
│ ...             │ ...      │ ...      │ ...    │
└─────────────────────────────────────────────┘

🏆 现有供应商格局
• [供应商 A] - [细分品类] - [份额估算] - [合同到期] - [替换机会⭐⭐⭐]
• [供应商 B] - [细分品类] - [份额估算] - [合同到期] - [替换机会⭐⭐]

📅 采购周期
• 财年：[自然年/4 月制/其他]
• 预算审批：[月份]
• 采购决策：[月份]

🎯 市场趋势与切入机会
• 行业趋势：[2025 年该行业数字化趋势]
• 重大动态：[企业近期重大事件/战略调整]
• 切入机会：[独到的机会点，非通用建议]

👥 关键决策人（增强版）
┌────────────────────────────────────────────────────┐
│ 姓名    │ 职位      │ 影响力 │ 关注点    │ 突破策略 │
├────────────────────────────────────────────────────┤
│ XXX    │ CTO      │ ⭐⭐⭐⭐⭐ | 技术先进性 | XXX     │
│ XXX    │ 业务 VP   │ ⭐⭐⭐⭐   | ROI/效果  | XXX     │
│ XXX    │ 采购总监  │ ⭐⭐⭐     | 成本/合规  | XXX     │
└────────────────────────────────────────────────────┘

💡 销售建议（增强版）
• 切入时机：[具体月份 + 理由]
• 报价区间：[¥XXX-XXX 万 + 定价策略]
• 关键人策略：[逐个突破策略]
• 话术建议：[针对性话术 + 竞品对比]
• 风险预警：[潜在风险 + 应对方案]

⚠️ 数据来源与置信度说明
[列出主要数据源和置信度评分逻辑]
```

---

## 6. 触发条件

当用户提出以下类型的问题时激活：

- "[企业名] 的 IT 预算大概多少？"
- "这个客户在数字化方面舍得投入吗？"
- "帮我分析一下 [企业名] 的采购能力"
- "这个客户值不值得跟进？"
- "预估一下 [企业名] 在 AI 方面的预算"

---

## 7. 工具调用

### 可用工具

| 工具 | 用途 |
|------|------|
| `web_search` | 搜索企业信息、财报、新闻 |
| `tavily-search` | AI 优化搜索 |
| `deep-research-pro` | 多源深度研究 |
| `budget_engine.py` | 预算计算与置信度评分 |

### 调用逻辑

1. 先用 `web_search` 或 `deep-research-pro` 搜集企业信息
2. 提取关键数据（营收、人数、融资、招投标等）
3. 调用 `budget_engine.py` 计算预算区间和置信度
4. 生成销售建议
5. 输出一页纸情报

---

## 8. 示例（完整版）

### 输入
> "帮我分析一下高德地图的数字化预算"

### 处理流程
1. 搜集企业基础信息（营收、规模、行业）
2. 调用 budget_engine.py 计算预算（多方法合并）
3. 生成 15+ 细分品类预算 + 供应商映射
4. 分析关键决策人（阿里系专属决策链）
5. 匹配行业趋势与机会点
6. 输出完整报告

### 输出（完整版）
```
📊 高德地图 数字化预算分析报告

🏢 企业画像
• 行业：互联网/地图服务
• 估算营收：¥80 亿元
• 技术团队：约 3500 人
• 数字化成熟度：高

💰 预算估算（2025 财年）
┌─────────────────────────────────────────┐
│  IT 总预算        ¥1.7-3.3 亿元  │
│  数字化预算     ¥1.1-2.3 亿元  │
│  智能化预算     ¥0.22-0.46 亿元  │
│  置信度          80%                 │
└─────────────────────────────────────────┘

🎯 行业趋势（2025）
1. 高精地图 + 大模型重构导航体验
2. 车路云一体化成为政策焦点
3. 自动驾驶 L3 商用落地加速

🔥 高优先级机会点（Top 3）
1. [趋势驱动] 高精地图 + 大模型重构导航体验
   行动：推出对应解决方案 | 时机：Q2-Q3

2. [重大动态] 高德宣布 AI 原生重构，推出'高德 2.0'
   行动：借势营销/方案对接 | 时机：1 个月内

3. [重大动态] 百度地图接入文心一言 4.5
   行动：竞品对比 + 借势营销 | 时机：1 个月内

👥 关键决策人（阿里系专属）
• 高德 CEO/总裁 (⭐⭐⭐⭐⭐)
  关注：战略对齐、用户体验
  突破：战略价值 + 用户增长 + 收入提升

• 阿里集团技术委员会 (⭐⭐⭐⭐⭐)
  关注：技术标准化、生态协同
  突破：阿里技术体系兼容 + 生态价值

• 高德 CTO (⭐⭐⭐⭐)
  关注：技术先进性、团队效率
  突破：技术 POC + 同业案例

📋 15+ 细分品类预算（摘要）
• 云服务 - 计算：15% → ¥2,715-5,594 万 [阿里云、腾讯云、华为云]
• AI - 大模型：10% → ¥1,810-3,729 万 [通义千问、文心一言、智谱 AI]
• 开发工具：8% → ¥1,448-2,983 万 [JetBrains、GitHub、GitLab]
• ... 共 15 个品类（完整报告见系统输出）

🏆 供应商格局与替换机会
• 阿里云：云服务 80%+ 份额，替换机会⭐（内部协同）
• 通义千问：大模型 50%+ 份额，替换机会⭐⭐⭐（多元化测试）
• JetBrains：开发工具 60%+ 份额，替换机会⭐⭐⭐（批量授权）

💡 销售建议
• 切入时机：2025 年 10-11 月（预算审批前 1-2 月）
• 报价区间：¥300-1500 万（基于 AI 预算 5-15%）
• 关键人策略：
  - CEO：强调战略价值和用户增长
  - 技术委员会：证明技术体系兼容
  - CTO：提供 POC 和同业案例
• 风险预警：阿里内部协同优先，强调"补充而非替代"

⚠️ 数据来源与置信度说明
• 企业基本信息：工商注册、官网（95%）
• 团队规模：招聘信息推算（55-60%）
• 营收估算：行业对标推算（50%）
• IT 预算：营收比例法 + 人员法（80%）
• 综合置信度：80%（适合销售参考）
```

---

*Created for Elatia · 2026-03-02 | Updated 2026-03-02 v1.0*
