# Budapest Visitor Tips

## Before You Go

### Documents
- **EU citizens**: ID card sufficient
- **Non-EU**: Passport, check visa requirements
- **Schengen**: 90 days in 180 max without visa
- **Student cards**: ISIC for discounts

### Money
- **Currency**: Hungarian Forint (HUF)
- **Exchange rate**: ~400 HUF = €1 (fluctuates)
- **Cards**: Widely accepted in center, less outside
- **Cash**: Keep some for markets, small shops, tips
- **ATMs**: Use bank ATMs, avoid exchange offices (poor rates)
- **Tip**: Never use airport exchanges

### Apps to Download
- **BKK Futár**: Official transit app, real-time arrivals
- **Bolt**: Ride-hailing (cheaper than taxi)
- **Google Maps**: Works well for transit routing
- **Wise/Revolut**: Best exchange rates for spending
- **Szechenyi/Gellert apps**: Bath booking

### SIM Cards
- **Providers**: Telekom, Vodafone, Yettel
- **Where**: Airport, any mall, provider shops
- **Cost**: ~3,000-5,000 HUF for tourist SIM with data
- **EU roaming**: If you have EU SIM, it works here

### Language
- **Hungarian**: Extremely difficult (not Indo-European)
- **English**: Good in center, tourist areas, young people
- **German**: Older generation may speak it
- **Useful phrases**:
  - Köszönöm (kur-sur-nurm) = Thank you
  - Szia (see-ya) = Hi/Bye (informal)
  - Igen/Nem = Yes/No
  - Elnézést = Excuse me
  - Egészségedre (eg-ay-shay-ged-reh) = Cheers

## Getting There

### From Airport (BUD)
- **Distance**: 16 km southeast of center
- **Bus 200E + Metro**: Cheapest (~900 HUF), 45-60 min
  - Bus to Kőbánya-Kispest → M3 to center
- **Airport shuttle (miniBUD)**: ~5,000 HUF, door-to-door
- **Bolt/Taxi**: ~8,000-12,000 HUF, 25-40 min
- **Private transfer**: Book ahead, ~€25-35

### By Train
- **Keleti**: Main station, international trains
- **Nyugati**: Some domestic + international
- **Déli**: Balaton direction
- All connected by metro

### By Bus
- **Népliget**: Main bus station (Flixbus, etc.)
- **Metro M3** connected

## Getting Around

### Public Transit (BKK)
- **Metro**: 4 lines (M1-M4), clean, frequent
- **Trams**: Extensive network, scenic routes
- **Buses**: Cover everywhere metro doesn't
- **Night buses**: When metro closes (~23:30-4:30)

### Tickets
- **Single**: ~450 HUF (validate on board!)
- **10-pack**: Better value
- **24h pass**: ~2,500 HUF — worth it for heavy use
- **72h pass**: ~5,500 HUF
- **Monthly**: ~9,500 HUF
- **Buy from**: Machines (card/cash), BKK app, newsagents
- **Validation**: MUST validate paper tickets

### Ticket Inspectors
- Plainclothes, show badges
- Fine: ~16,000 HUF on spot, more if you argue
- No excuse for not having valid ticket
- They target tourists, especially near ruin bars

### Taxi/Ride-hailing
- **Bolt**: Best app, cheapest, reliable
- **Főtaxi**: Official taxi, yellow cars, metered
- **NEVER**: Hail random taxis (scam risk)
- **Cost**: ~300-400 HUF/km + base

### Walking
- Very walkable city
- Pest side flat, easy
- Buda side hilly, wear good shoes
- Danube embankments beautiful for walks

### Biking
- **MOL Bubi**: City bike share, ~500 HUF/day
- Improving bike lanes
- Flat on Pest side
- Margaret Island car-free, great for cycling

## Money Tips

### Avoiding Scams
- **Exchange offices**: Terrible rates, avoid completely
- **Restaurant bills**: Check itemized, tourist traps add items
- **"Tourist menus"**: Usually overpriced, order à la carte
- **Taxis**: Only Bolt or official Főtaxi
- **ATMs**: Use bank ATMs, decline dynamic conversion

### Best Exchange
1. Use Wise/Revolut card (best rate)
2. Withdraw from bank ATM in HUF
3. Never exchange at airport/touristy exchanges
4. If must exchange: central banks, compare rates

### Tipping
- **Restaurants**: 10-15% standard (check if included)
- **Bars**: Round up or 10%
- **Taxis**: Round up
- **Hotels**: €1-2/night for housekeeping
- **Thermal baths**: Not expected
- **How**: Say amount when paying or leave on table

### Rough Costs (2026)
| Item | Budget | Mid-range |
|------|--------|-----------|
| Hostel dorm | €12-20 | — |
| Hotel (3★) | — | €50-80 |
| Meal (local) | €5-10 | €15-25 |
| Beer (bar) | €2-3 | €3-5 |
| Coffee | €2-3 | €3-5 |
| Thermal bath | €15-20 | €20-30 |
| Day budget | €40-60 | €80-120 |

## Eating & Drinking

### Meal Times
- **Breakfast**: 7-10am
- **Lunch**: 12-2pm (locals eat main meal here)
- **Dinner**: 7-9pm (later at weekends)
- **Kitchens close**: Often 10-10:30pm

### Restaurant Types
- **Étterem**: Restaurant (formal)
- **Vendéglő**: Tavern (traditional, cheaper)
- **Kávéház**: Coffee house (grand, cakes)
- **Borozó**: Wine bar
- **Söröző**: Beer bar
- **Büfé**: Fast food/cafeteria

### Must-Try Foods
- **Gulyás**: The real goulash (soup, not stew)
- **Lángos**: Fried dough with toppings
- **Kürtőskalács**: Chimney cake
- **Töltött káposzta**: Stuffed cabbage
- **Halászlé**: Fish soup (spicy)
- **Pörkölt**: What foreigners think goulash is
- **Túrós csusza**: Pasta with cottage cheese
- **Dobos torta**: Layer cake with caramel

### Drinking
- **Pálinka**: Fruit brandy, 40-50%, traditional
- **Wine**: Excellent Hungarian wines (Tokaji, Eger, Villány)
- **Beer**: Local craft scene growing
- **Legal age**: 18
- **Ruin bars**: Cheap drinks, amazing atmosphere

### Dietary Notes
- Vegetarian: Improving but meat-heavy cuisine
- Vegan: Trendy in center, harder outside
- Gluten-free: Ask, awareness growing
- Kosher: Jewish Quarter has options

## Thermal Bath Etiquette

### What to Bring
- **Swimsuit**: Required in mixed areas
- **Flip-flops**: Rentable but own is better
- **Towel**: Rentable (~1,500 HUF)
- **Swimming cap**: Required in some pools
- **Lock**: Most provide, some need deposit

### Etiquette
- Shower before entering pools
- No phones in water areas
- Quiet in steam rooms
- Different pools = different temperatures (check)
- Some sections nude (usually marked, single-sex)

### Popular Baths

| Bath | Vibe | Best For |
|------|------|----------|
| Széchenyi | Grand, touristy | First-timers, outdoor |
| Gellért | Elegant, classic | Architecture lovers |
| Rudas | Ottoman, rooftop | Views, authenticity |
| Király | Small, local | True Ottoman experience |
| Lukács | Budget, local | Regulars, cheap entry |
| Palatinus | Outdoor complex | Summer, families |

## Safety

### General
Budapest is very safe for a capital city.
- Violent crime rare against tourists
- Pickpockets exist (transport, tourist areas)
- Watch belongings in ruin bars
- Normal city awareness applies

### Scams to Avoid
- **Pretty women scam**: Attractive women invite to bar → huge bill
- **Taxi overcharging**: Use Bolt or Főtaxi only
- **Exchange offices**: Poor rates, just avoid
- **Street money changers**: Illegal, always a scam
- **"Helpful" strangers at ATMs**: Decline

### Areas
- **No truly dangerous areas** for daytime tourists
- District VIII (Józsefváros): More rough but gentrifying
- Late night District VII: Drunk tourists, occasional trouble
- Use normal awareness after midnight

### Emergency Numbers
- **112**: General emergency (EU standard)
- **104**: Ambulance
- **105**: Fire
- **107**: Police

## Cultural Tips

### Greetings
- Handshake standard for first meeting
- Kiss on both cheeks (right first) common among friends
- Hungarians use formal "you" (Ön) with strangers

### Visiting Homes
- Bring gift (wine, flowers, chocolates)
- Remove shoes at door
- Don't start eating until host says "Jó étvágyat"
- Empty your plate (leaving food can offend)

### Churches
- Dress modestly (shoulders, knees covered)
- Quiet during services
- Photography usually allowed (no flash)
- Small donation appreciated

### Toasting
- "Egészségedre!" (to your health)
- Look people in eyes when clinking
- **Don't clink beer glasses** (historical superstition)
- Clinking wine/pálinka is fine

## Day Trip Essentials

### Szentendre (Art Village)
- **Get there**: HÉV from Batthyány tér (40 min)
- **Do**: Wander cobblestones, galleries, marzipan museum
- **Eat**: Riverside restaurants
- **Combine**: Boat to Visegrád possible

### Visegrád (Castle)
- **Get there**: Bus from Újpest-Városkapu (1 hour)
- **Do**: Climb citadel, royal palace ruins, bobsled
- **Note**: Castle is uphill hike, good shoes needed

### Esztergom (Basilica)
- **Get there**: Train from Nyugati (1.5 hours)
- **Do**: Biggest church in Hungary, walk to Slovakia
- **Note**: Sunday services limit tourist access

### Lake Balaton
- **Get there**: Train from Déli (1.5-2 hours)
- **Summer**: Swimming, sailing, wine
- **Best towns**: Tihany, Balatonfüred, Badacsony
- **Off-season**: Quiet, some places closed

### Etyek (Wine)
- **Get there**: Car/taxi (40 min) or organized tour
- **Do**: Wine tasting, cheese, rolling hills
- **Note**: Not walkable between wineries, need transport

## Seasonal Considerations

### Spring (Mar-May)
- Weather unpredictable, layers essential
- Cherry blossoms late April
- Easter traditions
- Fewer tourists

### Summer (Jun-Aug)
- Hot (30-38°C possible)
- AC not universal — check hotels
- Outdoor pools, rooftop bars
- Sziget Festival August

### Autumn (Sep-Nov)
- Beautiful foliage
- Wine harvest
- Thermal baths + cool air = magical
- Shoulder season deals

### Winter (Dec-Feb)
- Cold (-5 to 5°C, can drop lower)
- Christmas markets magical
- Thermal baths essential
- Ice skating in City Park
- Some outdoor attractions limited

## Useful Phrases

| English | Hungarian | Pronunciation |
|---------|-----------|---------------|
| Hello | Szia | SEE-ya |
| Please | Kérem | KAY-rem |
| Thank you | Köszönöm | KUR-sur-nurm |
| Yes/No | Igen/Nem | EE-gen/NEM |
| Excuse me | Elnézést | EL-nay-zaysht |
| How much? | Mennyibe kerül? | MEN-yee-beh KEH-rool |
| Bill please | Számlát kérek | SAM-lat KAY-rek |
| Cheers | Egészségedre | eg-AY-shay-ged-reh |
| I don't understand | Nem értem | NEM AIR-tem |
| Do you speak English? | Beszél angolul? | BES-ayl ON-go-lool |
