# Budapest Attractions Guide

## Must-See (Don't Miss)

### Buda Castle District (UNESCO)
- **Castle itself**: Royal Palace, now museums (National Gallery, History Museum)
- **Fisherman's Bastion**: Neo-Romanesque terrace, best city views, free outside upper terrace
- **Matthias Church**: Stunning Gothic church, hosts concerts
- **Funicular**: Scenic but often queued; walking up is easy and rewarding
- **Best time**: Sunset for views, early morning to avoid crowds

### Hungarian Parliament
- **Exterior**: Third largest parliament building in the world, neo-Gothic masterpiece
- **Interior**: Guided tours only, book online in advance (sells out)
- **Night view**: Spectacular illumination, best from Buda side
- **Tip**: EU citizens get discounted tickets

### Thermal Baths
- **Széchenyi**: Iconic yellow complex, largest in Europe, year-round outdoor
- **Gellért**: Art Nouveau beauty, elegant atmosphere
- **Rudas**: Ottoman-era authenticity, rooftop pool
- **Budget**: ~4,000-8,000 HUF entry depending on bath and locker type

### St. Stephen's Basilica
- **Interior**: Impressive neoclassical, houses Holy Right Hand relic
- **Tower**: Panoramic views (lift available)
- **Concerts**: Regular classical performances
- **Free entry**: Donations appreciated

### Chain Bridge & Danube Banks
- **Chain Bridge**: Iconic 1849 suspension bridge (renovated 2023)
- **Shoes on the Danube**: Powerful Holocaust memorial
- **Danube promenade**: Both sides beautiful for walking
- **Tram 2**: Scenic route along Pest embankment

### Ruin Bars (District VII)
- **Szimpla Kert**: The original, must-see even if touristy
- **Best time**: Late afternoon for photos, night for atmosphere
- **Sunday market**: Szimpla hosts farmers market Sunday mornings

### Heroes' Square & City Park
- **Heroes' Square**: UNESCO site, monumental statues
- **Vajdahunyad Castle**: Eclectic castle in park, free grounds
- **City Park**: Ice skating (winter), boating lake (summer)
- **Széchenyi Bath**: Located here

## Worth Visiting

### Gellért Hill & Citadella
- **Views**: Arguably best panorama of entire city
- **Citadella**: Habsburg fortress, sunset hotspot
- **Liberty Statue**: Iconic symbol visible citywide
- **Cave Church**: Unique chapel built into hillside

### Margaret Island
- **Car-free oasis**: Parks, running track, gardens
- **Palatinus Beach**: Outdoor thermal complex (summer)
- **Musical fountain**: Light shows summer evenings
- **Rentable**: Bikes, pedal cars, golf carts

### Great Market Hall (Nagyvásárcsarnok)
- **Ground floor**: Fresh produce, meats, pickles
- **Upper floor**: Souvenirs, food stalls (lángos, kolbász)
- **Best time**: Morning for authentic shopping, avoid cruise ship crowds
- **Closed**: Sunday

### House of Terror
- **Location**: Andrássy Avenue (former secret police HQ)
- **Content**: Fascist and Communist terror documentation
- **Heavy**: Allow 2-3 hours, emotionally intense
- **Audio guide**: Essential for context

### Dohány Street Synagogue
- **Largest in Europe**: Stunning Moorish Revival architecture
- **Memorial garden**: Tree of Life Holocaust memorial
- **Tours**: Includes Jewish Quarter walking option
- **Closed**: Saturday (Shabbat)

### Hungarian State Opera House
- **Tours**: Daily, showcasing neo-Renaissance interior
- **Performances**: High quality, surprisingly affordable
- **Andrássy Avenue**: UNESCO World Heritage boulevard

### Hospital in the Rock
- **Underground**: WWII hospital and Cold War bunker
- **Guided tours only**: Fascinating Cold War history
- **Book ahead**: Limited capacity

## Skip or Low Priority

### Madame Tussauds / Wax Museum
Generic, overpriced, nothing unique to Budapest.

### Budapest Eye (Ferris Wheel)
Small, expensive, better views free from Gellért Hill.

### Labyrinth of Buda Castle
Often closed, tourist trap when open.

### Pálinka Museum
Commercial venture disguised as museum. Just visit a good bar.

### Tourist Dinner Cruises
Overpriced food, better to do separate boat trip + restaurant.

### Castle District souvenir shops
Marked up 300%. Buy souvenirs at Central Market or local shops.

## Day Trips

### Szentendre (30 min)
- **What**: Charming artists' village on Danube bend
- **How**: HÉV suburban train from Batthyány tér
- **See**: Cobblestone streets, galleries, Serbian churches
- **Combine**: Can continue to Visegrád by boat

### Visegrád (1.5 hours)
- **What**: Medieval castle ruins, stunning Danube views
- **How**: Bus from Újpest-Városkapu or boat from Vigadó
- **See**: Citadel, Royal Palace ruins, bobsled run
- **Tip**: Best combined with Szentendre or Esztergom

### Esztergom (1.5 hours)
- **What**: Hungary's largest church, border town with Slovakia
- **How**: Direct train from Nyugati station
- **See**: Basilica (views from dome), Castle, walk to Slovakia

### Gödöllő Palace (45 min)
- **What**: Habsburg summer palace, Empress Sisi's favorite
- **How**: HÉV from Örs vezér tere
- **See**: Royal apartments, extensive gardens

### Lake Balaton (1.5-2 hours)
- **What**: Central Europe's largest lake
- **How**: Train from Déli station
- **Summer**: Swimming, sailing, wine region
- **Towns**: Balatonfüred, Tihany, Siófok

### Etyek Wine Region (40 min)
- **What**: Rolling hills, wine cellars, cheese
- **How**: Best by car or organized tour
- **Why**: Closest wine region, easy half-day trip

## Seasonal Events

### Spring (Mar-May)
- **Budapest Spring Festival**: Classical music, arts (late March/April)
- **Easter markets**: Traditional crafts, painted eggs
- **Cherry blossoms**: Beautiful on Gellért Hill

### Summer (Jun-Aug)
- **Sziget Festival**: Massive music festival, Margaret Island (August)
- **Open-air cinemas**: Various locations
- **Rooftop bars**: Peak season
- **Margaret Island**: Outdoor activities, concerts

### Autumn (Sep-Nov)
- **Budapest Wine Festival**: Castle District (September)
- **Contemporary art week**: Gallery openings
- **Shoulder season**: Fewer tourists, good weather

### Winter (Dec-Feb)
- **Christmas markets**: Vörösmarty Square, St. Stephen's (late Nov-Dec)
- **Ice rink**: City Park (Europe's largest outdoor)
- **Thermal baths**: Magical with steam rising in cold air
- **New Year's**: Street parties, fireworks over Danube

## Practical Tips

### Skip the Lines
- Book Parliament tours online 2+ weeks ahead
- Thermal baths: arrive early (opening) or after 4pm
- Ruin bars: go Thursday instead of Saturday
- Bastion upper terrace: arrive before 9am

### Free Things
- Walking the Castle District
- Danube embankment walks
- Margaret Island (except rentals)
- Church interiors (donations appreciated)
- Fisherman's Bastion lower levels
- City Park and all parks
- Many museums free on certain days

### Budapest Card
- Worth it if doing 3+ museums + heavy transit use
- 24/48/72 hour options
- Includes unlimited transit, museum entries, discounts
- Calculate based on your plans
