# Budapest Visas & Immigration

## Overview

Hungary is an EU member state and Schengen Area member. Immigration rules depend on citizenship.

## EU/EEA Citizens

### Rights
- **Free movement**: Live and work without visa
- **No work permit needed**
- **Registration required**: After 90 days
- **Family members**: Derivative rights

### Registration Process

**After 90 days**:
1. Register at Immigration Office (OIF)
2. Provide: Passport, address, employment/study/funds proof
3. Receive registration certificate
4. Valid indefinitely while conditions met

**Documents needed**:
- Valid ID/passport
- Proof of address
- Employment contract OR
- Student enrollment OR
- Proof of sufficient funds + health insurance

### Permanent Residence

**After 5 years** continuous legal residence:
- Apply for permanent residence
- More secure status
- Fewer conditions

## Non-EU Citizens

### Schengen Short Stay

**Without visa** (many countries):
- 90 days in any 180-day period
- Tourism, business visits, family visits
- No work allowed
- Check if your country qualifies

**With visa required**:
- Apply at Hungarian embassy before travel
- Similar 90/180 rule
- Supporting documents required

### Long-Term Stay

For stays over 90 days, need residence permit.

## Residence Permit Types

### Employment Purpose

**Type D visa + Residence Permit**

**Requirements**:
- Job offer from Hungarian employer
- Employer handles much of process
- Work permit (combined with residence)
- Valid passport
- Clean criminal record
- Health insurance

**Process**:
1. Employer applies for work permit
2. You apply for Type D visa at embassy
3. Enter Hungary
4. Apply for residence permit (within 30 days)

**Duration**: 1-3 years, renewable

### EU Blue Card

**For highly qualified workers**

**Requirements**:
- University degree or 5+ years experience
- Job offer with salary above threshold (~€2,000/month)
- Contract for 1+ years

**Benefits**:
- Easier family reunification
- Path to permanent residence
- EU mobility after 18 months

### Digital Nomad Visa (White Card)

**Since 2022** — for remote workers

**Requirements**:
- Work for foreign company or self-employed abroad
- Income >€2,000/month (proven)
- Health insurance
- Clean criminal record
- Not working for Hungarian clients

**Duration**: 1 year, renewable once (2 years max)
**Processing**: ~30 days
**Cost**: ~€100 application fee

**Documents**:
- Passport
- Employment contract or proof of self-employment
- Bank statements (6 months)
- Health insurance
- Accommodation proof
- Criminal record certificate

### Student Residence

**For enrolled students**

**Requirements**:
- Acceptance at Hungarian institution
- Proof of funds
- Health insurance
- Accommodation

**Duration**: Length of study
**Work allowed**: Part-time (20 hrs/week)

### Family Reunification

**For family members of residents**

**Categories**:
- Spouse
- Minor children
- Dependent parents (some cases)

**Process**: Sponsor applies, family member interviews

### Investor/Entrepreneur

**For business owners**

**Options**:
- Company formation + residence permit
- Significant investment routes
- Start-up visa (limited)

**Requirements vary** by business type and investment level.

## The Application Process

### Where to Apply

**From abroad**:
- Hungarian embassy/consulate
- In person interview usually
- Apply before travel

**From within Hungary** (some cases):
- Immigration Office (OIF)
- Must have legal status
- Not all permit types

### Processing Times

| Type | Typical Time |
|------|--------------|
| Short-stay visa | 15 days |
| Long-stay (Type D) | 30-60 days |
| Residence permit | 21-70 days |
| Digital nomad | 30 days |
| EU Blue Card | 30-60 days |

### Required Documents (General)

**Almost always needed**:
- Valid passport (6+ months remaining)
- Passport photos
- Application form
- Proof of accommodation
- Proof of funds
- Health insurance
- Criminal record certificate (apostilled)
- Purpose-specific documents

### Costs

| Item | Cost (approx) |
|------|---------------|
| Short-stay visa | €80 |
| Long-stay visa | €60-100 |
| Residence permit | €60-100 |
| Renewal | €60 |
| Digital nomad | €100 |

## Immigration Office (OIF)

**Main office**: 
- Budafoki út 60, Budapest
- M4 or tram 4 to Móricz Zsigmond körtér

**Tips**:
- Book appointment online
- Arrive early
- Bring ALL documents
- Limited English (bring translator if needed)
- Long waits possible
- Cash for fees

## Permanent Residence

### After 5 Years

**Requirements**:
- 5 years continuous legal residence
- Stable income
- Accommodation
- Health insurance
- Basic Hungarian language (in theory)
- No major crimes

**Benefits**:
- No renewal needed
- Work without permit
- More rights
- Path to citizenship

## Hungarian Citizenship

### By Naturalization

**Requirements**:
- 8 years residence (or 5 if married to Hungarian)
- Pass Hungarian language exam
- Pass Hungarian history/culture exam
- Clean criminal record
- Stable livelihood

**Dual citizenship**: Allowed

### Simplified Naturalization

**For ethnic Hungarians** (ancestors were Hungarian citizens):
- Faster process
- Language requirement still applies
- Many in diaspora eligible

## Common Issues

### Address Registration

- Required for most permits
- Landlord must cooperate
- Can be difficult — discuss before signing lease

### Work Permit Delays

- Employer-dependent process
- Can take months
- Start early

### Renewal Timing

- Apply 30+ days before expiry
- Legal to stay while pending
- Don't let permits lapse

### Traveling While Pending

- Can be problematic
- Consult OIF before travel
- Keep documentation

## Practical Tips

### Documentation

- **Apostille everything** from home country
- **Translate officially** if not in English/Hungarian
- **Multiple copies** of everything
- **Original + copy** always

### Professional Help

**Consider immigration lawyer if**:
- Complex case
- Refusal risk
- Time-sensitive
- Language barrier
- Business immigration

**Costs**: €500-2,000 depending on case

### Timeline Planning

- Start 3-6 months before planned move
- Gather documents early
- Embassy appointments can have long waits
- Build in buffer time

## Resources

### Official

- **OIF**: [oif.gov.hu](http://www.oif.gov.hu)
- **Ministry of Foreign Affairs**: Embassy information
- **Enter Hungary**: Online application system

### Community

- Expat forums (experiences)
- Facebook groups
- Embassy websites
- Immigration lawyers
