# Budapest Transport Guide

## Overview

Budapest has excellent public transport — one of Europe's best for a city its size. Most residents don't need cars.

**BKK** (Budapesti Közlekedési Központ) operates everything.

## The Network

### Metro (4 lines)

**M1 (Yellow)** — Földalatti
- Oldest metro in continental Europe (1896)
- UNESCO World Heritage
- Runs under Andrássy út
- Connects: Vörösmarty tér ↔ Mexikói út
- Useful for: City Park, Opera

**M2 (Red)**
- East-West line
- Connects: Déli pu. (Buda) ↔ Örs vezér tere (Pest)
- Key stops: Batthyány tér, Deák, Blaha, Keleti
- Useful for: Train stations, eastern Pest

**M3 (Blue)**
- North-South through Pest
- Connects: Újpest ↔ Kőbánya-Kispest
- Key stops: Nyugati, Deák, Ferenciek, Kálvin, Corvin
- Useful for: Central Pest, airport connection
- Note: Recently renovated

**M4 (Green)**
- Newest line (2014)
- Connects: Kelenföld ↔ Keleti
- Key stops: Gellért, Rákóczi, Keleti
- Useful for: Gellért area, south Buda

**Interchange**: Deák Ferenc tér (M1, M2, M3)

### Hours
- First train: ~4:30am
- Last train: ~11:30pm
- Frequency: 2-5 min peak, 5-10 min off-peak
- Night service: Night buses replace metro

### Trams

Extensive network, often faster than metro for short trips.

**Key Lines**:
- **Tram 2**: Scenic Danube route (Parliament, Chain Bridge)
- **Tram 4 & 6**: Ring road, 24-hour service, very frequent
- **Tram 19, 41**: Buda embankment
- **Tram 47, 49**: Connect Deák to south Pest

**Frequency**: 3-10 min depending on line

### Buses

Fill gaps where trams/metro don't reach.

**Key Lines**:
- **16**: Castle District (from Deák or Széll Kálmán)
- **105**: Castle District (direct)
- **200E**: Airport to Kőbánya-Kispest metro

**Night Buses**:
- 3-digit numbers (900s)
- Run when metro closed
- Less frequent (15-30 min)

### Trolleybuses

Electric buses on specific routes, mainly northeast Pest.

### HÉV (Suburban Rail)

Connects city to suburbs and nearby towns.

**H5**: Batthyány tér → Szentendre (tourist favorite)
**H6**: Közvágóhíd → Ráckeve
**H7**: Boráros tér → Csepel
**H8/H9**: Örs vezér tere → Gödöllő

**Ticket**: Valid within city zones, extra for suburbs

### Boat (BKK Public)

**D11, D12, D13**: Danube boats, part of transit network
- Use regular ticket/pass
- Scenic but slow
- Connects: Római-part ↔ Haller utca
- Every 30-60 min

### Cogwheel Railway

**Line 60**: Connects Városmajor to Széchenyi-hegy
- Uses regular BKK ticket
- Scenic, leads to hiking trails
- Connects to Children's Railway (tourist)

## Tickets & Passes

### Ticket Types

| Type | Price (HUF) | Notes |
|------|-------------|-------|
| Single | ~450 | One journey, no transfer |
| Transfer ticket | ~530 | One transfer within 100 min |
| 10-ticket block | ~4,000 | Better value |
| 24-hour pass | ~2,500 | Unlimited |
| 72-hour pass | ~5,500 | Unlimited |
| Weekly | ~6,300 | Monday-Sunday |
| Monthly | ~9,500 | Calendar month |

**Budapest Card**: Tourist card, includes transit + museums.

### Where to Buy

- **BKK app**: Best for tourists, mobile tickets
- **Ticket machines**: Metro stations, major stops
- **Newsagents**: Purple BKK sign
- **Customer centers**: Deák, Keleti, Nyugati

### Validation

**Paper tickets**: MUST validate in orange boxes
**Mobile tickets**: Show screen if asked
**Passes**: No validation, just carry

### Inspectors

- Plainclothes, show BKK ID
- Random checks, often at station exits
- No valid ticket = ~16,000 HUF fine
- "I didn't know" doesn't work
- Very active, especially ruin bar areas

## Ride-Hailing & Taxis

### Bolt

- Market leader
- Cheapest option
- App-based, cashless
- Reliable, tracked

### Taxi Companies

**Official only**:
- Főtaxi (yellow cars, reliable)
- City Taxi
- 6x6 Taxi

**Cost**:
- Base: ~1,000 HUF
- Per km: ~400 HUF
- Waiting: ~100 HUF/min

**NEVER**: Hail random taxis, especially near tourist areas
**ALWAYS**: Use Bolt or call official company

## Driving

### Do You Need a Car?

**Usually no** if:
- Living in Districts I-XIV
- Working in center
- Lifestyle centered in city

**Maybe yes** if:
- Living in outer Buda (XII)
- Family with children in suburbs
- Work outside center
- Weekend trips important

### If You Drive

**License**: EU valid, others need International Driving Permit
**Side**: Right
**Seatbelts**: Mandatory
**Alcohol**: Zero tolerance (0.0%)
**Headlights**: 24/7 mandatory outside city
**Parking**: Difficult and expensive in center

### Parking

- **Street parking**: Pay by app (Parkl, EasyPark) or machine
- **Zone pricing**: Center most expensive
- **Residential**: Different rules, permits needed
- **Garages**: €10-30/day center

### Traffic

- Peak hours: 7-9am, 4-7pm
- Very congested
- Many one-way streets
- Aggressive drivers

## Cycling

### Infrastructure

- Improving but mixed
- Good in some areas (Danube path, Margaret Island)
- Dangerous in others
- Drivers not always cycle-aware

### MOL Bubi (Bike Share)

- City-wide bike share
- Stations everywhere
- App-based rental
- €500 HUF/day for short trips
- Good for 30-min hops

### Own Bike

- Theft risk exists (good locks)
- Storage in apartment varies
- Good for Pest flat areas
- Harder in hilly Buda

### Best Routes

- **Danube embankment** (both sides)
- **Margaret Island** (car-free)
- **City Park area**
- **Buda hills** (for mountain biking)

## Airport Connection

**Budapest Airport (BUD)** — 16 km southeast

### Options

| Method | Time | Cost | Notes |
|--------|------|------|-------|
| Bus 200E + M3 | 50-60 min | ~900 HUF | Cheapest |
| 100E (direct bus) | 35 min | ~2,200 HUF | Less frequent |
| miniBUD shuttle | 45-60 min | ~5,000 HUF | Door-to-door |
| Bolt/taxi | 25-40 min | ~8,000-12,000 HUF | Fastest |

### 200E + Metro

1. Exit terminal, find bus stop
2. Bus 200E to Kőbánya-Kispest
3. M3 metro to center
4. Use single ticket + transfer, or day pass

### Tips

- Book Bolt in advance for airport
- Train connection coming (construction)
- Night: Only Bolt/taxi (no metro)

## Intercity Travel

### Trains (MÁV)

**Keleti Station**: International (Vienna, Prague, etc.)
**Nyugati Station**: Some international, domestic
**Déli Station**: Lake Balaton direction

**Book**: mav-start.hu or app
**Tip**: IC trains faster but cost more

### Buses (Volánbusz)

**Népliget Station**: Main bus terminal
**Flixbus**: International connections
**Book**: volanbus.hu or Flixbus app

### Useful Connections

| Destination | From | Time |
|-------------|------|------|
| Vienna | Keleti (train) | 2.5h |
| Bratislava | Keleti (train) | 2.5h |
| Lake Balaton | Déli (train) | 1.5-2h |
| Szentendre | Batthyány (HÉV) | 40 min |
| Esztergom | Nyugati (train) | 1.5h |

## Practical Tips

### Apps to Download
- **BKK Futár**: Official, real-time arrivals
- **Google Maps**: Transit routing works
- **Bolt**: Ride-hailing
- **Parkl/EasyPark**: Parking

### Money-Saving

- Monthly pass if staying 2+ weeks
- 10-ticket packs over singles
- Walk in center (everything close)
- Bolt cheaper than taxi

### Accessibility

- Metro M4 fully accessible
- M3 renovated, accessible
- M1, M2 limited (old)
- Trams: Low-floor increasing
- Buses: Mostly accessible
