# Budapest Startup Scene

## Overview

Budapest's startup ecosystem is:
- **Growing**: Still developing compared to Berlin/London
- **Affordable**: Lower costs = longer runway
- **Talented**: Strong technical education
- **Central**: Good base for CEE expansion
- **Improving**: More funding, more exits, more ambition

## Ecosystem Snapshot

### Success Stories

**Hungarian unicorns/major exits**:
- Prezi (presentation software)
- LogMeIn/GoTo (remote access, sold for $4.3B)
- Ustream (live streaming, sold to IBM)
- Bitrise (mobile DevOps, major VC rounds)
- SEON (fraud prevention)

### Current Strengths

- **B2B SaaS**: Strong track record
- **Developer tools**: Technical talent advantage
- **Gaming**: Long tradition
- **Fintech**: Growing
- **Deeptech**: University spinoffs

### Challenges

- Small local market
- Limited late-stage funding
- Brain drain to Western Europe
- Less risk-taking culture
- Language barrier for some

## Starting Up

### Why Budapest

**Pros**:
- Low costs (office, salaries)
- Strong technical talent
- EU membership (market access)
- Good quality of life
- Growing ecosystem

**Cons**:
- Small domestic market
- Less VC than major hubs
- Need to go international quickly
- Bureaucracy
- Limited exits market

### Legal Setup

**Typical path**: Form Kft (Hungarian LLC)
- See `business.md` for details
- Min capital: ~€7,500
- Timeline: 1-2 weeks

**For investment**:
- Often restructure for foreign holding
- ESOP setup more complex than US
- International VC-compatible structures exist

### Costs

**Monthly burn (early stage)**:
- Office/coworking: €200-500/person
- Developer salary: €2,500-4,000
- Marketing: Variable
- Tools/services: €500-1,000

**Total small team (5 people)**: €20,000-30,000/month

Compare to Berlin (~€40,000-60,000) or London (~€60,000-100,000)

## Funding Landscape

### Stages

**Pre-seed/Seed** (€50K-500K):
- Angel investors
- Local VCs
- Accelerator funding
- Growing options

**Series A** (€1-5M):
- Regional VCs
- International VCs entering
- Government co-investment

**Later stages**:
- Limited local options
- Need international VCs
- Common to relocate/have foreign entity

### Investors

**Local VCs**:
- Hiventures (government-backed, active)
- PortfoLion
- Széchenyi Capital
- Primus Capital
- Day One Capital

**Regional VCs** (active in Budapest):
- Credo Ventures
- Kaya VC
- Various Polish/Czech funds

**International interest**:
- Growing attention to CEE
- Tier 1 VCs now look at region
- Typically Series A onwards

### Angels

- Growing angel community
- Tech founders reinvesting
- Networks forming
- Still less structured than US/UK

### Government Support

**Hiventures**:
- Largest local player
- Various programs
- Can be slower
- Good for matching/co-investment

**EU Funding**:
- Various programs
- Horizon Europe
- Often complex applications

## Support Infrastructure

### Accelerators

**Design Terminal**:
- Government-affiliated
- Free office space
- Mentorship
- Demo days

**MKB Fintechlab**:
- Fintech focused
- Bank partnership
- Good network

**Others**:
- Google for Startups (regional)
- Climate-KIC (climate tech)
- EIT programs

### Coworking

**Kaptar**: Multiple locations, startup-friendly
**Impact Hub**: Social enterprise focus
**Mosaik**: Design-oriented
**Loffice**: Various spaces

Costs: €150-300/month per desk

### Legal/Accounting

**Startup-friendly firms**:
- DLA Piper (international)
- CMS (international)
- Local boutiques
- Important: Find VC-experienced lawyers

### Events

**Regular**:
- Startup Safary (largest)
- Brain Bar (festival)
- Various meetups
- Demo days

**Community**:
- Active Slack/Discord groups
- Meetup groups
- Informal networks

## Talent

### Finding People

**Sources**:
- University partnerships (BME, ELTE)
- LinkedIn
- Tech meetups
- Referrals (small community)
- Recruiters (expensive but effective)

### Competing for Talent

- Equity matters (educate candidates)
- Mission/vision important
- Flexibility valued
- Growth opportunities
- Compete on culture, not just salary

### Remote/Distributed

- Budapest as base + remote team common
- Access to broader talent
- Tools/culture matter

## Going International

### When to Expand

Budapest market small (~10M people):
- Most startups need international quickly
- Often target UK/Germany/US
- Regional (CEE) expansion easier

### Common Patterns

**Option 1**: Hungarian entity, sell internationally
- Simple to start
- May need foreign entity later

**Option 2**: Foreign holding (Delaware, UK, etc.) from start
- VC-preferred
- More complex setup
- Better for big fundraising

**Option 3**: Move HQ, keep Hungarian operations
- Common pattern
- Talent stays cheaper in Budapest
- HQ where investors/customers are

## Best Practices

### For Foreign Founders

**Advantages**:
- International perspective
- Network abroad
- English native

**Considerations**:
- Learn ecosystem
- Build local relationships
- Understand culture
- Legal/tax advice crucial

### General Advice

1. **Think international from day 1** — local market small
2. **Use cost advantage** — longer runway, more experiments
3. **Build relationships** — small community, reputation matters
4. **Get good advisors** — legal, accounting, mentors
5. **Join community** — events, coworking, networks
6. **Consider relocation timing** — if/when to move HQ

## Resources

### Online

- Startup Hungary (news)
- CEE startup newsletters
- LinkedIn groups
- Local tech media

### Organizations

- Hungarian Startup Association
- Bridge Budapest
- AmCham tech committee
- Various bilateral chambers

### People to Know

- Attend events
- Ask for introductions
- Active founders help each other
- Mentors available

## Comparison

| Factor | Budapest | Berlin | London |
|--------|----------|--------|--------|
| Costs | Low | Medium | High |
| Funding | Growing | Strong | Very strong |
| Talent | Good | Competitive | Abundant |
| Ecosystem | Developing | Mature | Mature |
| Market access | CEE, EU | EU, Global | Global |
| Quality of life | High | High | High |

**Budapest sweet spot**: Early-stage, cost-efficient development with plan to internationalize.
