# Budapest Safety Guide

## Overall Safety

Budapest is one of Europe's safest capitals. Violent crime against tourists is rare. Common sense applies.

**Global Peace Index**: Hungary ranks well
**Tourist safety**: Very high
**Main concerns**: Petty theft, scams (both avoidable)

## Crime Reality

### What to Actually Worry About

**Pickpockets** (Low-Medium Risk)
- Crowded public transit
- Ruin bars at night
- Tourist attractions (Castle, Market Hall)
- Solution: Normal awareness, secure valuables

**Scams** (Medium Risk)
- Taxi overcharging
- Restaurant bill padding
- "Pretty women" bar scam
- Exchange office poor rates
- Solution: Knowledge (see below)

**Bike theft** (Medium Risk)
- Use good locks
- Don't leave overnight outside
- Register with police if valuable

### What NOT to Worry About

- Violent crime (rare)
- Mugging (very rare)
- Home invasion (very rare)
- Terrorism (no significant threat)
- Kidnapping (not a concern)

## Scams to Know

### Taxi Scams

**The scam**: Unmetered fare, inflated prices, "broken meter"

**Avoid by**:
- Using Bolt app (tracked, fixed price)
- Only official taxis (Főtaxi yellow cars)
- Never hailing unmarked cars
- Agreeing price before if not metered

**Hotspots**: Airport, Keleti station, ruin bar area

### Restaurant Bill Padding

**The scam**: Extra items added, wrong prices, "cover charge"

**Avoid by**:
- Checking menu prices
- Asking about cover/service charges upfront
- Reviewing itemized bill
- Avoiding restaurants with aggressive outside pitches

**Hotspots**: Váci utca, tourist areas

### The "Pretty Women" Scam

**The scam**: Attractive women invite you for drinks → enormous bill → threats

**How it works**:
1. Friendly women approach solo male tourists
2. Invite to "quiet bar" they know
3. Order expensive drinks
4. Bill arrives: €500+
5. Bouncers appear if you resist

**Avoid by**:
- Never following strangers to bars
- Checking prices before ordering
- Declining too-friendly approaches
- Sticking to established venues

**Note**: This is a real, organized scam. Don't be embarrassed — it's designed to work.

### Exchange Office Scams

**The scam**: Poor exchange rates, hidden fees, math "errors"

**Avoid by**:
- Using Wise/Revolut cards (best rates)
- ATMs at real banks
- Never exchanging at airport
- Never exchanging on street (illegal)

### Thermal Bath Theft

**The scam**: Items stolen from lockers/changing areas

**Avoid by**:
- Using secure lockers (wristband key)
- Not bringing valuables
- Using waterproof pouch for essentials
- Being aware in crowded changing rooms

## Safe Practices

### On the Street

- **Day**: No concerns anywhere central
- **Night**: Normal city awareness
- **ATMs**: Use bank ATMs, be aware of surroundings
- **Phones**: Don't flash expensive phones in crowds
- **Bags**: Crossbody or front-worn in crowded areas

### Public Transit

- Keep valuables in front pockets
- Backpacks to front in crowds
- Be alert at busy interchanges
- Night buses: Normal awareness

### Nightlife

- Watch drinks (universal advice)
- Stick with friends
- Use Bolt for transport home
- Know your limits with pálinka
- Ruin bars: Secure valuables in crowds

### Accommodation

- Use safe/locker for valuables
- Lock doors (standard)
- Verify Airbnb hosts (reviews, verification)
- Note emergency exits

## Areas by Safety

### Very Safe (Day & Night)

- District I (Castle District)
- District V (Center)
- District VI (most)
- District XII (Buda hills)
- District II (Buda residential)
- District XIII (modern)

### Safe with Normal Awareness

- District VII (busy nightlife = some issues)
- District IX (improving)
- District XIV (residential)
- District XI (residential)

### Caution Advised (especially at night)

- District VIII (parts)
  - Rapidly improving but some rough blocks
  - Stick to main streets at night
  - Józsefváros proper more concerning than Palace Quarter

### Not Tourist Relevant

- Most outer districts: Safe but nothing there
- Industrial areas: No reason to visit

## Emergency Information

### Emergency Numbers

| Service | Number |
|---------|--------|
| General Emergency | 112 |
| Ambulance | 104 |
| Fire | 105 |
| Police | 107 |

### What to Know

- **112**: Works for all emergencies, English available
- **Police**: Professional but limited English outside center
- **Hospitals**: Good care, some English
- **Embassy**: Contact in serious situations

### Police Interaction

- Generally professional
- Tourist Police unit exists (some English)
- Report crimes at nearest station
- For minor theft: May not recover items but report for insurance
- Keep copy of passport separately

### Lost/Stolen Documents

**Passport**:
1. Report to police (get report)
2. Contact embassy
3. Get emergency travel document

**Cards**:
1. Block immediately (bank app/phone)
2. Report to police if needed
3. Get replacement sent or use backup

**Phone**:
1. Report to police (for insurance)
2. Block SIM with provider
3. Use Find My / Google to lock/locate

## Health & Medical Safety

### Emergencies

- **112**: Ambulance dispatch
- **Hospitals**: SOS International, FirstMed (private, English)
- **Public hospitals**: Good care, limited English

### Pharmacies

- **Gyógyszertár**: Pharmacy
- **24-hour**: Several in center
- **Common meds**: May need prescription
- **Pharmacists**: Often speak some English

### Food/Water Safety

- **Tap water**: Safe to drink
- **Restaurant hygiene**: Good standards
- **Street food**: Generally safe
- **Ice**: Safe

### Allergies/Medical Conditions

- Carry medication with prescription documentation
- Know Hungarian for your condition
- MedicAlert bracelet useful
- Download translation app

## Natural Hazards

### Weather

- **Summer heat**: 35°C+ possible, stay hydrated
- **Winter cold**: -10°C possible, dress warmly
- **Ice**: Sidewalks can be slippery (December-February)

### Other

- **Flooding**: Rare, Danube flooding happens but controlled
- **Earthquakes**: Very rare, negligible
- **Wildlife**: None in city

## LGBTQ+ Safety

### Reality

- **Legal status**: Same-sex relationships legal
- **Public attitude**: Younger/central more accepting
- **Government**: Current policies less supportive
- **Violence**: Rare but incidents occur

### Advice

- **Central Budapest**: Generally safe, tolerant
- **Public affection**: Keep discrete outside gay venues
- **Pride**: Annual, but controversial
- **Venues**: Concentrated in District VII

### Resources

- Budapest Pride
- Háttér Society (LGBTQ+ organization)
- Gay-friendly hotels/venues list available

## Women's Safety

### Reality

- Very safe by European standards
- Solo female travel common
- Nightlife generally respectful

### Tips

- Normal awareness at night
- Drink watching standard
- Bolt home from nights out
- Trust instincts if uncomfortable
- Ruin bars: Big but manageable

### Resources

- Women-only thermal bath times (some locations)
- Women-only accommodation options exist

## Solo Traveler Safety

- Very safe for solo travelers
- Hostels social and safe
- Easy to meet people
- Good tourist infrastructure
- English widely spoken in center

## Travel Insurance

**Recommended**: Always for medical emergencies

**Should cover**:
- Medical evacuation
- Hospital costs
- Trip cancellation
- Theft/loss
- 24-hour assistance line

**EU citizens**: EHIC/GHIC card for public healthcare
**Non-EU**: Private insurance essential
