# Moving to Budapest Guide

## Before You Arrive

### Legal Status

**EU/EEA Citizens**:
- Free to live and work
- Register after 90 days
- No visa needed

**Non-EU Citizens**:
- Need visa/residence permit for stays >90 days
- Work permit required for employment
- See `visas.md` for details

### Documents to Prepare

- Passport (valid 6+ months)
- Birth certificate (apostilled)
- Marriage certificate if applicable
- Educational documents (apostilled for work)
- Employment contract if applicable
- Proof of funds
- Health insurance documentation
- Passport photos (lots)

### Research

- [ ] Neighborhoods (see district guides)
- [ ] Cost of living estimation
- [ ] Job market if relevant
- [ ] Schools if family
- [ ] Healthcare options
- [ ] Bank account options

## First Steps on Arrival

### Week 1 Priorities

1. **Accommodation** (temporary if needed)
   - Airbnb for first 1-2 weeks
   - Use time to view permanent options
   - Don't sign long-term without viewing

2. **SIM Card**
   - Buy prepaid immediately
   - Airport or city shop
   - Needed for everything

3. **Transport**
   - Get monthly BKK pass
   - Download BKK Futár app
   - Download Bolt

4. **Banking**
   - Set up Wise/Revolut immediately
   - Use for payments until bank account

### Week 2-4 Priorities

1. **Permanent Accommodation**
   - View apartments
   - Understand contracts
   - Budget for deposits

2. **Registration**
   - Address registration (lakcímkártya)
   - Requires landlord cooperation
   - Needed for many other steps

3. **Bank Account**
   - Hungarian bank if staying long-term
   - Requires address, tax ID

4. **Tax Number**
   - Adószám (tax ID)
   - Apply at NAV office
   - Needed for work, sometimes banking

5. **Healthcare**
   - Arrange insurance
   - Register with GP
   - TAJ number if employed

## Finding Accommodation

### Where to Search

**Websites**:
- Ingatlan.com (largest, Hungarian)
- Alberlet.hu (rentals)
- Facebook groups (Expats, Flats)
- Booking.com (short-term)
- Flatio (furnished, medium-term)

**Agencies**:
- DunaHouse
- RE/MAX
- Independent agents
- 1 month fee typical

### What to Know

**Typical terms**:
- 1-year lease (shorter possible)
- 2 months deposit
- 1 month agency fee (if used)
- Furnished or unfurnished
- Közös költség (common costs) extra

**Red flags**:
- No contract
- Cash only requests
- Price too good
- Can't visit
- Rushed signing

**Viewing checklist**:
- [ ] Heating type and cost
- [ ] Utility costs (ask for bills)
- [ ] Internet availability
- [ ] Noise level
- [ ] Storage space
- [ ] Neighbors
- [ ] Building condition
- [ ] Natural light
- [ ] AC (crucial for summer)

### Contract Points

**Should include**:
- Rental amount and payment schedule
- Deposit amount and return conditions
- Notice period (typically 30-60 days)
- Utility responsibility
- Landlord contact info
- Inventory list (for furnished)
- Property condition documentation

**Have reviewed** by Hungarian speaker or lawyer if large commitment.

## Registration Process

### Address Registration (Lakcím)

**What**: Official address registration card
**Why**: Required for many services

**Process**:
1. Landlord provides consent
2. Go to Okmányiroda (Document Office)
3. Submit application
4. Receive lakcímkártya

**Documents needed**:
- Passport
- Lease agreement
- Landlord consent form
- Application form

**Note**: Some landlords reluctant — discuss before signing lease.

### Tax Number (Adószám)

**What**: Hungarian tax ID
**Why**: Employment, banking, official matters

**Process**:
1. Go to NAV office
2. Submit application
3. Receive number (same day or posted)

**Documents needed**:
- Passport
- Address registration
- Application form

### Social Security (TAJ)

**What**: Healthcare and pension number
**Why**: Required for employment, healthcare access

**Process**:
1. Employer usually handles
2. Or apply at OEP office
3. Receive TAJ card

**Access through**:
- Employment (mandatory contributions)
- Voluntary contribution
- EU EHIC card (temporary coverage)

## Employment

### Finding Work

**Job sites**:
- LinkedIn (strongest for professional)
- Profession.hu (local)
- Indeed Hungary
- Monster.hu
- Company websites directly

**Sectors hiring expats**:
- Shared services centers
- Tech companies
- Teaching/education
- Tourism/hospitality

### Work Culture

**Hours**: 8am-5pm typical, some flexibility
**Vacation**: 20+ days standard
**Language**: Many international companies use English
**Dress**: Business casual typical

### Employment Rights

**Standard benefits**:
- Health insurance (mandatory)
- Pension contributions
- Paid holidays (20+)
- Sick leave
- Maternity/paternity

**Probation**: Up to 3 months
**Notice period**: 30 days minimum

## Building Your Life

### Social Connections

**Expat groups**:
- Internations events
- Facebook groups
- Meetup.com groups
- Embassy events
- Language exchange

**Local connections**:
- Work colleagues
- Neighbors
- Sports/hobby clubs
- Volunteering

### Learning Hungarian

**Worth it?**: For long-term stay, yes
**Difficulty**: Very hard (non-Indo-European)
**Strategy**: 
- Basic phrases help daily life
- Full fluency takes years
- English sufficient in center/professional

**Resources**:
- Language schools (Katedra, etc.)
- Private tutors
- Apps (Duolingo intro only)
- Tandem partners

### Establishing Routines

**First 3 months**:
- Explore neighborhoods
- Find your supermarket
- Identify good restaurants
- Establish commute
- Join 1-2 activities

**6 months**:
- Should feel oriented
- Friend group forming
- Routines established
- Consider longer-term stay

## Practical Setup

### Utilities

Usually landlord's name, you pay:
- Electricity (~€40-80/month)
- Gas (~€50-150/month, seasonal)
- Water (often in közös költség)
- Internet (~€20-30/month)

### Internet

**Setup**:
1. Choose provider (Telekom, Digi, Vodafone)
2. Order online or in shop
3. Installation appointment
4. ~1-2 weeks

### Mail

- Arrange mailbox access
- Set up mail forwarding from old address
- Register for FoxPost/Packeta for packages

### Driving

**EU License**: Valid directly
**Non-EU License**: Exchange or get Hungarian (rules vary)
**Parking**: Expensive in center
**Car needed?**: Usually no in central Budapest

## Common Challenges

### Language Barrier

- Official documents in Hungarian
- Some services limited English
- Solution: Translation apps, expat services, learning basics

### Bureaucracy

- Multiple offices for different things
- Opening hours limited
- Appointments often needed
- Solution: Patience, preparation, help from locals

### Winter Blues

- Short, gray days November-February
- Can be depressing
- Solution: Light therapy, social activities, thermal baths

### Loneliness

- Common expat experience
- Takes time to build connections
- Solution: Active social effort, joining groups, patience

## Month-by-Month Timeline

### Month 1
- [ ] Arrive, temporary accommodation
- [ ] SIM card, transport pass
- [ ] Find permanent apartment
- [ ] Sign lease, move in

### Month 2
- [ ] Address registration
- [ ] Tax number
- [ ] Bank account
- [ ] Start work or continue job search
- [ ] Basic exploration

### Month 3
- [ ] Routines established
- [ ] Healthcare sorted
- [ ] Social connections starting
- [ ] Feeling oriented

### Month 6
- [ ] Well established
- [ ] Friend group forming
- [ ] Considering longer stay?
- [ ] Hungarian lessons?

### Year 1
- [ ] Lease renewal decision
- [ ] Long-term plans
- [ ] Fully integrated
- [ ] Know the city well
