# Buda Neighborhoods

## Why Buda?

Pest gets the attention, but Buda offers:
- **Space**: Bigger apartments, gardens possible
- **Nature**: Hills, forests, trails from doorstep
- **Quiet**: Residential without party noise
- **Quality**: Generally better-maintained buildings
- **Air**: Noticeably cleaner than central Pest

Trade-offs:
- Fewer restaurants/bars/cultural venues
- Commute to Pest for nightlife/events
- More car-oriented (though transit exists)

---

## District I (Vár/Castle District)

### Overview
The UNESCO Castle District. Historic, prestigious, tourist-heavy during day.

**Size**: Small
**Population**: ~25,000
**Vibe**: Historic luxury, quiet nights

### Areas

**Castle Hill**
- Inside the walls
- Fisherman's Bastion, Matthias Church
- Very few apartments (mostly museums, government)
- Extremely exclusive if available

**Víziváros (Watertown)**
- Between Castle and river
- More residential
- Batthyány tér transit hub
- Historic buildings, good restaurants

**Tabán**
- Southern slopes
- Parks and thermal baths
- Quiet residential

### Living Here

**Pros**
- Stunning historic setting
- Very safe
- Tourist-free at night
- Walking distance to Pest (over bridges)
- Prestige address

**Cons**
- Expensive
- Limited dining/grocery
- Uphill everything
- Tourists during day
- Far from nightlife

### Practical Info

| Metric | Details |
|--------|---------|
| 1BR Rent | €700-1,200/month |
| Grocery | Very limited, Víziváros better |
| Dining | Few options, mostly tourist-priced |
| Nightlife | Non-existent |
| Metro | M2 at Batthyány tér |
| Green space | Castle gardens, Tabán park |

### Best For
- History lovers
- Wealthy retirees
- Diplomats/government
- Those wanting prestige address

---

## District II (Rózsadomb & surrounds)

### Overview
The classic "expat district." Hills with views, international schools, embassies, money.

**Size**: Large
**Population**: ~90,000
**Vibe**: Wealthy residential, family-oriented, green

### Areas

**Rózsadomb (Rose Hill)**
- Premier residential area
- Villas with Danube views
- Ambassadors, executives
- Top-end prices

**Pasarét**
- Family neighborhood
- Near Millenáris Park
- Good schools
- Upper-middle class

**Hűvösvölgy**
- At edge of Buda Hills
- Nature lovers
- Can feel isolated
- Mix of old villas and communist blocks

**Margit körút area**
- Most urban part of II
- Near Margit Bridge
- Better transit
- More affordable

### Living Here

**Pros**
- Safe, clean, green
- International schools
- Nature access (trails in hills)
- Views possible
- Quiet family life

**Cons**
- Expensive
- Need car for full benefit
- Limited nightlife
- Far from "action"
- Can feel boring

### Practical Info

| Metric | Details |
|--------|---------|
| 1BR Rent | €600-1,000/month |
| Family 3BR | €1,200-2,500/month |
| Grocery | Good supermarkets |
| Dining | Good but not abundant |
| Nightlife | Sparse |
| Transit | Trams + buses, no metro |
| Green space | Excellent (hills, parks) |

### Best For
- Families with children
- People with cars
- Those wanting space and quiet
- International school seekers

---

## District XI (Újbuda)

### Overview
Large district, very varied. Student areas, family zones, communist-era blocks, modern developments.

**Size**: Huge
**Population**: ~140,000
**Vibe**: Mixed, from student to residential

### Areas

**Gellért area**
- Near Gellért Bath and bridge
- Urban, some tourism
- Good restaurants
- Transit excellent

**Móricz Zsigmond körtér**
- Hub area, lively
- Student population (near university)
- Shops, restaurants, cinemas

**Bartók Béla út**
- Main commercial street
- Good amenities
- Affordable for quality
- Tram connections

**Kelenföld**
- Outer, mixed blocks and new builds
- M4 metro terminus
- More affordable
- Less character

**Sasad, Sashegy**
- Hills approaching XII
- Villas, quieter
- More upscale

### Living Here

**Pros**
- Very varied options
- Generally affordable
- Good transit (trams, M4)
- Student energy in parts
- Near universities (ELTE, BME)

**Cons**
- Large district = varies hugely
- Some areas tired/ugly
- Communist blocks common
- Not central

### Practical Info

| Metric | Details |
|--------|---------|
| 1BR Rent | €500-800/month |
| Grocery | Excellent (big stores) |
| Dining | Good variety |
| Nightlife | Some, more local |
| Transit | M4, trams excellent |
| Green space | Good in hills |

### Best For
- Students
- Young families
- Budget-conscious wanting quality
- Those who don't need central Pest

---

## District XII (Hegyvidék)

### Overview
The "Beverly Hills" of Budapest. Exclusive hills, villas, forest access.

**Size**: Medium
**Population**: ~55,000
**Vibe**: Wealthy, quiet, green, slightly suburban

### Areas

**Városmajor**
- Near Széll Kálmán tér
- Most connected part
- Parks, good schools

**Normafa**
- Popular hiking destination
- Mix of villas and nature
- Higher up, more isolated
- Weekend destination for whole city

**Istenhegy, Mártonhegy**
- Residential hills
- Large properties
- Very quiet
- Need car

### Living Here

**Pros**
- Beautiful natural setting
- Safe, clean, quiet
- Good schools
- Fresh air, trails
- Prestigious address

**Cons**
- Need car (mostly)
- Far from nightlife
- Limited dining
- Can feel isolated
- Winter driving tricky (hills)

### Practical Info

| Metric | Details |
|--------|---------|
| 1BR Rent | €700-1,200/month |
| Family house | €2,000-5,000+/month |
| Grocery | Less convenient |
| Dining | Few but good |
| Nightlife | None |
| Transit | Cogwheel railway, buses |
| Green space | Forest all around |

### Best For
- Wealthy families
- Nature lovers with cars
- Those seeking escape from urban
- Hikers/outdoor people

---

## Buda Comparison

| Factor | I | II | XI | XII |
|--------|---|----|----|-----|
| Price | $$$ | $$$ | $$ | $$$ |
| Transit | OK | Weak | Good | Weak |
| Nature | Gardens | Good | Some | Excellent |
| Families | No | Yes | Yes | Yes |
| Young people | No | No | Yes | No |
| Character | Historic | Expat | Varied | Exclusive |

### Decision Framework

**Choose I if**: Historic setting, money no object, near bridges to Pest
**Choose II if**: Family with kids, want expat community, international schools
**Choose XI if**: Balance of affordability and quality, good transit needed
**Choose XII if**: Money for quiet villa life, car owner, nature essential
