# Local Services in Budapest

## Banking & Money

### Opening a Bank Account

**Major Banks**:
- OTP Bank (largest Hungarian)
- Erste Bank
- K&H Bank
- Raiffeisen
- CIB Bank

**Requirements (typical)**:
- Passport
- Residence permit (for non-EU)
- Hungarian address proof
- Tax ID (adószám)
- Initial deposit (varies)

**Timeline**: Same day to 1 week
**Language**: Some English, varies by branch

### Digital Banking Alternatives

**Wise** (Recommended for expats)
- No Hungarian address needed
- Multi-currency
- Best exchange rates
- Instant setup

**Revolut**
- Similar to Wise
- Good for daily spending
- EU IBAN available

**N26**
- German digital bank
- Works in Hungary
- EU IBAN

### ATMs

- **Use bank ATMs** (OTP, Erste, K&H)
- **Avoid standalone machines** (high fees)
- **Decline conversion** (always choose HUF)
- **Daily limits**: Typically 150,000-300,000 HUF
- **Cards**: Visa/Mastercard universal

### Currency Exchange

**Best options** (in order):
1. Wise/Revolut card (best rates)
2. Bank ATM withdrawal
3. Correct Exchange (fair rates)
4. Bank exchange (okay rates)

**Avoid**:
- Airport exchanges (terrible rates)
- Tourist area exchanges
- Street exchangers (illegal)

## Mobile & Internet

### Mobile Operators

| Provider | Network | Notes |
|----------|---------|-------|
| Telekom | Best coverage | Most expensive |
| Vodafone | Good coverage | Mid-price |
| Yettel | Good coverage | Budget options |

### Prepaid SIM

**Where to buy**:
- Airport arrivals
- Provider shops (mall, city)
- Some electronics stores

**What you need**:
- Passport
- ~3,000-10,000 HUF for starter pack

**Typical packages**:
- ~5,000 HUF: 10GB data + calls for month
- Top-up at newsagents, online

### Contract (Postpaid)

**Requirements**:
- Hungarian address
- ID/passport
- Sometimes bank account
- 1-2 year commitment typical

**Better rates** but harder to exit

### Home Internet

**Providers**:
- Telekom
- Digi (cheapest, decent)
- Vodafone
- UPC/Vodafone

**Speeds**: 100Mbps-1Gbps available
**Cost**: €15-40/month
**Installation**: 1-2 weeks

**Note**: Fiber widespread in Budapest, good connectivity.

## Mail & Shipping

### Magyar Posta (Hungarian Post)

- Yellow branding
- Post offices in every district
- Opening hours: Usually 8am-6pm (varies)
- Saturdays: Limited
- Tracking: Available for packages

### Package Delivery

**Local delivery**:
- GLS (common for e-commerce)
- DPD
- FoxPost (locker pickup)
- Packeta (locker pickup)

**International**:
- DHL
- FedEx
- UPS
- PostNL

**Tip**: Locker pickup (FoxPost, Packeta) avoids delivery wait

### Receiving Mail

- No mailbox? Use neighbor or office
- Large packages: Often delivered to post office
- Some buildings have package lockers

## Utilities Setup

### Moving into Apartment

Check with landlord who handles:
- Electricity (usually in landlord's name)
- Gas (usually in landlord's name)
- Water (building common cost)
- Internet (you can set up own)

### Utility Providers

**Electricity**:
- MVM (state)
- E.ON
- Various suppliers

**Gas**:
- MVM
- E.ON
- Various suppliers

**Water**:
- Fővárosi Vízművek (Budapest Water)
- Usually included in közös költség (common cost)

### Bills

- Monthly or bi-monthly
- Pay online, at post office, or bank
- **Csekk**: Yellow payment slip, can pay at Posta

## Government Services

### Residence & Immigration

**Immigration Office (OIF)**:
- Budafoki út 60 (main office)
- Book appointments online
- English limited, bring translator
- Long waits possible

### Tax (NAV)

**Tax Authority**:
- Online system available
- English info limited
- Tax advisors common for expats

### Address Registration

**Okmányiroda** (Document Office):
- For official address registration
- Required for many services
- Appointment system

## Healthcare Access

### Public Healthcare

**Access requires**:
- TAJ number (social security)
- Paying into Hungarian system
- Employment or voluntary contribution

### Private Healthcare

**Major providers**:
- FirstMed (English-speaking)
- Medicover
- Dr. Rose Private Hospital
- SOS International

**Without insurance**:
- GP visit: €30-60
- Specialist: €50-100
- Blood tests: €30-100

### Pharmacies (Gyógyszertár)

- **Opening hours**: 8am-6pm typical
- **24-hour pharmacies**: Several in center
- **Prescription**: Many meds require it
- **OTC**: Painkillers, cold meds available

### Dentists

- Quality care, affordable
- Many speak English
- Tourism for dental work common
- Prices 50-70% of Western Europe

## Shopping

### Supermarkets

**Budget**:
- Lidl (German chain, good quality)
- Aldi (German chain)
- Penny

**Mid-range**:
- Spar
- CBA
- Coop

**Premium**:
- Interspar (larger Spar)
- Tesco (diminishing presence)
- Bio/organic shops

### Shopping Hours

**Typical**:
- Monday-Saturday: 6am-10pm
- Sunday: CLOSED (law)

**Exceptions**:
- Small shops (<200m²)
- Malls some areas
- Gas stations

**Sunday closures**: Major adjustment for expats

### Markets

**Traditional markets**:
- Great Market Hall (Nagycsarnok) — tourist but real
- Lehel tér — local, good
- Hold Street Market — trendy
- Rákóczi tér — authentic

### Malls

- Westend (largest, by Nyugati)
- Arena Mall (by Keleti)
- Allee (south Buda)
- Mammut (Buda)

## Household Services

### Finding Services

**Online platforms**:
- Jófogás (Hungarian Craigslist)
- Facebook groups
- Budapest Expat Community groups
- Word of mouth

### Common Needs

**Cleaning**:
- €10-15/hour typical
- Regular cleaners findable
- Agency vs. individual

**Repairs/Handyman**:
- Landlord often handles
- Independent: €20-40/hour
- Quality varies, get recommendations

**Movers**:
- Budget: €100-200 (small move)
- Full service: €300-500+
- Tips expected

## Emergency Services

### Key Contacts

| Service | Number |
|---------|--------|
| Emergency | 112 |
| Ambulance | 104 |
| Police | 107 |
| Fire | 105 |

### 24-Hour Services

- **Pharmacies**: Several in center
- **Hospitals**: Emergency rooms open
- **Locksmith**: Various, search online
- **Plumber/Electrical**: Emergency services exist

## Expat Resources

### Community Groups

- **Facebook**: "Expats in Budapest" (largest)
- **InterNations**: Events, networking
- **Meetup**: Various interest groups
- **Embassy events**: Cultural programming

### Language Learning

- **Hungarian courses**: Budapest languages, Katedra
- **Tandem apps**: HelloTalk, Tandem
- **Private tutors**: €15-30/hour

### Coworking

- **Kaptar**: Popular, multiple locations
- **Impact Hub**: Social enterprise focus
- **Mosaik**: Design-focused
- **Loffice**: Various spaces

### Kids/Families

- **International schools**: Listed in education guide
- **Playgroups**: English-speaking exist
- **Parks**: Many, well-maintained
- **Family activities**: Plentiful
