# Budapest Education Guide

## Education System Overview

### Hungarian System Structure

| Level | Ages | Hungarian Name |
|-------|------|----------------|
| Kindergarten | 3-6 | Óvoda |
| Primary | 6-14 | Általános iskola |
| Secondary | 14-18 | Középiskola (Gimnázium) |
| University | 18+ | Egyetem/Főiskola |

**Compulsory education**: 6-16 years

### Language of Instruction

- **Hungarian system**: Hungarian language
- **International schools**: English, German, French, etc.
- **Bilingual programs**: Various combinations

## For Expat Families

### Options

1. **International schools** — English/other language curriculum
2. **Hungarian public schools** — Free, Hungarian language
3. **Hungarian private schools** — Hungarian with language support
4. **Home schooling** — Legal with registration

### International Schools

**Main options**:

**British System**
- Britannica International School
- Budapest British International School
- Fees: €12,000-20,000/year

**American System**
- American International School of Budapest (AISB)
- Greater Grace International School
- Fees: €15,000-25,000/year

**IB Programs**
- SEK Budapest (Spanish-international)
- AISB (IB offered)
- Various others

**German**
- Deutsche Schule Budapest
- Thomas Mann Gymnasium (bilingual)

**French**
- Lycée Français Gustave Eiffel

**Other**
- Austrian, Japanese, various options

### School Selection Criteria

**Consider**:
- Language of instruction
- Curriculum (IB, British, American, etc.)
- Location (District II popular for international)
- Fees and total costs
- Class sizes
- Extracurriculars
- Community/culture
- University preparation

### Admissions

**Typical process**:
1. Visit/tour schools (start 1 year ahead)
2. Submit application
3. Assessment/interview
4. Placement
5. Enroll

**Documents needed**:
- Previous school records
- Recommendation letters
- Birth certificate
- Passport copies
- Medical records
- Application forms

**Timeline**: Start process 6-12 months before needed

### Costs

**International schools** (annual):
- Basic: €8,000-12,000
- Mid-range: €12,000-18,000
- Premium: €18,000-25,000

**Additional costs**:
- Registration fees (one-time)
- Books and materials
- Uniforms (some schools)
- Extracurriculars
- School trips
- Lunch

**Total budget**: Add 20-30% to tuition

## Hungarian Public Schools

### Overview

- Free for residents
- High standards academically
- Hungarian language
- Well-regarded globally

### Considerations for Expats

**Challenges**:
- Hungarian language essential
- Integration can be difficult initially
- Different teaching styles
- Limited English support

**Benefits**:
- Free
- Cultural integration
- Strong academics
- Language immersion

### If Choosing Public

- Consider bilingual programs (less common)
- Ensure language support available
- Be prepared for adjustment period
- Supplement with language tutoring

## Kindergarten (Óvoda)

### Hungarian Public Kindergarten

- **Ages**: 3-6
- **Free** for residents
- **Compulsory** from age 3
- **Hungarian language**

### Private/International Kindergartens

- English-language options available
- Various curricula (Montessori, Waldorf, etc.)
- Fees: €300-1,000/month

### Finding Kindergarten

- Start search early (popular ones fill up)
- Consider location (near home or work)
- Visit multiple options
- Consider language needs

## Higher Education

### University Landscape

Budapest has excellent universities:

**Top institutions**:
- ELTE (Eötvös Loránd University) — largest
- BME (Budapest University of Technology)
- Corvinus University — economics, business
- CEU (Central European University) — graduate
- Semmelweis University — medicine

### Studying in English

**Available**:
- Many programs offered in English
- Medicine especially popular (international students)
- Business, engineering, humanities

**Costs**:
- Hungarian programs: Often free for residents
- English programs: €2,000-10,000/year (varies)
- Medicine: €10,000-15,000/year

### International Students

**Why Budapest**:
- Quality education
- Affordable living
- English programs available
- EU degree recognition
- Vibrant student life

**Visa requirements**: Non-EU need student visa

### Student Life

- Affordable city
- Active social scene
- International community
- Good public transport (student discounts)
- Many part-time work opportunities

## Extracurricular Activities

### Music & Arts

- Zeneakadémia (Music Academy) programs
- Various music schools
- Art classes, drama
- Strong classical tradition

### Sports

- Popular: Football, water polo, swimming
- Many sports clubs
- School teams
- Public facilities available

### Languages

- Language schools plentiful
- Private tutoring available
- Exchange programs

## Special Needs Education

### Public System

- Support available but variable
- Integration policies in place
- Resource limitations

### Private/International

- Better resources typically
- Learning support programs
- Smaller class sizes help
- Costs higher

### Resources

- Contact schools directly about support
- Advocacy organizations exist
- Private specialists available

## Practical Information

### School Calendar

**Academic year**: September to June
- **Fall break**: Late October (1 week)
- **Christmas break**: Late December (2 weeks)
- **Spring break**: April (1 week)
- **Summer**: July-August

### School Day

**Typical hours**:
- Primary: 8am-1pm
- Secondary: 8am-2pm
- After-school programs available

### Transport

- Public transit student discounts
- School buses (some international schools)
- Parent coordination for carpooling

### Homework & Expectations

- Hungarian schools: Significant homework
- International: Varies by school
- Parental involvement expected

## Making the Decision

### Key Questions

1. **How long staying?** (Short: international. Long: consider integration)
2. **Language priorities?** (English continuation vs. Hungarian immersion)
3. **Budget?** (International expensive, public free)
4. **Child's age?** (Younger = easier language adaptation)
5. **Future plans?** (Where for university/next move?)

### Typical Expat Choice

**Short-term (1-3 years)**: International school
**Long-term/permanent**: International or bilingual program
**Very young children**: More flexibility, consider Hungarian

### Resources

**For research**:
- School websites
- Expat forums (experiences)
- Embassy recommendations
- School visits

**Support**:
- Relocation companies
- Expat family networks
- Education consultants
