# Business in Budapest

## Overview

Hungary offers:
- EU membership (market access)
- Competitive tax rates
- Educated workforce
- Central European location
- Lower costs than Western Europe

## Business Structures

### Company Types

**Kft (Korlátolt Felelősségű Társaság)**
- Limited Liability Company
- Most common for small/medium
- Min capital: HUF 3,000,000 (~€7,500)
- 1+ shareholders

**Zrt (Zártkörűen Működő Részvénytársaság)**
- Private Limited Company
- For larger businesses
- Min capital: HUF 5,000,000 (~€12,500)
- More complex structure

**Bt (Betéti Társaság)**
- Limited Partnership
- Less common
- Simpler but more liability risk

**Egyéni Vállalkozó**
- Sole Proprietor
- Simplest
- Full personal liability
- Good for freelancers

### Choosing Structure

**Freelancer/Small**: Kft or Egyéni Vállalkozó
**Growing company**: Kft
**Investment/scaling**: Zrt consideration

## Company Formation

### Kft Setup

**Timeline**: 1-2 weeks with lawyer
**Cost**: €1,000-2,000 (legal fees)

**Requirements**:
- Founder(s) (any nationality)
- Registered address
- Bank account for capital
- Company name (unique)
- Articles of association

**Process**:
1. Choose name (check availability)
2. Draft articles of association
3. Open bank account, deposit capital
4. Submit to Company Registry
5. Register for tax (NAV)
6. Obtain activity licenses if needed

### Required Roles

**Managing Director (Ügyvezető)**
- Legal representative
- Can be foreign, non-resident
- Must have Hungarian tax number

**Accountant**
- Required by law
- Monthly reporting
- Tax filings

### Registered Address

- Physical address in Hungary
- Can be virtual office
- Many providers available
- ~€50-150/month

## Taxation

### Corporate Taxes

| Tax | Rate |
|-----|------|
| Corporate Income Tax | 9% (lowest in EU) |
| Local Business Tax | ~2% (varies by municipality) |
| Social Contribution Tax | 13% (employer) |

**Effective rate**: ~11-15% overall

### Personal Taxes (for employees)

| Tax | Rate |
|-----|------|
| Personal Income Tax | 15% (flat) |
| Social Security | 18.5% (employee) |

### VAT

- Standard: 27% (highest in EU)
- Reduced: 18%, 5% (some goods)
- B2B services: Often reverse charge
- Threshold for registration: Low

### Tax Incentives

- R&D tax credit
- Development tax allowance
- Various sector incentives
- KIVA (small business simplified)

## Accounting & Compliance

### Requirements

**Monthly**:
- VAT returns (if applicable)
- Social contribution filings
- Payroll processing

**Annual**:
- Financial statements
- Corporate tax return
- Local business tax return

### Bookkeeping

**Options**:
- In-house accountant
- Accounting firm
- Online services (emerging)

**Costs**: €200-500/month (small company)

### Invoicing

**Must include**:
- Sequential number
- Both party details
- Tax numbers
- Item descriptions
- VAT breakdown
- Date

**Digital**: Electronic invoicing system (NAV Online)

## Banking

### Business Accounts

**Major banks**:
- OTP
- Erste
- K&H
- Raiffeisen
- CIB

**Process**:
- Visit branch with documents
- Company registration papers
- ID of signatories
- 1-2 weeks to open

**Digital alternatives**:
- Wise Business (popular for international)
- Revolut Business

## Employment

### Hiring

**Contract requirements**:
- Written contract mandatory
- Probation max 3 months
- Notice periods defined by law
- Annual leave 20+ days

**Costs beyond salary**:
- Employer social tax: 13%
- Various contributions
- Budget 1.25x gross salary

### Contractors vs Employees

**Be careful**: Hungary has strict rules
- Continuous relationship = employee
- Risk of reclassification
- Use properly if legitimate

### Payroll

**Options**:
- In-house
- Accountant handles
- Payroll services

**Frequency**: Monthly standard

## For Freelancers

### Sole Proprietor (Egyéni Vállalkozó)

**Pros**:
- Simple setup
- Lower admin
- KATA option (was attractive, now limited)

**Cons**:
- Personal liability
- KATA heavily restricted post-2022
- Now less attractive than before

### KATA (Simplified Tax)

**Post-2022 changes**: Mostly limited to:
- Certain retail/service
- Income from individuals only
- Not viable for most tech freelancers

### Alternative: One-Person Kft

**Pros**:
- Limited liability
- Professional image
- Tax planning options

**Cons**:
- Higher admin costs
- Accounting required
- Capital requirement

## For Digital Nomads

### Legal Options

**Digital Nomad Visa (White Card)**:
- Work for foreign company
- Don't serve Hungarian clients
- 1-2 years validity
- Simplest legal option

**Establish Company**:
- If serving Hungarian clients
- If wanting EU presence
- More complex but full rights

### Tax Residency

**183-day rule**: 
- 183+ days = tax resident
- Hungarian tax on worldwide income
- Proper planning important

**Consult accountant** before establishing

## Business Culture

### Characteristics

- More formal than US/UK
- Relationships matter
- Punctuality expected
- Written communication formal
- Hierarchy respected

### Meetings

- Start with pleasantries
- Business cards exchanged
- Decisions may take time
- Follow up in writing

### Language

- Hungarian for local business
- English widely used in international
- German helpful for some sectors

## Government Relations

### Bureaucracy

- Can be slow
- Hungarian documents
- Patience required
- Professional help valuable

### Incentives

- Investment incentives exist
- Sector-specific programs
- Regional development funds
- EU co-financed programs

## Common Challenges

### Administration

- Language barrier
- Multiple agencies
- Paper-heavy processes
- Solution: Good accountant + lawyer

### Banking

- Conservative banks
- Due diligence thorough
- International transfers can be slow

### Hiring

- Talent competition
- Rising salary expectations
- Notice periods long

## Resources

### Government

- Hungarian Investment Promotion Agency
- Chamber of Commerce
- Enterprise Europe Network

### Professional

- International law firms
- Big 4 accounting
- Local specialists

### Community

- AmCham Hungary
- German-Hungarian Chamber
- Various bilateral chambers
- Startup communities
