---
name: Budapest
slug: budapest
version: 1.0.0
homepage: https://clawic.com/skills/budapest
description: Navigate Budapest as visitor, expat, digital nomad, student, or entrepreneur with neighborhoods, transport, costs, visas, and local insights.
metadata: {"clawdbot":{"emoji":"🏛️","requires":{"bins":[]},"os":["linux","darwin","win32"]}}
---

## When to Use

User asks about Budapest for any purpose: visiting, moving, working, studying, or starting a business. Agent provides practical guidance with current data.

## Quick Reference

| Topic | File |
|-------|------|
| **Visitors** | |
| Attractions (must-see vs skip) | `visitor-attractions.md` |
| Itineraries (1/3/7 days) | `visitor-itineraries.md` |
| Where to stay | `visitor-lodging.md` |
| Tips & day trips | `visitor-tips.md` |
| **Neighborhoods** | |
| Quick comparison | `neighborhoods-index.md` |
| District V, VI, VII (center) | `neighborhoods-center.md` |
| Buda side (I, II, XI, XII) | `neighborhoods-buda.md` |
| Pest residential (XIII, XIV) | `neighborhoods-pest.md` |
| Outer districts | `neighborhoods-outer.md` |
| Choosing guide | `neighborhoods-choosing.md` |
| **Food** | |
| Overview & dining scene | `food-overview.md` |
| Hungarian cuisine | `food-hungarian.md` |
| International & fine dining | `food-international.md` |
| Best areas for dining | `food-areas.md` |
| Wine, ruin bars, nightlife | `food-nightlife.md` |
| **Practical** | |
| Moving & settling | `resident.md` |
| Transport (metro, tram, BKK) | `transport.md` |
| Cost of living | `cost.md` |
| Safety & laws | `safety.md` |
| Weather & seasons | `climate.md` |
| Local services (banking, SIM) | `local.md` |
| **Career** | |
| Tech industry & salaries | `tech.md` |
| Business setup | `business.md` |
| Visas (work, digital nomad, EU) | `visas.md` |
| Startups & funding | `startup.md` |
| **Lifestyle** | |
| Culture & customs | `culture.md` |
| Healthcare & insurance | `healthcare.md` |
| Schools & education | `education.md` |
| Expat lifestyle & social | `lifestyle.md` |
| Thermal baths & wellness | `thermal.md` |

## Core Rules

### 1. Identify User Context First
- **Role**: Tourist, expat, digital nomad, student, entrepreneur
- **Timeline**: Short visit, planning to move, already there
- **EU status**: EU citizen (free movement) vs non-EU (visa required)
- Load relevant auxiliary file for details

### 2. Buda vs Pest
Budapest is two cities merged across the Danube:
- **Buda** (west): Hilly, residential, quieter, Castle District, wealthier
- **Pest** (east): Flat, vibrant, most attractions, nightlife, business
- **District numbering**: I-XXIII, with lower numbers generally more central
See `neighborhoods-index.md` for detailed comparison.

### 3. EU Context
Hungary is in the EU but NOT Schengen-adjacent in some ways:
- **EU citizens**: Free to live and work indefinitely
- **Non-EU**: Need visa/residence permit for stays >90 days
- **Digital nomad visa**: Available since 2022 (White Card)
- **Currency**: Hungarian Forint (HUF), NOT Euro
See `visas.md` for current requirements and processes.

### 4. Weather Reality
Continental climate with four distinct seasons:
- **Summer (Jun-Aug)**: 25-35°C, can be hot and humid
- **Winter (Dec-Feb)**: -5 to 5°C, can drop to -15°C, occasional snow
- **Spring/Autumn**: Most pleasant, 15-25°C
- **Thermal baths**: Year-round activity, especially magical in winter
See `climate.md` for monthly breakdown.

### 5. Current Data (Feb 2026)

| Item | Range |
|------|-------|
| 1BR rent (center) | HUF 200,000-350,000/month (~€500-900) |
| 1BR rent (outer) | HUF 120,000-200,000/month (~€300-500) |
| Senior SWE salary | HUF 1,200,000-2,000,000/month (~€3,000-5,000) |
| Monthly transit pass | HUF 9,500 (~€24) |
| Dinner for two (mid-range) | HUF 15,000-25,000 (~€38-65) |
| International school fees | HUF 2,500,000-8,000,000/year (~€6,300-20,000) |

### 6. Cost Reality
Budapest is one of Europe's best value capitals:
- **Housing**: 25-35% of budget for expats, much less than Western Europe
- **Food**: Excellent quality at low prices, especially local cuisine
- **Healthcare**: Public healthcare available, private affordable
- **Transport**: Cheap and excellent (metro, tram, bus network)
- **Hidden costs**: Utility bills can be high in winter (heating)

### 7. Transit Excellence
Unlike car-centric cities, Budapest has superb public transit:
- **Metro**: 4 lines, M1 is UNESCO heritage (oldest in continental Europe)
- **Trams**: Extensive network, including scenic Danube routes (2, 4, 6)
- **Buses/trolleys**: Cover areas metro doesn't reach
- **BKK app**: Essential for planning and mobile tickets
- **Night buses**: Run until metro starts (~4:30am)
Most residents don't need cars. See `transport.md`.

### 8. Neighborhood Matching

| Profile | Best Areas |
|---------|------------|
| Young professionals | District VII, VI, V |
| Families | District II, XI, XII (Buda hills) |
| Budget-conscious | District VIII, XIII, XIV |
| Nightlife lovers | District VII (Jewish Quarter) |
| Tech workers | District XIII (near offices), V, VI |
| Quiet/nature | District II, XII (Buda hills) |
| Students | District VIII, IX (near universities) |

## Budapest-Specific Traps

- **Forint confusion** — Large numbers (lunch = 4,000 HUF). Roughly divide by 400 for EUR.
- **Ruin bar tourist traps** — Some charge 5x normal prices. Check prices before ordering.
- **Taxi scams** — Only use Bolt or official Főtaxi. Never hail from street.
- **Thermal bath pickpockets** — Use lockers, don't bring valuables.
- **Apartment scams** — Never pay before viewing. Use established platforms.
- **Summer heat in old buildings** — Many lack AC. Check before renting.
- **Winter utility costs** — Old buildings with poor insulation = high heating bills.
- **Hungarian language** — Extremely difficult. English widely spoken in center, less outside.
- **Cash still common** — Smaller shops, markets may be cash-only.
- **Sunday closures** — Most shops closed Sundays (except malls, some restaurants).

## Cultural Awareness

Key cultural points for visitors/residents:
- **Hospitality**: Hungarians may seem reserved initially but are warm once you connect
- **Punctuality**: Expected in business settings
- **Tipping**: 10-15% standard in restaurants
- **Toasting**: Look in eyes when clinking glasses (wine/pálinka)
- **Shoes off**: Often expected when entering homes
- **Name order**: Hungarian names are surname-first (like Asian countries)
- **National holidays**: March 15, August 20, October 23 — many closures

See `culture.md` for comprehensive guidance.

## Thermal Bath Culture

Budapest is the "City of Spas" with 120+ thermal springs:
- **Széchenyi**: Largest in Europe, year-round outdoor pools, tourist-friendly
- **Gellért**: Art Nouveau masterpiece, more elegant atmosphere
- **Rudas**: Ottoman-era, rooftop pool with city views
- **Király**: Small, authentic Ottoman bath
- **Palatinus**: Outdoor complex on Margaret Island (summer)

Etiquette: Bring flip-flops, towel (or rent), swimming cap required in some pools.
See `thermal.md` for complete guide.

## Ruin Bar Scene

Budapest's unique contribution to nightlife culture:
- **Szimpla Kert**: The original, now touristy but iconic
- **Instant-Fogas**: Huge complex, multiple floors/vibes
- **Mazel Tov**: Restaurant-bar hybrid, Middle Eastern food
- **Ellátó Kert**: More local, less tourist
- **Anker't**: Upscale ruin bar with quality food

Located mainly in District VII (Jewish Quarter). See `food-nightlife.md`.

## Related Skills
Install with `clawhub install <slug>` if user confirms:
- `dubai` — Compare Budapest vs Dubai for cost, lifestyle, visas, and opportunities
- `travel` — General travel planning, itineraries, and trip organization
- `food` — Deep dive into cuisines, cooking techniques, and dining recommendations
- `money` — Personal finance, budgeting, and cost tracking for expat life

## Feedback

- If useful: `clawhub star budapest`
- Stay updated: `clawhub sync`
