# Bucharest Visitor Tips

## Before You Arrive

### Money
- **Currency**: Romanian Leu (RON), ~5 RON = €1
- **ATMs**: Everywhere, use BRD or BCR to avoid fees
- **Cards**: Widely accepted in shops, restaurants; carry cash for small purchases
- **Tipping**: 10% standard, not always included
- **Best option**: Revolut or Wise card — best exchange rates

### Phone & Internet
- **SIM cards**: Buy at airport or any Orange/Vodafone/Digi shop
- **Cost**: ~€5 for 30GB data
- **WiFi**: Excellent everywhere, Romania has some of Europe's fastest internet
- **Required**: Passport for SIM purchase

### What to Pack

**Summer (Jun-Aug)**
- Light clothing
- Sunscreen and hat
- Light jacket for AC indoors
- Comfortable walking shoes

**Winter (Dec-Feb)**
- Warm coat (temperatures can drop to -10°C)
- Layers
- Waterproof boots
- Gloves, hat, scarf

**Year-round**
- Comfortable walking shoes (cobblestones!)
- Umbrella (rain unpredictable)
- Power adapter (EU Type C/F)

---

## Getting Around

### From Airport (OTP - Henri Coandă)

| Option | Cost | Time | Notes |
|--------|------|------|-------|
| Express Bus 783 | 10 RON (~€2) | 40-60 min | To Unirii, every 15 min |
| Taxi | 80-120 RON (~€16-25) | 30-45 min | Use only official taxis or apps |
| Bolt/Uber | 50-80 RON (~€10-16) | 30-45 min | Best value |
| Private transfer | €25-35 | 30-45 min | Pre-booked, fixed price |

**Warning**: NEVER take taxi from arrivals hall solicitors — scams guaranteed. Use app or official taxi stand only.

### In-City Transport

**Metro**
- 4 lines, covers main areas
- Single ride: 3 RON (~€0.60)
- Day pass: 8 RON (~€1.60)
- Monthly: 80 RON (~€16)
- Runs 5am-11pm

**Buses/Trams/Trolleys**
- Extensive network
- Same tickets as metro (STB card)
- Can be crowded and slow

**Bolt/Uber**
- Most popular transport method
- Very cheap (€2-5 most rides)
- Always available
- Pay with card in app

**Taxis**
- Only use apps (Star Taxi, Speed Taxi)
- Or call: 021-9424 (Star Taxi)
- NEVER hail on street
- Rate: ~2 RON/km

### Scam Prevention

1. **Never take taxi from airport hall** — always go to official stand or use app
2. **Check meter is running** — if not, get out
3. **Know approximate price** — Old Town to airport ~80 RON
4. **Use apps** — Bolt has fixed prices shown upfront

---

## Food & Drink

### Must-Try Romanian Food

| Dish | What It Is | Where to Try |
|------|------------|--------------|
| Mici (mititei) | Grilled minced meat rolls | Any terrace or Obor market |
| Sarmale | Cabbage rolls with meat | Caru' cu Bere, Lacrimi și Sfinți |
| Ciorbă de burtă | Tripe soup (trust me) | Traditional restaurants |
| Mămăligă | Polenta (side dish) | Everywhere with meat dishes |
| Papanași | Fried doughnuts with sour cream | Any dessert menu |
| Cozonac | Sweet bread (Christmas) | Bakeries |

### Where to Eat

**Traditional (Tourist-Friendly)**
- **Caru' cu Bere** — Historic, touristy but authentic food
- **Lacrimi și Sfinți** — Upscale traditional
- **Zexe** — Best for brunch

**Local Favorites (Less Tourist)**
- **La Mama** — Chain but good quality
- **Hanu' lui Manuc** — Historic inn, Old Town
- **Energiea** — Fast healthy food

**International/Modern**
- **Kaiamo** — Fine dining, tasting menu
- **The Artist** — French-Romanian fusion
- **Shift Pub** — Burgers, casual

### Drinking

- **Beer**: Ursus, Ciuc, Timișoreana (local), many craft options
- **Wine**: Romanian wines excellent and cheap — try Fetească or Tămâioasă
- **Țuică/Palincă**: Plum brandy, traditional, STRONG (40-60%)
- **Coffee**: Good everywhere, ~10-15 RON for specialty

### Tipping Guide

| Service | Tip |
|---------|-----|
| Restaurants | 10% (check if included) |
| Bars | Round up |
| Taxis | Round up (if good) |
| Hotels | 10-20 RON for special service |

---

## Day Trips

### Within 2 Hours

**Snagov Monastery** (30 min)
- Island monastery, alleged Dracula tomb
- Beautiful lake setting
- Half-day trip
- Rent car or book tour

**Mogoșoaia Palace** (30 min)
- 17th century palace with gardens
- Less crowded than central museums
- Good for families

**Comana Natural Park** (45 min)
- Wetlands, birdwatching
- Monastery
- Nature escape

### Full Day (3-4 hours each way)

**Brașov + Peleș Castle**
- Most beautiful Romanian city + castle
- Book tour or rent car
- Leave by 7-8am
- Long but worth it

**Bran Castle ("Dracula's Castle")**
- Touristy but iconic
- Combine with Râșnov
- Better as overnight in Brașov

**Sinaia**
- Mountain resort town
- Peleș Castle is here
- Cable car to mountains
- Can combine with Brașov

### Organized Tours
- **Cost**: €50-100 per person for day trips
- **Book**: GetYourGuide, Viator, or hotel
- **Pros**: No planning, transport included
- **Cons**: Rushed, group pace

---

## Safety & Etiquette

### Safety

**Bucharest is generally safe**, but:
- Watch for pickpockets in Old Town and metro
- Don't flash expensive items
- Avoid deserted areas late night
- Use only ride-hailing apps or official taxis

**Emergency numbers**:
- General emergency: **112**
- Police: **112** (same)
- Ambulance: **112** (same)

### Etiquette

- **Greetings**: Handshake, direct eye contact
- **Shoes**: May be asked to remove in homes
- **Gifts**: Wine or flowers when visiting someone
- **Flowers**: Odd numbers only (even = funerals)
- **Personal space**: Closer than Northern Europe, normal

### Photography
- Generally fine everywhere tourist
- Ask before photographing people
- Some museums no flash or no photos
- Government buildings — use discretion

---

## Useful Apps

| App | Purpose |
|-----|---------|
| Bolt | Rides (most popular) |
| Uber | Rides (backup) |
| Google Maps | Navigation (works great) |
| Revolut | Money/payments |
| Google Translate | Romanian offline pack |
| Citymapper | Public transport |
| Foursquare | Finding restaurants |

---

## Common Mistakes

1. **Taking street taxis** — Use apps only
2. **Not carrying cash** — Some places still cash only
3. **Underestimating winter** — It gets COLD
4. **Only staying in Old Town** — Explore other neighborhoods
5. **Eating at tourist trap restaurants** — Check reviews first
6. **Not booking Palace of Parliament** — Tours fill up
7. **Expecting everything to be cheap** — Prices rising, especially dining
8. **Ignoring day trips** — Transylvania is amazing and accessible
9. **Not trying țuică** — Cultural experience (but pace yourself)
10. **Judging by first impressions** — City reveals itself slowly

---

## Best Times to Visit

| Month | Weather | Crowds | Events |
|-------|---------|--------|--------|
| Jan-Feb | Cold, possible snow | Low | — |
| Mar-Apr | Warming, rain | Medium | Easter |
| May-Jun | Warm, pleasant | Medium-High | — |
| Jul-Aug | Hot | High | Festivals |
| Sep-Oct | Perfect weather | Medium | — |
| Nov | Cool, gray | Low | — |
| Dec | Cold | High | Christmas markets |

**Best overall**: May-June or September-October
**Budget travel**: January-February (except NYE)
**Avoid if**: Hate cold — skip Dec-Feb
