# Visas & Residency in Bucharest

## Quick Reference

| Your Status | Stay Duration | What You Need |
|-------------|---------------|---------------|
| EU/EEA citizen | Unlimited | ID/Passport, register after 3 months |
| UK citizen | 90 days visa-free, then permit | Withdrawal Agreement applies |
| US/UK/etc tourist | 90/180 days | Valid passport |
| Working in Romania | Work permit + visa | Employer sponsors |
| Student | Student visa | University acceptance |
| Digital nomad | Complex (see below) | No specific visa yet |

---

## EU/EEA/Swiss Citizens

### Rights
- Free movement, work, live
- No visa required
- Register after 3 months (required)
- Access to public services
- Can bring family members

### Registration Process

**After 3 Months**
1. Go to local city hall (Primărie)
2. Bring: ID/Passport, proof of address, proof of income or employment
3. Receive registration certificate
4. Valid 5 years, renewable

**Required Documents**
- Valid passport or national ID
- Rental contract or property deed
- Employment contract OR bank statements showing income
- Health insurance (EHIC or private)

### Optional: Romanian ID Card
- Can apply after registration
- Useful for local bureaucracy
- Not required

---

## UK Citizens (Post-Brexit)

### Short Stays
- 90 days within 180-day period
- No visa required
- Tourist status

### Long Stays
- Need residence permit
- Apply before 90 days expire
- Same rights as EU for those registered before 2021
- New arrivals: Standard third-country rules

### Process
1. Gather documents
2. Apply at Immigration Office (IGI)
3. Provide biometrics
4. Wait for processing
5. Receive residence card

---

## Non-EU Citizens

### Short Stay (Schengen)

**Visa-Free Countries** (90/180 days)
- USA, Canada, Australia, NZ, Japan, South Korea, etc.
- Check specific list for your country
- No work allowed

**Visa Required**
- Apply at Romanian embassy/consulate
- Before travel
- Usually 15-30 days processing

### Long Stay Visa (Type D)

**Required For**
- Work
- Study
- Family reunification
- Business
- Other purposes > 90 days

**Process**
1. Get approval from Romanian authorities (varies by purpose)
2. Apply at embassy with approval
3. Enter Romania with visa
4. Apply for residence permit within 30 days

---

## Work Permits

### Who Needs One
- All non-EU citizens working in Romania
- Exceptions: EU Blue Card holders from other EU countries

### Types

**Standard Work Permit**
- Employer-sponsored
- Specific job
- Valid 1 year, renewable
- Quota system (limited numbers)

**EU Blue Card**
- High-skilled workers
- Higher salary threshold
- EU-wide validity
- Easier family reunification

**ICT Permit**
- Intra-company transfers
- International companies
- Managerial/specialist roles

### Process (Employer-Driven)

1. **Employer applies** to labor authorities
2. **Labor market test** (can Romanian/EU fill role?)
3. **Approval** (1-2 months)
4. **Employee applies** for visa at embassy
5. **Entry** with work visa
6. **Apply** for residence permit in Romania

### Costs
- Application fees: €100-200
- Legal assistance: €500-2,000
- Processing time: 1-3 months total

### Requirements
- Job offer/contract
- Qualifications proof
- Clean criminal record
- Health insurance
- Proof of accommodation

---

## Student Visas

### Process
1. Get acceptance from Romanian university
2. Apply for student visa at embassy
3. Enter Romania
4. Register at university
5. Apply for residence permit

### Requirements
- University acceptance letter
- Proof of funds
- Health insurance
- Accommodation proof
- Return ticket (sometimes)

### Rights
- Study at institution
- Limited work (usually 4 hours/day)
- Valid during studies

---

## Digital Nomads

### Current Situation (2026)
- **No specific digital nomad visa** yet
- Options: Tourist (90 days), multiple entries, or residence permit

### Workarounds

**Option 1: Tourist Visa Hopping**
- 90 days in Romania
- Leave to non-Schengen
- Return for another 90 days
- Legal but not ideal long-term

**Option 2: Other EU Base**
- Get residence in Portugal, Spain, etc. (easier DN visas)
- Travel to Romania freely

**Option 3: Business Setup**
- Open SRL or PFA
- Self-employed residence
- More complex but legal

**Option 4: Employment**
- Get hired by Romanian company
- Remote work possible
- Full legal status

### Practical Reality
- Immigration enforcement variable
- Many nomads stay longer
- Risk exists but rarely enforced
- Better to legalize if long-term

---

## Family Reunification

### For EU Citizens
- Family members can join
- Apply for family member card
- Same rights as sponsor

### For Non-EU Workers
- Spouse and children can apply
- After 1 year residence typically
- Dependent visa

### Required Documents
- Marriage certificate (translated, apostilled)
- Birth certificates (children)
- Proof of relationship
- Sponsor's residence proof
- Accommodation
- Financial means

---

## Permanent Residence

### EU Citizens
- After 5 years continuous residence
- Apply for permanent residence card
- Valid indefinitely

### Non-EU Citizens
- After 5 years on temporary residence
- Additional requirements:
  - Continuous legal stay
  - Income proof
  - Clean record
  - Romanian language (basic)
  - Health insurance

---

## Citizenship

### Requirements
- 8 years residence OR
- 5 years if married to Romanian OR
- 4 years if born in Romania
- Romanian language (B1 level)
- Knowledge of Romanian culture/constitution
- Clean criminal record
- Financial stability

### Process
- Apply to National Citizenship Authority
- Interview
- Oath ceremony
- 1-2 years processing

### Benefits
- EU citizenship
- Visa-free travel globally
- Vote in elections
- Dual citizenship allowed

---

## Immigration Offices

### Main Office
**Inspectoratul General pentru Imigrări (IGI)**
- Strada Nicolae Iorga nr. 29, Bucharest
- Appointments recommended
- Long waits possible

### Sector Offices
- Each Bucharest sector has an office
- Varies by residence address

### Tips
- Make appointments online
- Arrive early
- Bring all documents
- Expect delays
- Consider using immigration lawyer

---

## Useful Contacts

| Service | Contact |
|---------|---------|
| Immigration Office | 021-310-8615 |
| Appointments | portal.mai.gov.ro |
| Emergency | 112 |
| Embassy (find yours) | Search "Embassy of [country] Bucharest" |

---

## Common Mistakes

1. **Overstaying tourist visa** — Can result in fines, bans
2. **Working on tourist visa** — Illegal, avoid
3. **Missing registration (EU)** — Required, can cause issues
4. **Incomplete documents** — Causes delays
5. **Not using lawyers** — Complex cases need help
6. **Last-minute applications** — Start early

---

## Getting Help

### Immigration Lawyers
- Recommended for complex cases
- €300-1,500 for full process
- Search "immigration lawyer Bucharest"

### Relocation Services
- Full package: visa, housing, settling
- €1,000-5,000 depending on scope
- Good for corporate relocations

### Expat Groups
- Facebook: "Expats in Bucharest"
- Lots of visa advice (verify with official sources)
