# Transport in Bucharest

## Overview

Bucharest has decent public transport and excellent ride-hailing. Most residents use a combination. Car ownership optional but useful for day trips.

| Mode | Best For | Cost |
|------|----------|------|
| Metro | Fast cross-city | €0.60/ride |
| Bus/Tram | Local coverage | €0.60/ride |
| Bolt/Uber | Door-to-door | €3-8/ride |
| Taxi | When no app | €3-8/ride |
| Car | Day trips, suburbs | Varies |

---

## Metro (Metrorex)

### Network
- **5 lines** (M1-M5)
- **Stations**: 63
- **Hours**: 5:00am - 11:00pm
- **Frequency**: 3-8 minutes

### Lines

| Line | Color | Key Stations | Notes |
|------|-------|--------------|-------|
| M1 | Yellow | Pipera, Universitate, Gara de Nord | Most useful |
| M2 | Blue | Aviatorilor, Universitate, Berceni | Central spine |
| M3 | Red | Titan, Eroilor, Preciziei | East-west |
| M4 | Green | Gara de Nord, Străulești | Short |
| M5 | Orange | Drumul Taberei, Eroilor | Newest |

### Key Interchanges
- **Universitate**: M1 + M2
- **Eroilor**: M1 + M3 + M5
- **Gara de Nord**: M1 + M4

### Tickets & Cards

| Type | Price | Notes |
|------|-------|-------|
| Single ride | 3 RON (~€0.60) | 2 trips per card |
| Day pass | 8 RON (~€1.60) | Unlimited |
| Weekly | 25 RON (~€5) | Best value short-term |
| Monthly | 80 RON (~€16) | For regulars |

### How to Buy
- Ticket machines at stations
- Staffed booths
- Cash or card
- Touch card on turnstile

### Tips
- Download Metrorex app for live times
- Rush hour: 7-9am, 5-7pm (crowded)
- AC in trains (summer relief)
- Safe, generally clean

---

## Surface Transport (STB)

### Network
- **Buses**: Most routes
- **Trams**: Historic, some lines
- **Trolleybuses**: Electric, various

### Hours
- Generally 5am-11pm
- Night buses (N prefix): 11pm-5am
- Frequency varies (5-30 min)

### Payment
- **Same card** as metro (STB card)
- Or **buy on bus** (slightly more)
- Validate on board

### Tickets

| Type | Price | Notes |
|------|-------|-------|
| Single | 3 RON | One ride |
| Daily | 8 RON | Unlimited bus/tram |
| Combined metro+surface | 10 RON/day | Best for mixed use |

### Apps
- **Info TB**: Official, real-time
- **Google Maps**: Works well
- **Moovit**: Alternative

### Tips
- Check which door validates
- Can be slow in traffic
- Useful for last mile from metro
- Night buses: less reliable

---

## Ride-Hailing

### Bolt
- **Most popular** in Bucharest
- **Cheap**: €2-5 most rides
- **Reliable**: Usually under 5 min wait
- **Payment**: Card or cash

### Uber
- Also available
- Similar pricing to Bolt
- Less popular but reliable
- Good as backup

### How to Use
1. Download app
2. Set pickup and destination
3. See price upfront
4. Request ride
5. Pay via app (preferred) or cash

### Price Examples

| Route | Bolt/Uber |
|-------|-----------|
| Old Town → Floreasca | €3-5 |
| Center → Airport | €10-18 |
| Center → Pipera | €5-8 |
| Universitate → Herăstrău | €4-6 |

### Tips
- Use card payment (safer)
- Check car details match
- Rate drivers
- Surge pricing at peak times

---

## Taxis

### ONLY Use Apps or Phone

**Safe Methods**
- **Star Taxi app** or 021-9424
- **Speed Taxi**: 021-9477
- **Meridian**: 021-9444

**NEVER** hail taxis on street (scam risk)

### Rates
- Start: 2-3 RON
- Per km: 2-3 RON
- Typical ride: 15-40 RON

### Red Flags
- Driver refuses meter
- "Meter broken"
- Price negotiation offered
- Hanging around tourist spots

### Tips
- Agree to meter before starting
- Know approximate distance
- Have small bills ready
- Get receipt if needed

---

## To/From Airport

### Henri Coandă Airport (OTP)

| Method | Cost | Time | Notes |
|--------|------|------|-------|
| Express Bus 783 | 10 RON | 40-60 min | To Piața Unirii |
| Bolt/Uber | 50-80 RON | 30-45 min | Best value |
| Taxi | 80-120 RON | 30-45 min | Only official or app |
| Private transfer | €25-35 | 30-45 min | Pre-booked |
| Train (CFR) | 6 RON | 25 min | To Gara de Nord |

### Bus 783
- Every 15-30 minutes
- Runs 5:30am-11:30pm
- Stops at: North Station, Universitate, Unirii
- Buy ticket before boarding or on bus

### Train (New Service)
- Runs from airport to Gara de Nord
- Every 40 minutes
- Fast but limited destinations
- Good for center/north

### Tips
- NEVER take taxi from arrivals hall
- Pre-book for early flights
- Check traffic (rush hour = 90 min possible)
- Bolt is usually best value

---

## Driving

### Traffic Reality
- **Rush hours brutal**: 7-10am, 5-8pm
- **Parking difficult**: Center especially
- **Aggressive driving**: Prepare yourself
- **Road quality**: Improving but variable

### When to Drive
- Day trips outside city
- Suburban living
- Large shopping trips
- Not daily commuting

### Parking
- **Street**: Blue zones, pay by SMS or app
- **Malls**: Free usually
- **Underground**: €1-3/hour
- **Residential**: Ask landlord

### License Requirements
- **EU license**: Valid
- **Non-EU**: Valid 90 days, then convert

### Rental
- Available at airport and city
- International companies present
- ~€25-50/day
- Check insurance carefully

See driving.md for detailed driving guide.

---

## Cycling

### Current State
- **Improving** but challenging
- **Bike lanes**: Increasing, fragmented
- **Traffic**: Aggressive
- **Theft**: Risk exists

### Bike Sharing
- **I'Velo**: City bike system
- Stations around center
- App-based rental
- ~€1/30 min

### Tips
- Use parks (Herăstrău) for cycling
- Avoid main boulevards
- Lock well
- Helmet recommended

### E-Scooters
- **Bolt, Lime**: Available
- Similar pricing to bikes
- Same traffic challenges
- Popular for short trips

---

## Getting Around Apps

| App | Purpose | Essential? |
|-----|---------|------------|
| Bolt | Rides | ✓ |
| Uber | Rides (backup) | Optional |
| Google Maps | Navigation | ✓ |
| Metrorex | Metro times | Useful |
| Info TB | Bus/tram times | Useful |
| Moovit | All transport | Alternative |

---

## Common Routes

### Tourist Routes

| From | To | Best Method | Time |
|------|-----|-------------|------|
| Old Town | Palace Parliament | Walk or Bolt | 10-15 min |
| Old Town | Village Museum | Metro M2 | 20 min |
| Center | Herăstrău Park | Metro M2 | 15 min |
| Center | Therme | Bolt/Car | 30-45 min |

### Commuter Routes

| From | To | Best Method | Time |
|------|-----|-------------|------|
| Pipera | Center | Metro M1 | 25 min |
| Floreasca | Center | Metro M1 | 15 min |
| Drumul Taberei | Center | Metro M5 | 20 min |
| Titan | Center | Metro M3 | 25 min |

### Rush Hour Reality
- Metro: Crowded but moves
- Car: 2-3x normal times
- Bolt: Available but surge pricing
- Bus: Very slow

---

## Intercity Transport

### Train (CFR)
- From Gara de Nord (main station)
- To: Brașov, Sibiu, Cluj, etc.
- Book: cfrcalatori.ro
- Quality varies (InterRegio best)

### Bus
- Various private companies
- Cheaper than train often
- Book: autogari.ro or company sites
- More frequent to some destinations

### Car
- Best for flexibility
- Rental or BlaBlaCar
- Roads improving

### Airport
- Main: Henri Coandă (OTP)
- Flights to Europe and beyond
- Book early for deals
