# Tech Industry in Bucharest

## Overview

Bucharest is Romania's tech capital and one of Eastern Europe's strongest tech hubs. Home to UiPath (unicorn), Bitdefender, and major offices of Google, Amazon, Microsoft, and more.

### Why Bucharest Tech?
- **Talent pool**: Strong CS education, 10k+ graduates/year
- **Cost**: Lower than Western Europe, competitive salaries
- **Quality**: High engineering standards, good English
- **Time zone**: EU-compatible (GMT+2/+3)
- **EU membership**: Easy for European operations

---

## Tech Landscape

### Major Companies

**Unicorns & Major Romanian**
| Company | Focus | Employees | Notes |
|---------|-------|-----------|-------|
| UiPath | RPA, AI automation | 3,000+ | Global unicorn, NYSE listed |
| Bitdefender | Cybersecurity | 1,800+ | Global leader |
| eMag | E-commerce | 3,000+ | Regional Amazon equivalent |
| Elefant | E-commerce | 500+ | Books, general retail |

**Global Tech (Bucharest Offices)**
- **Google**: Engineering hub
- **Amazon**: AWS, retail
- **Microsoft**: Engineering, cloud
- **Oracle**: Major presence
- **IBM**: R&D, consulting
- **Adobe**: Engineering
- **Endava**: Large outsourcing
- **Luxoft**: Development center

### Startup Scene
- Growing rapidly
- VC funding increasing
- Incubators: TechHub, Impact Hub
- Meetups: Active tech community

---

## Tech Jobs

### Demand Areas
1. Software Development (all stacks)
2. DevOps / Cloud / SRE
3. Data Science / ML / AI
4. Cybersecurity
5. Product Management
6. QA / Testing
7. UI/UX Design

### Technology Stacks

| Type | Common Technologies |
|------|---------------------|
| Backend | Java, .NET, Python, Node.js |
| Frontend | React, Angular, Vue |
| Mobile | React Native, Flutter, Native |
| Cloud | AWS, Azure, GCP |
| Data | Python, Spark, SQL |
| DevOps | Kubernetes, Docker, Terraform |

---

## Salaries (2026)

### Monthly Net Salaries (RON & EUR)

| Role | Junior | Mid | Senior | Lead/Principal |
|------|--------|-----|--------|----------------|
| Software Developer | €1,500-2,000 | €2,500-3,500 | €3,500-5,000 | €5,000-7,000 |
| DevOps/SRE | €1,800-2,200 | €2,800-3,800 | €4,000-5,500 | €5,500-8,000 |
| Data Scientist | €1,800-2,500 | €3,000-4,000 | €4,000-6,000 | €6,000-9,000 |
| Product Manager | €1,500-2,000 | €2,500-3,500 | €4,000-5,500 | €5,500-8,000 |
| QA Engineer | €1,200-1,800 | €2,000-2,800 | €2,800-4,000 | €4,000-5,500 |
| Designer (UI/UX) | €1,300-1,800 | €2,200-3,200 | €3,200-4,500 | €4,500-6,000 |

### Notes
- **Net**: After all taxes (Romania has flat 10% income + 35% social)
- **IT exemption**: Until recently, IT had income tax exemption (changes ongoing)
- **Meal vouchers**: Common, add €150-200/month value
- **Bonuses**: Performance + annual common

### Salary Comparison

| City | Senior Dev (Net) | Notes |
|------|------------------|-------|
| **Bucharest** | €3,500-5,000 | Lower cost = same lifestyle |
| Warsaw | €3,500-5,000 | Similar |
| Prague | €4,000-5,500 | Higher costs |
| Barcelona | €3,000-4,500 | Much higher costs |
| Berlin | €4,000-6,000 | Much higher costs |
| London | €5,000-8,000 | Much higher costs |

---

## Finding Tech Jobs

### Job Boards

| Platform | Focus | Notes |
|----------|-------|-------|
| LinkedIn | All roles | Most common |
| eJobs.ro | Local market | Romanian jobs |
| BestJobs.ro | Local market | Romanian jobs |
| Hipo.ro | All levels | Growing |
| Stack Overflow Jobs | Dev focus | Less local |
| AngelList | Startups | International |

### Recruitment Agencies
- **Hays**: International placements
- **Randstad**: General + tech
- **Various local**: Freelancer-focused

### Direct Application
- Check company career pages
- LinkedIn connections
- Tech meetups networking

### Tips
1. LinkedIn profile in English
2. Update tech stack
3. GitHub portfolio helps
4. Network at meetups
5. Be open to remote

---

## Work Culture

### Typical Setup
- **Hours**: 9-6 with flexibility
- **Remote**: Common post-COVID
- **Hybrid**: Most companies
- **Vacation**: 21-25 days legal + public holidays

### Office Locations
- **Pipera**: Tech park concentration
- **Floreasca**: Modern offices
- **Center**: Some startups
- **Various**: Distributed

### Benefits Common
- Meal vouchers (card-based)
- Private health insurance
- Training budget
- Gym subsidies
- Remote work equipment
- Flexible hours

### Communication
- English: Standard in tech
- Meetings: Generally efficient
- Documentation: English typically
- Slack/Teams: Universal

---

## Remote Work

### For Remote Workers
Bucharest offers:
- Fast, cheap internet
- Low cost of living
- EU time zone
- Good coworking spaces
- Cafe culture with WiFi

### Coworking Spaces

| Space | Location | Monthly |
|-------|----------|---------|
| Impact Hub | Center | €150-250 |
| TechHub | Pipera | €200-300 |
| Qreator | Floreasca | €100-200 |
| WeWork | Various | €250-400 |
| Commons | Multiple | €150-250 |

### Work from Anywhere
- Cafes: Excellent WiFi everywhere
- Hotels: Often have work spaces
- Libraries: Free, less common

---

## Tech Community

### Meetups

| Event | Frequency | Focus |
|-------|-----------|-------|
| JSHeroes | Annual | JavaScript conference |
| DevTalks | Annual | Multi-track conference |
| Codecamp | Multiple/year | General tech |
| UX Bucharest | Monthly | Design |
| Various language groups | Monthly | Python, Java, .NET, etc. |

### How to Find
- Meetup.com
- Eventbrite
- Facebook groups
- LinkedIn events

### Communities
- Facebook: Romanian JS/Python/etc communities
- Slack: Various (ask at meetups)
- Discord: Gaming + tech overlap

---

## Freelancing

### Legal Setup
- **PFA** (Persoană Fizică Autorizată): Simplest
- **SRL** (Company): More complex, better for scale
- Tax: ~10% income + social contributions

### Finding Clients
- International: Upwork, Toptal
- Local: Networking, agencies
- Direct: LinkedIn outreach

### Rates (2026)

| Level | Hourly (EUR) |
|-------|--------------|
| Junior | €15-30 |
| Mid | €30-50 |
| Senior | €50-80 |
| Expert/Architect | €80-150 |

### Tips
- Contract in writing
- Clear scope
- Regular invoicing
- Keep receipts
- Consider accountant

---

## Education & Upskilling

### Universities (CS)
- **University Politehnica**: Top engineering
- **University of Bucharest**: Strong CS faculty
- **Academy of Economic Studies**: Tech + business

### Bootcamps
- Various coding bootcamps
- Quality varies
- Check reviews

### Continuous Learning
- Company training budgets
- Online courses (subsidized often)
- Conferences (local and international)
- Meetup learning

---

## Starting in Tech

### For Juniors
1. Complete CS degree or bootcamp
2. Build portfolio (GitHub)
3. Apply to junior positions
4. Consider internships
5. Network at meetups

### For Career Changers
1. Online courses/bootcamp
2. Personal projects
3. Start with junior roles
4. Leverage domain expertise

### For Seniors Moving to Bucharest
1. LinkedIn job search
2. Negotiate remote-first if possible
3. Consider local offers (may be lower nominal salary)
4. Calculate real value (cost of living advantage)

---

## Future Outlook

### Growth Areas
- AI/ML engineering
- Cloud/DevOps
- Cybersecurity
- Data engineering
- Green tech

### Challenges
- Talent competition increasing
- Salary expectations rising
- Some exodus to remote/international
- Infrastructure improving but not perfect

### Opportunities
- Lower competition than Western hubs
- Good entry to EU market
- Strong network effects forming
- Government tech initiatives
