# Startups & Funding in Bucharest

## Ecosystem Overview

Romania's startup ecosystem is **young but growing fast**. UiPath's success (Romania's first decacorn) proved global-scale companies can emerge from Bucharest.

### Strengths
- Strong technical talent
- Low costs vs Western Europe
- EU market access
- Growing VC presence
- Successful exits inspire new founders

### Challenges
- Small local market
- Limited late-stage funding
- Brain drain to Western Europe
- Bureaucracy for scaling
- Less mature than Western hubs

---

## Key Players

### Successful Companies (Inspiration)

| Company | Sector | Status |
|---------|--------|--------|
| UiPath | RPA/AI | NYSE listed, $10B+ |
| Bitdefender | Cybersecurity | Global leader |
| eMag | E-commerce | Acquired by Naspers |
| Elefant | E-commerce | Regional player |
| FintechOS | Fintech | Well-funded scale-up |
| Questo | Travel tech | Acquired |
| TypingDNA | Cybersecurity | Acquired |

### Investors

**Local VCs**
| Fund | Focus | Stage |
|------|-------|-------|
| Catalyst Romania | Tech | Seed-Series A |
| Early Game Ventures | Tech | Pre-seed to Seed |
| ROCA X | Tech | Seed-Series A |
| Simple Capital | Consumer, fintech | Seed |
| GapMinder | Tech | Seed-Series A |

**Regional VCs Active in Romania**
- Credo Ventures (Czech)
- Seedcamp (UK)
- 3TS Capital (CEE)
- Elevator Ventures (CEE)

**International (Later Stage)**
- Accel (UiPath investor)
- Sequoia (selective)
- European VCs for scale

### Angels
- Growing angel community
- Many UiPath alumni investing
- TechAngels Romania network
- Business Angels Romania

---

## Funding Landscape

### Typical Funding Path

| Stage | Amount | Sources |
|-------|--------|---------|
| Pre-seed | €50-150k | Angels, F&F, grants |
| Seed | €200-500k | Local VCs, angels |
| Series A | €1-3M | Local + regional VCs |
| Series B+ | €5M+ | International VCs |

### What's Fundable
- Tech products (SaaS, platforms)
- B2B strongly preferred
- International ambition required
- Deep tech gets attention
- AI/ML current hot area

### Harder to Fund
- Local-only businesses
- Consumer apps (small market)
- Capital-intensive hardware
- Lifestyle businesses

---

## Incubators & Accelerators

### In Bucharest

| Program | Focus | Stage | Notes |
|---------|-------|-------|-------|
| TechHub Bucharest | Tech | Early | Google partnership |
| Impact Hub | Social + tech | Various | Coworking + programs |
| Spherik | Tech | Seed | Accelerator |
| Startup Grind | Community | All | Events, networking |
| Innovation Labs | Various | Hackathon-style | Annual program |

### International (Accept Romanian Startups)

| Program | Location | Notes |
|---------|----------|-------|
| Seedcamp | London | Top European accelerator |
| Y Combinator | USA | Takes international |
| Techstars | Various | Multiple locations |
| 500 Global | Various | Emerging markets focus |

### How to Apply
- Online applications
- Usually 2-3 month cycles
- Demo days
- Equity varies (0-10%)

---

## Grants & Non-Dilutive Funding

### EU Funding
- Various programs available
- Horizon Europe (research)
- EIC Accelerator (scale-ups)
- Complex applications
- Large amounts possible

### Romanian Grants
- Start-Up Nation (government program)
- Up to €40,000
- Heavy bureaucracy
- Worth it if patient

### Other Sources
- EU cohesion funds
- Innovation programs
- Research grants
- Export promotion

### Tips
- Use grant consultants
- Long timelines (6-12 months)
- Don't depend on grants alone
- Combine with VC funding

---

## Legal Structure for Startups

### Standard Setup: SRL
- Most common
- Flexible for investors
- Convertible notes work
- SAFE agreements used

### For International Ambition
Many Romanian startups incorporate elsewhere for VC compatibility:

| Jurisdiction | Why | Cost |
|--------------|-----|------|
| Romania | Simple, cheap, EU | €500-1,000 |
| Estonia | E-residency, EU | €1,000-2,000 |
| Delaware (USA) | US investors want it | €2,000-5,000 |
| Netherlands | EU + US compatibility | €2,000-5,000 |

### Recommendation
- Start in Romania (cheap, fast)
- Flip to Delaware/Netherlands at Series A if needed
- Discuss with VC early

---

## Finding Co-founders

### Where to Look
- Tech meetups
- Startup Grind events
- University networks
- Coworking spaces
- LinkedIn
- AngelList

### What to Look For
- Complementary skills
- Shared commitment level
- Aligned on vision
- Can work together daily

### Tips
- Don't rush
- Test with small project
- Clear equity discussion early
- Have vesting schedules

---

## Building Your Team

### Hiring in Bucharest

**Advantages**
- Strong developers
- Lower costs than Western Europe
- Growing product/design talent
- English widely spoken

**Challenges**
- Competition for top talent
- Salary expectations rising
- Limited specialized roles
- Some leave for abroad

### Team Costs (Monthly)

| Role | Salary | Total Cost |
|------|--------|------------|
| Junior Dev | €1,500-2,000 | €1,600-2,100 |
| Senior Dev | €3,000-4,000 | €3,200-4,200 |
| Designer | €2,000-3,000 | €2,100-3,200 |
| Marketing | €1,500-2,500 | €1,600-2,600 |
| Operations | €1,500-2,000 | €1,600-2,100 |

### Alternatives
- Contractors (PFA)
- Outsourcing partners
- Remote international
- Internships (strong pipeline)

---

## Community & Networking

### Regular Events
- Startup Grind monthly
- Tech meetups (various)
- Demo days
- Pitch nights

### Conferences
- How to Web (annual, main event)
- DevTalks
- Codecamp
- Various tech conferences

### Online
- Facebook groups
- LinkedIn communities
- Slack channels (ask to join)

### Key People to Know
- Investors at local VCs
- Successful founders
- Tech community leaders
- University professors (talent pipeline)

---

## Scaling Challenges

### Product-Market Fit
- Romanian market small (20M)
- Build for global from day 1
- English as primary language
- EU as minimum market

### Hiring at Scale
- Limited senior talent
- Compete with big tech
- Consider remote-first
- Train juniors

### Fundraising
- Local VCs smaller checks
- Need international for Series B+
- Build relationships early
- Consider US/UK presence

### Bureaucracy
- Government processes slow
- Tax planning important
- Use good accountants
- Plan for compliance

---

## Success Patterns

### What Works
1. **B2B SaaS** — Clear revenue, scales globally
2. **Technical founders** — Can build v1
3. **International from day 1** — Think EU/global
4. **VC-friendly structure** — Makes funding easier
5. **Good storytelling** — Especially for international investors
6. **Network building** — Opens doors

### Common Mistakes
1. Focusing on Romania only
2. Taking too much early money
3. Complex cap tables
4. Not building relationships
5. Underpricing products
6. Hiring too fast

---

## Resources

### Must-Read
- How to Web blog
- TechCrunch for global trends
- Local startup newsletters
- Founder Twitter/LinkedIn

### Useful Tools
| Purpose | Tools |
|---------|-------|
| Legal templates | SAFE, convertible notes online |
| Cap table | Carta, Pulley |
| Accounting | Local + Romanian software |
| Banking | Revolut Business, Wise |
| HR | Local providers |

### Support Services
- Startup-friendly lawyers (€200-500/hour)
- Accountants (€100-300/month)
- Grant consultants (success-based often)
- Pitch coaches

---

## First Steps

1. **Validate idea** — Talk to customers
2. **Build MVP** — Use your technical skills
3. **Get users** — Even 10 paying customers matters
4. **Apply to accelerators** — Structure helps
5. **Network** — Meet investors early
6. **Raise when ready** — Not before
