# Safety & Laws in Bucharest

## Overall Safety

**Bucharest is safe** for a major European capital. Violent crime against foreigners is rare. Main risks: petty theft, taxi scams, minor traffic dangers.

### Safety Comparison

| vs City | Safer? | Notes |
|---------|--------|-------|
| London | Similar | Less violent crime |
| Paris | Safer | Less pickpocketing |
| Barcelona | Safer | Much less theft |
| Rome | Safer | Less scam culture |
| Prague | Similar | Comparable |
| Budapest | Similar | Comparable |

---

## Common Risks

### Pickpocketing
**Risk Level**: Low-Medium (center)

**Where**:
- Old Town (crowded nights)
- Metro (rush hour)
- Tourist attractions
- Train station (Gara de Nord)

**Prevention**:
- Front pockets or cross-body bag
- Don't flash valuables
- Be aware in crowds
- Secure backpack zippers

### Taxi Scams
**Risk Level**: High (if not careful)

**Common Tricks**:
- "Broken" meter, inflated price
- Long routes
- Refusing change
- Unlicensed vehicles

**Prevention**:
- **ONLY use apps** (Bolt, Uber)
- Or call: Star Taxi 021-9424
- Never hail from street
- Check meter starts

### ATM Skimming
**Risk Level**: Low-Medium

**Prevention**:
- Use bank ATMs (inside banks)
- Cover PIN entry
- Check for loose card slots
- Use contactless when possible
- Revolut = safer (instant notifications)

### Restaurant/Bar Scams
**Risk Level**: Low (specific areas)

**Types**:
- Inflated bills
- Items not ordered charged
- Cover charges not mentioned

**Prevention**:
- Check menu prices first
- Ask about cover charges
- Review bill carefully
- Pay by card (record)

---

## Legal Awareness

### Important Laws

**Drugs**
- **Zero tolerance**
- Cannabis: Illegal, strictly enforced
- Possession: Up to 2 years prison
- Trafficking: 3-15 years
- No medical marijuana

**Alcohol**
- Legal age: 18
- No open container laws (technically)
- Some areas restrict public drinking
- DUI: 0.00% limit (zero tolerance)
- DUI penalties: License suspension, fines, possible jail

**Smoking**
- Banned indoors (since 2016)
- All restaurants, bars, clubs
- Terraces usually allowed
- €100+ fines possible

**Photography**
- Public spaces: Generally OK
- Government buildings: Ask/avoid
- Military: Prohibited
- People: Ask permission (courtesy)
- Children: Definitely ask parents

### LGBTQ+ Rights
- Same-sex relations: Legal
- Marriage: Not recognized
- Discrimination protection: Limited
- Social acceptance: Improving
- Public affection: Use discretion
- Bucharest: More liberal than countryside

### Internet & Privacy
- No major restrictions
- VPNs: Legal
- GDPR applies (EU)
- Some gambling sites blocked

---

## Emergency Contacts

| Service | Number |
|---------|--------|
| General Emergency | **112** |
| Police | 112 |
| Ambulance | 112 |
| Fire | 112 |
| Tourist Police | 021-9544 |

### What to Do If...

**Pickpocketed**
1. Report to police (112)
2. Get incident report
3. Cancel cards
4. Contact embassy if passport stolen

**Taxi Scam**
1. Note license plate
2. Report to city taxi authority
3. Leave review on app if used one
4. Contact bank if overcharged

**Medical Emergency**
1. Call 112
2. Go to nearest hospital ER
3. Or private hospital (MedLife, Regina Maria)
4. Show insurance/EHIC if EU

**Assault/Serious Crime**
1. Call 112 immediately
2. Go to safe location
3. Contact embassy
4. Get police report
5. Seek medical attention

---

## Neighborhood Safety

### Very Safe
- Primăverii
- Dorobanți
- Herăstrău
- Aviatorilor
- Floreasca
- Cotroceni

### Generally Safe
- Old Town (day)
- Universitate
- Pipera
- Băneasa
- Titan (main areas)
- Drumul Taberei

### Use More Caution
- Old Town (night, drunk crowds)
- Gara de Nord area
- Some peripheral areas
- Abandoned industrial zones

### Areas to Avoid at Night
- Ferentari (unless you know someone)
- Rahova (some parts)
- Far outskirts
- Unlit areas anywhere

---

## For Women

### General Safety
- Solo female travel: Generally safe
- Street harassment: Less than many European cities
- Night transport: Bolt/Uber recommended
- Clubs: Standard precautions

### Tips
- Trust instincts
- Stay on lit streets at night
- Tell someone your plans
- Keep phone charged
- Bolt safer than street taxi

### Resources
- Emergency: 112
- Violence hotline: 0800-500-333

---

## Traffic Safety

### Pedestrians
- Drivers can be aggressive
- Cross at crosswalks
- Even with green light, look both ways
- Trams have right of way (always)

### Statistics Reality
- Romania has higher road fatality rates
- Urban areas safer than rural
- Pedestrian deaths declining but notable

### Tips
- Don't assume cars will stop
- Watch for bikes/scooters on sidewalks
- Crosswalks aren't always respected
- Night crossing: Extra caution

---

## Scam Awareness

### Common Scams

**Street Money Exchange**
- Illegal and scam
- Always use banks/ATMs/exchanges

**"Free" Club Entry**
- Then massive drink charges
- Ask prices before ordering

**Petition Signing**
- Distraction for pickpocketing
- Politely decline

**Damaged Taxi Meter**
- Exit immediately
- Use apps only

**Fake Police**
- Ask for badge number
- Real police don't ask for bribes
- Call 112 if suspicious

### Recognition
- Too good to be true
- Pressure tactics
- Requests for cash
- Distraction techniques

---

## Protests & Political Events

### Current Climate
- Protests occur regularly
- Generally peaceful
- Mostly political/anti-corruption
- Central areas (Victoriei, Universitate)

### If Encountered
- Move away from center
- Avoid engagement
- Usually no danger to observers
- Can block traffic

---

## Health & Environmental Safety

### Water
- Tap water: Officially safe, most drink bottled
- Bottled: Widely available

### Air Quality
- Sometimes poor (winter especially)
- Check apps on bad days
- Construction dust common

### Food Safety
- Generally good
- Standard restaurant hygiene
- Street food: Use judgment
- Market food: Fresh daily

### Extreme Weather
- Summer heat: 40°C+ possible
- Winter cold: -15°C possible
- Prepare accordingly

---

## Cybersecurity

### WiFi
- Use VPN on public networks
- Hotel/cafe WiFi: Standard precautions
- Mobile data: Safer alternative

### Banking
- Revolut/Wise: Instant notifications help
- Check statements regularly
- Report suspicious activity fast

---

## Reporting Issues

### Police Stations
- Every neighborhood has one
- English: Limited at local level
- Bring translator for serious matters

### Tourist Police
- Better English
- Specialized in tourist issues
- 021-9544

### Embassy Contacts
Keep your embassy number saved:
- US: 021-200-3300
- UK: 021-201-7200
- Check embassy website for your country
