# Moving to & Settling in Bucharest

## Before You Arrive

### Documents to Prepare

**EU/EEA Citizens**
- Valid passport or ID card
- Proof of income or employment (for registration)
- Health insurance (EHIC or private)

**Non-EU Citizens**
- Valid passport (6+ months validity)
- Visa (if required)
- Work permit (if employed)
- Proof of accommodation
- Health insurance

### What to Research
1. Neighborhood (see neighborhoods guide)
2. Cost estimates (see cost guide)
3. Visa requirements (see visas guide)
4. Job prospects (see tech/business guides)
5. Housing options

---

## First Week Checklist

### Day 1-2: Basics
- [ ] Get SIM card (Orange, Vodafone, or Digi)
- [ ] Download apps (Bolt, Glovo, Google Maps)
- [ ] Exchange money or use ATM (BRD, BCR best)
- [ ] Locate nearest supermarket
- [ ] Walk neighborhood

### Day 3-5: Admin
- [ ] Open bank account (if staying 3+ months)
- [ ] Register at town hall (EU citizens, required)
- [ ] Sort health insurance
- [ ] Get public transport card

### Day 6-7: Settle
- [ ] Find gym/fitness (if needed)
- [ ] Locate healthcare options
- [ ] Join expat groups
- [ ] Explore beyond neighborhood

---

## Accommodation

### Finding an Apartment

**Search Platforms**
- **Imobiliare.ro** — Largest, most listings
- **OLX.ro** — Second hand + real estate
- **Storia.ro** — Clean interface
- **Facebook groups** — "Expats in Bucharest", "Apartments Bucharest"

**Agencies**
- Take 1 month rent as commission
- Useful for non-Romanian speakers
- Quality varies wildly

**Direct from Owner**
- Better prices
- Romanian language helps
- More negotiation room

### Rental Process

1. **Search online** — Filter by area, budget, amenities
2. **Schedule viewings** — Multiple same day if possible
3. **View in person** — Always, no exceptions
4. **Negotiate** — Room for 5-10% usually
5. **Sign contract** — Read carefully, preferably with translation
6. **Pay deposit** — Usually 1-2 months rent
7. **Inventory check** — Document everything
8. **Utilities transfer** — Landlord should help

### Contract Tips
- Standard is 1 year
- Notice period: usually 30-60 days
- Get inventory signed by both
- Check who pays utilities
- Ensure landlord is actual owner

### Typical Costs

| Item | Cost |
|------|------|
| 1BR center | €500-800/month |
| 1BR nice area | €600-1,000/month |
| Agency fee | 1 month rent |
| Deposit | 1-2 months |
| Utilities | €80-150/month |

---

## Utilities

### Electricity (Enel, E.ON, etc.)
- Usually transfer to your name
- Pay monthly, online or bank
- Smart meters increasing

### Gas (Engie, E.ON)
- Heating in many buildings
- Winter bills significantly higher
- Meters read periodically

### Water
- Usually included in building fees
- Or separate meter

### Internet
- Excellent quality, cheap
- Digi (RCS-RDS), Orange, Vodafone
- 100-300 Mbps: €8-15/month
- Usually included in modern rentals

### Central Heating
- Many older buildings have city heating
- No individual control
- On/off dates set by city (~Oct 15 - Apr 15)
- Modern buildings: individual heating

### Monthly Utility Estimates

| Utility | Summer | Winter |
|---------|--------|--------|
| Electricity | €30-50 | €50-80 |
| Gas/Heating | €10-20 | €100-200 |
| Internet | €10-15 | €10-15 |
| Water | €10-20 | €10-20 |
| **Total** | **€60-105** | **€170-315** |

---

## Banking

### Opening an Account

**Requirements (varies by bank)**
- Passport/ID
- Proof of address (rental contract)
- Sometimes: proof of income

**Major Banks**
- **ING** — Best online, English-friendly
- **BCR** — Largest, good network
- **BRD** — Société Générale, international
- **Raiffeisen** — Austrian, solid
- **Banca Transilvania** — Romanian, growing

**Online Banks**
- **Revolut** — EU-based, excellent for expats
- **Wise** — Good for transfers
- **N26** — Works but less local support

### Recommendation
1. **Revolut** for daily use, international transfers
2. **Local bank (ING or BCR)** for Romanian bills, salary

### Bank Tips
- Most support English online
- ATM fees: use your bank's ATMs
- Card payments: universal in modern shops
- Cash: still useful for markets, small shops

---

## Healthcare

### Public vs Private

**Public (Casa de Asigurări)**
- Free/low cost for insured
- Quality varies dramatically
- Long waits possible
- Romanian language mostly

**Private (Recommended for Expats)**
- Fast, modern, English
- Pay per visit or insurance
- Main chains: MedLife, Regina Maria, Sanador

### Getting Health Insurance

**EU Citizens**
- EHIC covers emergency
- For long stay: register with CNAS

**Non-EU**
- Required for residence
- Private insurance recommended
- ~€50-150/month for good coverage

### Private Healthcare Costs

| Service | Cost |
|---------|------|
| GP consultation | €30-60 |
| Specialist | €50-100 |
| Blood tests | €20-80 |
| Dental cleaning | €40-80 |
| Emergency room | €100-300 |

### Main Private Networks

**MedLife**
- Largest network
- English available
- Good app for booking
- ~€50-100/month subscription

**Regina Maria**
- Second largest
- Modern facilities
- Popular with expats

**Sanador**
- Hospital + clinics
- Higher-end
- English support

### Pharmacies
- Everywhere
- Some 24/7
- Many medications OTC
- Chain: Catena, HelpNet, Farmacia Tei

---

## Education

### For Expat Children

**International Schools**
| School | Curriculum | Annual Cost |
|--------|------------|-------------|
| British School | UK | €10,000-18,000 |
| American International | US | €12,000-20,000 |
| International School of Bucharest | IB | €8,000-15,000 |
| Cambridge School | UK | €8,000-14,000 |
| French School | French | €6,000-10,000 |

**Location**: Most in Pipera/Băneasa area

### Romanian Public Schools
- Free
- Romanian language (challenge)
- Mixed quality
- Less common for expats

### Higher Education
- University of Bucharest
- Politehnica
- Academy of Economic Studies
- Programs in English available

---

## Phone & Internet

### Mobile SIM Cards

| Provider | Coverage | Notes |
|----------|----------|-------|
| Orange | Best | Premium pricing |
| Vodafone | Good | Second option |
| Digi (RCS-RDS) | Good | Cheapest |
| Telekom | Okay | Less popular |

### Typical Plans
- Prepaid: €5-10 for 30GB
- Postpaid: €10-20/month unlimited

### Getting a SIM
- Any provider shop
- Need passport
- Takes 10 minutes
- Instant activation

### Home Internet
- Best in Europe (seriously)
- 1 Gbps available cheap
- Digi usually included in rent
- €8-15/month for excellent speeds

---

## Transportation

### Public Transport
- Cheap and extensive
- Metro best for speed
- Buses/trams for coverage
- See transport guide for details

### Car Ownership
- Optional in Bucharest
- Traffic challenging
- Parking issues in center
- Useful for day trips
- See driving guide

### What You Need
- EU license: valid
- Non-EU: usually 6 months, then Romanian license

---

## Daily Life

### Working Hours
- Standard: 9am-6pm
- Shops: 9am-9pm (malls till 10pm)
- Banks: 9am-5pm
- Government: 8:30am-4pm

### Public Holidays (2026)
| Date | Holiday |
|------|---------|
| Jan 1-2 | New Year |
| Jan 24 | Union Day |
| Easter | Variable (Orthodox) |
| May 1 | Labor Day |
| Jun 1 | Children's Day |
| Pentecost | Variable |
| Aug 15 | Assumption |
| Nov 30 | St. Andrew |
| Dec 1 | National Day |
| Dec 25-26 | Christmas |

### Mail & Packages
- **Romanian Post (Poșta Română)**: Slow, unreliable
- **Courier services**: Fan Courier, Urgent Cargus
- **International**: DHL, UPS, FedEx
- **Amazon.de**: Ships to Romania

---

## Integration Tips

### Language
- Learn basics: greetings, numbers, food
- English widely spoken (young people)
- Shows respect, opens doors
- Apps: Duolingo has Romanian

### Making Friends
- Expat groups: Facebook, Meetup, InterNations
- Work colleagues
- Sports/fitness groups
- Language exchanges
- Romanians warm but take time to befriend

### Cultural Adaptation
- Slower pace than Northern Europe
- Relationships matter for business
- Hospitality important
- Be patient with bureaucracy
- Embrace the chaos

---

## Common Challenges

### Bureaucracy
- Frustrating, slow
- Bring all documents
- Patience essential
- Consider paying for help

### Weather Extremes
- Summer: Very hot
- Winter: Very cold
- Prepare for both

### Traffic
- Brutal at rush hours
- Use metro when possible
- Plan around it

### Noise
- Construction everywhere
- Traffic noise
- Choose apartment carefully

### Language Barrier
- Less English outside center
- Government offices challenging
- Translator useful for official matters
