# Bucharest Neighborhoods — Quick Comparison

## At a Glance

| Area | Vibe | Rent (1BR) | Best For | Metro |
|------|------|------------|----------|-------|
| **Old Town (Centru Vechi)** | Party/Tourist | €600-900 | Nightlife, short stays | ✅ Universitate |
| **Universitate** | Central/Mixed | €500-800 | Students, central access | ✅ Universitate |
| **Cotroceni** | Academic/Quiet | €450-650 | Students, families | ✅ Politehnica |
| **Floreasca** | Upscale/Trendy | €700-1,200 | Professionals, foodies | ✅ Stefan cel Mare |
| **Dorobanți** | Wealthy/Quiet | €800-1,500 | Executives, families | 🚶 Walk to metro |
| **Primăverii** | Elite/Residential | €1,000-2,000 | Diplomats, wealthy | 🚶 Walk to metro |
| **Herăstrău** | Park/Upscale | €700-1,100 | Park lovers, runners | ✅ Aviatorilor |
| **Aviatorilor** | Green/Mixed | €600-900 | Families, professionals | ✅ Aviatorilor |
| **Pipera** | Expat/Corporate | €600-900 | Tech workers, families | ✅ Pipera |
| **Băneasa** | Suburban/Mall | €500-800 | Families, airport access | 🚗 Car needed |
| **Titan** | Budget/Local | €350-500 | Budget-conscious, students | ✅ Titan |
| **Berceni** | Budget/Residential | €300-450 | Budget-conscious | ✅ Dimitrie Leonida |
| **Drumul Taberei** | Family/Budget | €350-500 | Families on budget | ✅ Drumul Taberei |
| **Militari** | Budget/Growing | €300-450 | Budget, young couples | ✅ Lujerului |

---

## For Tourists

| If You Want... | Stay In | Why |
|----------------|---------|-----|
| Walking to attractions | Old Town, Universitate | Everything walkable |
| Quiet nights | Floreasca, Dorobanți | Upscale, residential |
| Local experience | Cotroceni, Aviatorilor | Authentic neighborhoods |
| Budget | Titan, Berceni | Low prices, metro access |

## For Expats & Long-term

| Profile | Best Neighborhoods |
|---------|-------------------|
| Young professional | Floreasca, Dorobanți, Aviatorilor |
| Tech worker | Pipera, Floreasca, Băneasa |
| Family (international school) | Pipera, Băneasa, Corbeanca |
| Family (budget) | Drumul Taberei, Militari |
| Student | Cotroceni, Titan, Regie |
| Digital nomad | Floreasca, Old Town (short-term) |
| Luxury | Primăverii, Herăstrău |
| Budget-conscious | Titan, Berceni, Militari |

---

## Neighborhood Groups

### Central (Walkable)
- Old Town
- Universitate  
- Calea Victoriei corridor

### North (Upscale)
- Floreasca
- Dorobanți
- Primăverii
- Herăstrău
- Aviatorilor

### Expat Belt
- Pipera
- Băneasa
- Corbeanca (outside city)
- Otopeni (near airport)

### Student Areas
- Cotroceni
- Regie
- Politehnica area

### Budget / Emerging
- Titan
- Berceni
- Drumul Taberei
- Militari
- Rahova

---

## Metro Line Coverage

| Line | Color | Key Stations |
|------|-------|--------------|
| M1 | Yellow | Pipera, Universitate, Gara de Nord |
| M2 | Blue | Aviatorilor, Universitate, Berceni |
| M3 | Red | Preciziei, Eroilor, Titan |
| M4 | Green | Gara de Nord, Străulești |
| M5 | Orange | Drumul Taberei, Eroilor |

**Best metro access**: Universitate (M1, M2), Eroilor (M1, M3, M5), Pipera (M1)

---

## Price Trends (2026)

| Trend | Areas Affected |
|-------|---------------|
| Rising fast | Floreasca, Pipera, Primăverii |
| Stable | Cotroceni, Aviatorilor |
| Gentrifying | Titan, Drumul Taberei |
| Still cheap | Berceni, Rahova, Militari |

---

## Quick Decision Tree

```
Want to be central?
├── Yes → Party vibe? → Old Town
│        └── Quieter? → Universitate or Cotroceni
│
└── No → Need metro?
         ├── Yes → Budget? → Titan or Drumul Taberei
         │        └── Upscale? → Floreasca or Aviatorilor
         │
         └── No → Expat community? → Pipera or Băneasa
                 └── Local authentic? → Any outer neighborhood
```

See detailed files for each area:
- `neighborhoods-center.md` — Old Town, Universitate, Calea Victoriei
- `neighborhoods-north.md` — Floreasca, Dorobanți, Primăverii, Herăstrău
- `neighborhoods-expat.md` — Pipera, Băneasa, surrounding
- `neighborhoods-emerging.md` — Titan, Berceni, Drumul Taberei, Militari
- `neighborhoods-choosing.md` — How to pick your neighborhood
