# Local Services in Bucharest

## Banking

### Opening an Account

**Requirements**
- Passport or EU ID
- Proof of address (rental contract, utility bill)
- Some banks: proof of income

**Process**
1. Visit branch with documents
2. Fill application
3. Wait 1-7 days for approval
4. Receive card (mail or pickup)

### Major Banks

| Bank | English Support | App Quality | Notes |
|------|-----------------|-------------|-------|
| ING | Excellent | Best | Recommended for expats |
| BCR | Good | Good | Largest network |
| BRD | Good | Good | Société Générale group |
| Raiffeisen | Good | Good | Austrian, solid |
| Banca Transilvania | Limited | Good | Romanian, growing |
| UniCredit | Good | Good | Italian group |

### Digital Banks

| Bank | Use For | Notes |
|------|---------|-------|
| Revolut | Daily use, transfers | EU-based, excellent |
| Wise | International transfers | Best rates |
| N26 | Alternative to local | German, limited support |

### Recommendation
1. **Revolut** for daily spending, international
2. **ING or BCR** for Romanian bills, salary, formal needs

### ATMs
- BCR, BRD, Raiffeisen: No/low fees for their cards
- Generic ATMs: May have fees
- Withdraw from bank's own ATMs

---

## Phone & Mobile

### Providers

| Provider | Coverage | Price | Notes |
|----------|----------|-------|-------|
| Orange | Best | Medium-High | Premium option |
| Vodafone | Very Good | Medium | Good alternative |
| Digi (RCS-RDS) | Good | Lowest | Best value |
| Telekom | Good | Medium | Less popular |

### Getting a SIM

**Requirements**
- Passport or ID
- ~10 minutes

**Where**
- Provider shops (malls, center)
- Authorized retailers
- Some supermarkets

### Typical Plans

| Type | Data | Cost | Notes |
|------|------|------|-------|
| Prepaid | 30GB | €5-10 | Top up as needed |
| Postpaid | Unlimited | €15-25 | Monthly contract |

### Recommendation
- **Short stay**: Digi prepaid, cheapest
- **Long stay**: Orange or Vodafone postpaid

---

## Internet

### Home Internet

Romania has **excellent, cheap internet**:
- 1 Gbps available
- €8-15/month
- Digi dominates market

**Providers**
- **Digi (RCS-RDS)**: Cheapest, usually good
- **Orange**: Fiber, slightly more
- **Vodafone**: Alternative
- **UPC**: Being absorbed by Vodafone

### What to Know
- Often included in rent
- Installation: 1-7 days
- No contract often possible
- Router usually provided

---

## Mail & Shipping

### Domestic

**Romanian Post (Poșta Română)**
- Cheap but slow
- Tracking limited
- OK for documents

**Couriers (Recommended)**
- **Fan Courier**: Most popular
- **Urgent Cargus**: Alternative
- **Sameday**: Fast, modern
- **DPD**: Part of Geopost

### International

**From Romania**
- **DHL, FedEx, UPS**: Reliable, expensive
- **Romanian Post EMS**: Cheaper, slower
- **Packeta/similar**: Budget option to EU

**To Romania**
- Amazon.de ships here
- EU orders: Standard delivery
- Non-EU: Customs possible

### Tips
- Use courier for important items
- Track everything
- Apartment delivery: Be present
- Locker pickup: Growing (easybox)

---

## Healthcare

### Emergency
- **Call**: 112
- **Hospital ERs**: Accept walk-ins
- **Private ERs**: Faster, English

### Regular Care

**Private (Recommended)**
| Network | Type | Notes |
|---------|------|-------|
| MedLife | Clinics + Hospital | Largest, app booking |
| Regina Maria | Clinics + Hospital | Second largest |
| Sanador | Hospital + Clinics | Higher-end |
| Medicover | Clinics | International chain |

**Public**
- Free for insured
- Long waits
- Romanian language
- Quality varies

### Pharmacies

| Chain | Notes |
|-------|-------|
| Catena | Largest, many 24h |
| HelpNet | Good selection |
| Farmacia Tei | Competitive prices |
| Dr. Max | Growing |

**Tips**
- Many medicines OTC (that require prescription elsewhere)
- Pharmacists often knowledgeable
- Some 24/7 locations

### Dental

**Private**: €30-100 for most procedures
**Quality**: Good, many trained abroad
**Recommendation**: Ask expats for referrals

---

## Legal Services

### When Needed
- Rental contracts
- Business setup
- Immigration issues
- Property purchase

### Finding Lawyers
- Expat recommendations
- International firms with local offices
- Google reviews
- Initial consultation: Often free/cheap

### Notary
- Required for many contracts
- Available without appointment
- Fees regulated by law

---

## Home Services

### Cleaning
- Agencies: €50-100/month (weekly)
- Independent: €25-50/session
- Apps: Helping (similar to TaskRabbit)

### Repairs
- **Dedeman** (hardware store): Contractor recommendations
- Ask neighbors/landlord
- Facebook groups for expats

### Laundry
- Self-service laundromats: Limited
- Dry cleaning: Everywhere, cheap (€2-4/shirt)
- Wash & fold services: Growing

---

## Government Services

### Registration (EU Citizens)

**Required** after 3 months
**Where**: Town hall (Primărie) of your district
**Need**: Passport, proof of address, proof of income/insurance
**Result**: Registration certificate

### Romanian ID (CI) for Residents
- Optional for EU citizens
- Required for some services
- Process through Evidence Personale

### Tips
- Bring all documents
- Go early morning
- Patience essential
- Consider paying for help

---

## Driving Services

### License
- EU: Valid indefinitely
- Non-EU: Valid 90 days, then convert
- Conversion: Test may be required

### Vehicle Registration
- Complex process
- Use an agent (~€100-200)
- Required for Romanian plates

### Parking
- Blue zones: Pay by SMS/app
- Apps: ePark, Parking București
- Malls: Usually free

---

## Fitness & Wellness

### Gyms

| Chain | Monthly | Notes |
|-------|---------|-------|
| World Class | €60-100 | Premium, many amenities |
| SmartFit | €30-50 | Good value |
| John Reed | €50-70 | Premium boutique |
| Local gyms | €20-40 | Variable quality |

### Yoga/Pilates
- Many studios, especially in Floreasca
- €10-15/class drop-in
- Monthly packages available

### Swimming
- Hotel pools (day passes available)
- Public pools: Limited
- Therme București: Indoor/outdoor

### Therme București
- Largest thermal spa in Europe
- Entry: €25-45/day
- Multiple zones
- Worth visiting

---

## Pet Services

### Vets
- Many English-speaking available
- Costs reasonable (€30-50 consultations)
- Emergency vets available

### Pet Stores
- Pet shops everywhere
- Zooplus delivers
- Quality food available

### Dog Walking
- Growing service
- €10-15/walk
- Apps: Tailster, local

### Rules
- Dogs must be leashed in public
- Clean up required (fines possible)
- Parks: Some dog-friendly areas

---

## Religious Services

### Orthodox (Majority)
- Churches everywhere
- Services in Romanian
- Beautiful architecture, worth visiting

### Catholic
- Several churches in Bucharest
- Masses in various languages

### Protestant
- Various denominations present
- International churches with English services

### Jewish
- Small community
- Choral Temple (beautiful synagogue)
- Kosher options limited

### Muslim
- Small community
- Mosque in center

### International Churches
- Christ Church Bucharest (Anglican)
- Various international congregations
- English services available

---

## Useful Contacts

### Emergency
- General: 112
- Non-emergency police: 021-9544 (tourist police)

### Utilities
- Enel (electricity): 0800-800-048
- Engie (gas): 0800-800-800
- Apa Nova (water): 021-9696

### Expat Resources
- Facebook: "Expats in Bucharest"
- InterNations: Events and networking
- Meetup: Various groups
