# Healthcare — Bucharest

## System Overview

Romania has universal healthcare for residents, but quality varies. Most expats use a mix of public (for emergencies, specialists) and private (for routine care).

## Public Healthcare (CNAS)

### Who's Covered
- **Romanian citizens**: Automatically
- **EU citizens**: With EHIC card
- **Legal residents**: After registration
- **Employees**: Through salary contributions

### CNAS Registration
1. **Get residence permit** (if non-EU)
2. **Register with local health fund** (Casa de Asigurări)
3. **Choose family doctor** (medic de familie)
4. **Get health card** (cardul de sănătate)

### Costs (with CNAS)
- **Family doctor visits**: Free
- **Specialists**: Free with referral
- **Hospital**: Free
- **Prescriptions**: Subsidized or free
- **Dental**: Partially covered

### Reality Check
- **Wait times**: Can be weeks for non-urgent
- **Infrastructure**: Older hospitals, improving
- **Bribes**: Less common now but still exist in some places
- **Staff**: Well-trained but overworked

## Private Healthcare

### Why Private?
- **No waiting**: Same-day appointments often
- **English speakers**: Staff often speak English
- **Modern facilities**: Western standards
- **Comfort**: Private rooms, better service

### Major Private Networks

| Network | Strengths | Locations |
|---------|-----------|-----------|
| **MedLife** | Comprehensive, largest | Citywide (20+ clinics) |
| **Regina Maria** | Quality, specialists | Multiple centers |
| **Sanador** | Hospital + clinics | Center, North |
| **Medicover** | International standards | North Bucharest |
| **Euroclinic** | Modern hospital | Pipera |

### Typical Costs (Private, without insurance)

| Service | Cost (RON) | Cost (€) |
|---------|-----------|----------|
| GP consultation | 150-250 | 30-50 |
| Specialist visit | 200-400 | 40-80 |
| Blood panel | 200-400 | 40-80 |
| MRI | 800-1,500 | 160-300 |
| CT scan | 600-1,000 | 120-200 |
| ER visit | 300-500 | 60-100 |

## Health Insurance

### Types

| Type | Cost/Month | Coverage |
|------|-----------|----------|
| **CNAS only** | Via taxes | Public system |
| **Private basic** | €30-50 | Clinics, consultations |
| **Private full** | €80-150 | Hospitals, dental, optical |
| **International** | €150-300+ | Worldwide coverage |

### Recommended Providers
- **Groupama**: Good value local plans
- **Allianz**: International coverage
- **Signal Iduna**: Comprehensive options
- **Cigna, Aetna**: For US expats

### Company Coverage
Many employers provide private health insurance — check benefits before buying your own.

## Pharmacies

### Chains
- **Catena**: Largest, everywhere
- **Sensiblu**: Major competitor
- **Dr. Max, Farmacia Tei**: Also widespread
- **24h pharmacies**: Multiple in each sector

### Buying Medication
- **Prescription (rețetă)**: Required for antibiotics, controlled drugs
- **OTC**: Painkillers, cold medicine available freely
- **Prices**: Generally lower than Western Europe
- **Quality**: Same brands as EU, generics available

### Useful OTC
- **Nurofen**: Ibuprofen
- **Paracetamol**: Paracetamol
- **Smecta**: Digestive issues
- **Strepsils**: Sore throat
- **Nurofen Grip**: Cold/flu

## Emergencies

### Emergency Numbers
- **112**: General emergency (police, fire, medical)
- **Ambulance**: Responds to 112, also private options

### Private Ambulances
- **SMURD**: Public, free, helicopters available
- **Private**: Regina Maria, MedLife have private ambulances

### Emergency Rooms
| Hospital | Type | Notes |
|----------|------|-------|
| **Elias** | Public | Good ER |
| **Floreasca (Urgența)** | Public | Main trauma center |
| **Sanador** | Private | Modern ER |
| **Euroclinic** | Private | English-speaking staff |

### ER Triage
In public hospitals:
- **Red**: Life-threatening, immediate
- **Yellow**: Urgent, 1-2 hours
- **Green**: Non-urgent, 4+ hours

## Dental Care

### Private Dental (Recommended)

| Clinic | Specialty | Price Range |
|--------|-----------|-------------|
| **Dr. Leahu** | General, cosmetic | Mid-high |
| **Dental Concept** | Premium | High |
| **DENT ESTET** | Comprehensive | Mid-high |
| **Multiple small clinics** | General | Budget-friendly |

### Typical Costs
| Procedure | Cost (€) |
|-----------|----------|
| Checkup + cleaning | 50-100 |
| Filling | 50-100 |
| Root canal | 150-300 |
| Crown | 200-400 |
| Implant | 500-1,000 |

## Mental Health

### Growing Field
- **Stigma**: Decreasing, especially in younger generation
- **Availability**: More therapists, psychiatrists now

### Finding Help
- **Psychologists**: €40-80/session
- **Psychiatrists**: €80-150/session
- **Apps**: BetterHelp available in English
- **Platforms**: Mindclinic.ro, Hilio.ro (Romanian)

## For Families

### Pediatricians
All major private networks have pediatric departments. Specialists available for all childhood conditions.

### Vaccinations
- **Mandatory schedule**: Similar to EU
- **Private clinics**: Faster appointments
- **Travel vaccines**: Available at MedLife, Regina Maria

### Maternity
- **Public**: Free, quality varies
- **Private**: €3,000-8,000 for delivery
- **Popular private**: Regina Maria, MedLife, Sanador
