# Practical Food Guide — Bucharest

## Grocery Shopping

### Supermarket Chains

| Chain | Level | Notes |
|-------|-------|-------|
| Mega Image | Premium | Most locations, higher prices |
| Carrefour | Mid-range | Hypermarkets + express |
| Kaufland | Budget-Mid | Large stores, good selection |
| Lidl | Budget | German discounter, quality basics |
| Penny | Budget | Romanian basics |
| Auchan | Budget-Mid | Hypermarkets |
| Cora | Mid | Fewer locations |

### What to Know
- **Hours**: Most 7am-10pm, some 24/7
- **Sunday**: Open but shorter hours
- **Cards**: Accepted everywhere
- **Bags**: Bring your own or pay

### Shopping Strategy
- **Daily fresh**: Mega Image express
- **Weekly stock**: Kaufland, Carrefour, Auchan
- **Budget**: Lidl, Penny
- **Quality imports**: Mega Image, specialty shops

### International Products
- **Asian**: Asian supermarkets in center
- **Middle Eastern**: Specialty shops
- **British/American**: Mega Image, some imports
- **Limited selection**: compared to Western Europe

---

## Markets (Piață)

### Obor Market
- **Largest** traditional market
- **When**: Daily, best morning
- **What**: Everything — produce, meat, cheese
- **Vibe**: Authentic, chaotic
- **Metro**: Obor (M1)

### Piața Amzei
- **Central** location
- **When**: Daily
- **What**: Produce, flowers, small goods
- **Vibe**: Urban, quick
- **Near**: Piața Romană

### Other Markets
- **Piața Dorobanți** — North, upscale area
- **Piața Drumul Taberei** — Local, residential
- **Piața Titan** — East Bucharest

### Market Tips
- Cash only (usually)
- Bargaining: mild, on large purchases
- Morning = freshest
- Learn basic Romanian numbers
- Bring bags

---

## Specialty Stores

### Organic/Health
- **Naturalia** — Chain, organic products
- **Bio shops** — Various small stores
- **Mega Image** — Has organic section

### International
- **Asian stores** — Near Unirii
- **Middle Eastern** — Various locations
- **Import shops** — Old Town area

### Meat/Butchers
- **Market butchers** — Freshest
- **Specialty shops** — Quality cuts
- **Supermarket** — Convenient, decent

### Bakeries
- **Paul** — French chain, quality
- **Fornetti** — Romanian chain, fresh
- **Local bakeries** — Varies, often great

---

## Food Delivery

### Main Apps

| App | Coverage | Pros | Cons |
|-----|----------|------|------|
| Glovo | Best | Most restaurants | Higher fees |
| Bolt Food | Good | Cheap promos | Fewer options |
| Tazz | Good | eMAG integration | Interface |
| Takeaway | Okay | International | Less local |

### Tips
- Compare prices across apps
- Peak times: longer waits
- Tip delivery: 5-10 RON
- Check restaurant rating
- Minimum orders: often 30-50 RON

### What Delivers Well
- Pizza, burgers — Good
- Asian — Usually fine
- Traditional Romanian — Hit or miss
- Fine dining — Usually not available

---

## Dietary Restrictions

### Vegetarian

**Dedicated Restaurants**
- Samsara — Vegan, spiritual vibe
- Legume & Co — Vegan comfort
- Raw Vegan — Raw food

**Good Options**
- Most modern restaurants have options
- Italian — Pasta, pizza
- Indian — Many veggie dishes
- Middle Eastern — Hummus, falafel

**Challenges**
- Traditional Romanian = meat-heavy
- Stock often meat-based
- "Vegetarian" may include fish (ask)

**Phrases**
- "Sunt vegetarian/ă" — I'm vegetarian
- "Fără carne" — Without meat
- "Aveți ceva fără carne?" — Do you have anything without meat?

### Vegan

**Dedicated Places**
- Samsara — Best known
- Legume & Co — Comfort vegan
- Raw Vegan — Raw food

**Challenges**
- Eggs and dairy everywhere
- Lard in traditional dishes
- Limited awareness in traditional places

**Phrases**
- "Sunt vegan" — I'm vegan
- "Fără carne, lactate și ouă" — Without meat, dairy, eggs

### Gluten-Free

**Situation**
- Growing awareness
- Not widespread
- Always ask

**Safe Bets**
- Rice dishes
- Meat + vegetables
- Mămăligă (corn-based)

**Challenges**
- Cross-contamination
- Hidden flour in sauces
- Bread obsession in Romania

**Phrases**
- "Fără gluten" — Without gluten
- "Sunt alergic la gluten" — I'm allergic to gluten

### Kosher/Halal

**Kosher**
- Very limited
- Small Jewish community
- Self-catering often necessary
- Some Israeli restaurants

**Halal**
- Kebab shops (often not certified)
- Turkish restaurants (ask)
- Limited certified options

---

## Cooking at Home

### Kitchen Basics
Most furnished apartments include:
- Stove (usually gas)
- Refrigerator
- Basic pots and pans
- Dishes and utensils

### What to Buy
- Knife (if quality matters)
- Spices (bring favorites)
- Good olive oil
- Coffee maker (if not provided)

### Local Ingredients to Try
- **Fresh cheese** — Telemea, brânză
- **Smoked meats** — Various salamis
- **Pickles** — Murături
- **Sour cream** — Smântână
- **Mici mix** — Pre-made at butchers

---

## Water

### Tap Water
- **Officially safe** in Bucharest
- **Taste varies** by area
- **Most locals** drink filtered or bottled
- **Recommendation**: Buy filtered jug or bottles

### Bottled Water
- Cheap and available everywhere
- Local brands: Borsec, Bucovina, Dorna
- Sparkling popular (apă minerală)

---

## Alcohol

### Buying
- Supermarkets: Until 10pm (varies)
- Specialized shops: Various hours
- Age: 18+
- No public drinking restrictions (unlike some countries)

### What to Try
- **Romanian wine** — Excellent value
- **Țuică** — Traditional brandy
- **Local beer** — Ursus, Ciuc
- **Craft beer** — Growing scene

### Where to Buy
- Supermarkets — Good selection
- Wine shops — Better selection
- Direct from wineries — Best prices

---

## Coffee Guide

### Order Types
- **Espresso** — Standard
- **Americano** — Espresso + water
- **Cappuccino** — Standard Italian
- **Flat white** — Specialty cafes
- **Cafea turcească** — Turkish, traditional

### Where
| Type | Places |
|------|--------|
| Specialty | Origo, M60, Steam |
| Chain | Starbucks, Ted's Coffee |
| Traditional | Old cafes, some restaurants |
| Work-friendly | Origo, Qreator, many |

### Price
- Espresso: 8-15 RON
- Specialty drink: 15-25 RON
- Chain: 12-20 RON

---

## Tipping

### Standard Practice
| Service | Tip |
|---------|-----|
| Restaurant | 10% (if not included) |
| Bar | Round up |
| Delivery | 5-10 RON |
| Cafe | Optional, round up |

### How To
- Cash preferred
- Say amount when paying ("Treci la 100")
- Or leave on table

### When Included
- Some upscale restaurants include service
- Check bill ("serviciu")
- If included, extra tip optional

---

## Common Questions

**Is tap water safe?**
Officially yes, but most drink bottled or filtered.

**Are restaurants open Sunday?**
Yes, usually shorter hours.

**Can I pay by card everywhere?**
Most places, but carry some cash.

**Is food expensive?**
Cheap compared to Western Europe. Great value.

**Vegetarian options?**
Growing but limited in traditional places.

**Best food app?**
Glovo has most restaurants.

**Brunch culture?**
Huge. Weekends. Make reservations.
