# Schools & Education — Bucharest

## Overview

Bucharest has options for every educational need, from Romanian public schools to prestigious international institutions.

## For Expat Families

### International Schools

| School | Curriculum | Annual Fee | Ages |
|--------|-----------|------------|------|
| **AISB** (American International School) | American + IB | €18,000-22,000 | 3-18 |
| **BSB** (British School of Bucharest) | British + IB | €15,000-20,000 | 3-18 |
| **ISB** (International School of Bucharest) | IB | €12,000-16,000 | 3-18 |
| **Lycée Français** | French | €6,000-10,000 | 3-18 |
| **German School** | German | €5,000-8,000 | 3-18 |
| **Cambridge School** | British | €8,000-12,000 | 3-18 |

### Waiting Lists
- **AISB, BSB**: 6-12 months common
- **Start early**: Apply 1 year before needed
- **Entry assessments**: Most require interviews/tests

### Locations
Most international schools are in northern Bucharest (Pipera, Băneasa, Voluntari) — factor in commute.

## Romanian Public Schools

### System Structure
| Level | Ages | Years |
|-------|------|-------|
| Grădiniță (Kindergarten) | 3-6 | 3 |
| Școală Primară (Primary) | 6-10 | 4 |
| Gimnaziu (Middle) | 10-14 | 4 |
| Liceu (High School) | 14-18 | 4 |

### Pros
- **Free**: No tuition
- **Language immersion**: Kids learn Romanian fast
- **Local integration**: Build local friendships

### Cons
- **Language barrier**: Initial adjustment hard
- **Class sizes**: 25-30 students typical
- **Facilities**: Vary widely by school
- **After-school**: Limited programs

### Top Public Schools (High School)
- **Colegiul Național "Sfântul Sava"**: Historic, excellent
- **Colegiul Național "Mihai Viteazul"**: Strong sciences
- **Colegiul German "Goethe"**: German-language option
- **Colegiul Național de Informatică "Tudor Vianu"**: Tech-focused

## Private Romanian Schools

Middle ground between public and international:

| School | Focus | Annual Fee |
|--------|-------|------------|
| **Avenor** | Project-based | €6,000-9,000 |
| **Fundația Lumina** | Traditional + modern | €4,000-6,000 |
| **Liceul Teoretic Orizont** | Multiple languages | €4,000-7,000 |

### Benefits
- Smaller classes (15-20)
- More English instruction
- Better facilities
- After-school programs included

## Higher Education

### Universities in Bucharest

| University | Strength | Notes |
|------------|----------|-------|
| **Universitatea București** | Humanities, Sciences | Largest, historic |
| **Politehnica București** | Engineering, Tech | Best for tech |
| **ASE** | Economics, Business | Strong reputation |
| **USAMV** | Medicine, Veterinary | Specialized |
| **UMF Carol Davila** | Medicine | Medical school |

### Tuition (for foreigners)
- **EU citizens**: Same as Romanians (€500-2,000/year)
- **Non-EU**: €2,000-6,000/year
- **Medicine (English)**: €5,000-7,000/year

### Language
- **Romanian programs**: Most options
- **English programs**: Growing, especially in business, IT, medicine

## Preschool & Daycare

### Options

| Type | Age | Monthly Cost |
|------|-----|--------------|
| Public grădiniță | 3-6 | Free (meals extra) |
| Private grădiniță | 2-6 | €200-600 |
| Afterschool | 6-12 | €100-300 |
| Nanny (bonă) | Any | €400-800 |

### Finding Spots
- **Public**: Apply at local city hall (sector)
- **Private**: Contact directly, visit multiple
- **Au pairs**: Available through agencies

## Tutoring & Extracurriculars

### Private Tutoring
- **Individual**: €15-30/hour
- **Group classes**: €8-15/hour
- **Languages**: English, German most popular
- **Exam prep**: Bacalaureat, SAT, IB

### Activities
- **Sports clubs**: Affordable (€50-100/month)
- **Music schools**: €30-80/month
- **Art classes**: €40-100/month
- **Coding for kids**: €80-150/month

## Enrollment Process

### For International Schools
1. **Research**: Visit schools, attend open days
2. **Apply**: Online application + documents
3. **Assessment**: Interview/entrance tests
4. **Decision**: Usually 2-4 weeks
5. **Registration**: Deposit + first term fees

### Documents Needed
- Birth certificate (apostilled)
- Previous school records (translated)
- Vaccination records
- Passport copies
- Proof of address
- Reference letters (sometimes)

### For Romanian Schools
1. **Get translated documents** (authorized translator)
2. **Equivalency** (if coming from abroad): Ministry of Education
3. **Register** at local school during enrollment period (usually March-May)
4. **Medical check**: Required for enrollment
