# Driving & Car Ownership — Bucharest

## Should You Drive?

**Short answer**: Probably not, unless you need to leave the city regularly.

### Metro/Bolt vs Car Comparison

| Factor | Public/Rideshare | Own Car |
|--------|-----------------|---------|
| Daily commute | €1-3 | €5-15 (gas + parking) |
| Rush hour | Metro faster | Stuck in traffic |
| Parking | N/A | Nightmare in center |
| Weekend trips | Rent or Bolt | Convenient |
| Initial cost | €0 | €3,000-15,000 |
| Stress level | Low | High |

## Traffic Reality

### Rush Hours
- **Morning**: 7:00-10:00 AM
- **Evening**: 5:00-8:00 PM
- **Worst areas**: Pipera, Floreasca, any boulevard intersection

### Travel Times (Center to Pipera)
| Time | By Car | By Metro |
|------|--------|----------|
| Off-peak | 20 min | 25 min |
| Rush hour | 60-90 min | 25 min |

## If You Must Drive

### License Requirements
- **EU license**: Valid, no conversion needed
- **Non-EU license**: Valid 90 days, then need Romanian license
- **International Driving Permit**: Recommended for non-EU

### Registration
Cars must be registered (înmatriculare):
1. Buy car (dealer or private)
2. Get fiscal certificate from tax office
3. Register at RAR (vehicle authority)
4. Get plates and registration document
5. Pay annual road tax (rovinieta)

### Insurance
- **RCA (liability)**: Mandatory, €100-300/year
- **CASCO (comprehensive)**: Optional, €300-1,000/year
- **Providers**: Allianz, Groupama, Euroins, Generali

## Buying a Car

### New Cars
- **Dealerships**: All major brands present
- **Rabla program**: Government trade-in bonus (€1,500-3,000)
- **Delivery**: 3-6 months for popular models

### Used Cars
- **Autovit.ro**: Main marketplace
- **OLX**: Also has listings
- **Dealers**: Safer but pricier
- **Private**: Cheaper but riskier

### Price Ranges (Used)
| Category | Price Range |
|----------|-------------|
| Budget reliable | €3,000-5,000 |
| Mid-range | €8,000-15,000 |
| Premium | €20,000+ |

### Red Flags
- **German imports with low km**: Often rolled back
- **Accident history**: Check carVertical or similar
- **Rust**: Especially on older cars
- **No service history**: Walk away

## Parking

### Street Parking
- **Blue zones**: Paid, €2-5/hour via app
- **Apps**: ePark, Ampark — mandatory in paid zones
- **Free**: Limited, mostly residential outskirts
- **Enforcement**: Active, clamps and towing

### Private Parking
- **Malls**: Free 2-3 hours with purchase
- **Office buildings**: Usually included for employees
- **Monthly rental**: €50-150/month in center

## Gas Stations

### Prices (Feb 2026)
- **Petrol (95)**: ~7 RON/L (~€1.40)
- **Diesel**: ~7.5 RON/L (~€1.50)
- **LPG**: ~3.5 RON/L (~€0.70)

### Stations
- **OMV, Mol, Petrom, Rompetrol**: Quality, 24h
- **Supermarket stations**: Cheaper, sometimes queues
- **Payment**: Cards accepted everywhere

## Road Rules

### Speed Limits
| Road Type | Limit |
|-----------|-------|
| Urban | 50 km/h |
| National roads | 90 km/h |
| Express roads | 100 km/h |
| Highways | 130 km/h |

### Enforcement
- **Speed cameras**: Common, especially highways
- **Police stops**: Random checks for documents
- **Alcohol limit**: 0.0% (zero tolerance)
- **Phone use**: Banned, hands-free only

### Fines
| Offense | Fine (RON) |
|---------|-----------|
| Speeding 10-20 km/h | 600-870 |
| Speeding 20-50 km/h | 870-1,300 |
| Phone use | 600-1,450 |
| No seatbelt | 600-1,300 |
| Running red light | 1,300-2,900 |

## Toll Roads

### Rovinieta
Required for all roads:
- **7 days**: €3
- **30 days**: €7
- **1 year**: €28
- **Purchase**: Gas stations, online (roviniete.ro)

### Highway Tolls
New electronic toll (e-Toll) on A1, A2:
- **Per km pricing**: ~€0.05-0.10/km
- **Registration**: Required, via app or portal

## Winter Driving

### Legal Requirements (Dec 1 - Mar 31)
- **Winter tires**: Mandatory if snow/ice
- **Chains**: Recommended to carry
- **Fine for no winter tires**: 2,000-3,000 RON

### Practical Tips
- **Salt damage**: Wash car regularly in winter
- **Battery**: Cold kills batteries, check before winter
- **Wipers**: Change to winter wipers
- **Washer fluid**: Use -20°C rated

## Alternatives to Owning

### Car Sharing
- **Spark**: Electric cars, app-based
- **CityLink**: Station-based rental
- **Pricing**: ~€0.30/min or €30-50/day

### Rental
- **Major chains**: Hertz, Avis, Europcar, Sixt
- **Local**: Autonom, EuropCar Romania
- **Weekend rates**: €30-60/day

### Ride-hailing (Preferred)
- **Bolt**: Cheapest, most used
- **Uber**: Also available
- **Pricing**: €3-5 most trips within city
