# Culture & Customs — Bucharest

## Romanian Identity

Romanians are proud of their Latin heritage in a Slavic-surrounded region. The language, derived from Latin, sets them apart from neighbors.

### Key Cultural Traits
- **Hospitality**: Guests are treated generously, often offered food/drinks
- **Directness**: Communication is more direct than Western Europe
- **Humor**: Self-deprecating, often dark humor about politics/history
- **Family-oriented**: Strong family ties, grandparents often involved in childcare
- **Orthodox traditions**: Religious holidays widely observed

## Social Etiquette

### Greetings
- **Formal**: Handshake, "Bună ziua" (good day)
- **Friends**: Cheek kisses (both sides), starting with left
- **First meeting**: Use "Domnul/Doamna" (Mr./Mrs.) until invited to use first names

### Gift Giving
- **Flowers**: Odd numbers only (even for funerals)
- **Visiting homes**: Bring wine, chocolates, or flowers
- **Avoid**: Chrysanthemums (funeral flowers)

### Dining Etiquette
- **Toasting**: "Noroc!" (luck) or "Să fie!" (let it be)
- **Eat everything**: Finishing your plate is polite
- **Pace yourself**: Meals can last hours with multiple courses
- **Țuică**: Homemade plum brandy, refusing may offend

## Religion

Orthodox Christianity dominates:
- **85%+** Orthodox Christian
- **Churches**: Everywhere, often beautiful architecture
- **Sunday**: Church attendance common, especially older generation
- **Holidays**: Christmas, Easter are major (Easter often different date than Western)
- **Dress code**: Cover shoulders/knees when visiting churches

## Holidays & Festivals

| Date | Holiday | Notes |
|------|---------|-------|
| Jan 1-2 | New Year | Fireworks, parties |
| Jan 24 | Union Day | National day |
| Apr/May | Orthodox Easter | Date varies, huge celebration |
| May 1 | Labor Day | Long weekend |
| Jun 1 | Children's Day | Parks packed, events |
| Dec 1 | National Day | Parades, fireworks |
| Dec 25-26 | Christmas | Family gatherings |

## Language Tips

### Essential Romanian
| English | Romanian | Pronunciation |
|---------|----------|---------------|
| Hello | Bună | BOO-nah |
| Thank you | Mulțumesc | mool-tzoo-MESK |
| Please | Vă rog | vah ROG |
| Yes/No | Da/Nu | da/noo |
| Sorry | Scuze | SKOO-zeh |
| How much? | Cât costă? | kuht KOS-tah |
| The bill | Nota | NO-tah |
| Cheers! | Noroc! | no-ROK |

### English Proficiency
- **Young people (under 40)**: Very good, often fluent
- **Older generation**: Limited, especially outside center
- **Service industry**: Usually decent English
- **Government offices**: Often Romanian only

## Music & Entertainment

### Traditional
- **Folk music**: Still performed, especially at events
- **Manele**: Polarizing pop-folk genre, love it or hate it
- **Classical**: George Enescu is national icon, annual festival

### Modern Scene
- **Clubbing**: Bucharest has excellent nightlife
- **Festivals**: Untold, Electric Castle (outside Bucharest but famous)
- **Theaters**: National Theater, Opera House — affordable tickets

## Superstitions

Romanians can be superstitious:
- **Draft (curent)**: Feared, avoid open windows simultaneously
- **Sitting at table corners**: Single forever (supposedly)
- **Black cat**: Bad luck
- **Spilled salt**: Throw over shoulder
- **Friday 13th**: Less feared than Tuesday 13th

## Generational Differences

- **Pre-1989 generation**: Lived through communism, more conservative
- **Transition generation (40-50s)**: Adapted, often nostalgic
- **Post-revolution (30-40s)**: Westernized, entrepreneurs
- **Young adults**: Very Western-oriented, globally connected

## Business Culture

- **Relationships matter**: Build trust before business
- **Hierarchy**: Respect titles and seniority
- **Meetings**: May start late, but be on time yourself
- **Decisions**: Often made at the top
- **Gift giving**: Small gifts appreciated but not expected
