# Weather & Climate in Bucharest

## Climate Overview

Bucharest has a **humid continental climate**: hot summers, cold winters, with pleasant spring and autumn. More extreme than Western Europe.

### Quick Reference

| Season | Months | Temp Range | What to Expect |
|--------|--------|------------|----------------|
| Spring | Mar-May | 8-22°C | Warming, unpredictable |
| Summer | Jun-Aug | 20-35°C | Hot, occasional heatwaves |
| Autumn | Sep-Nov | 8-22°C | Pleasant, cooling |
| Winter | Dec-Feb | -5 to 5°C | Cold, snow possible |

---

## Month-by-Month

### January
- **Avg temp**: -3 to 3°C
- **Weather**: Cold, possible snow
- **Days**: Short (8 hours daylight)
- **What to wear**: Heavy coat, layers, boots
- **Tips**: Indoor activities, heating works well

### February
- **Avg temp**: -2 to 5°C
- **Weather**: Still cold, less snow
- **Days**: Lengthening
- **What to wear**: Same as January
- **Tips**: Coldest month some years

### March
- **Avg temp**: 2-12°C
- **Weather**: Warming, variable
- **Days**: Noticeably longer
- **What to wear**: Layers, light jacket
- **Tips**: Can still get cold snaps

### April
- **Avg temp**: 8-18°C
- **Weather**: Spring arriving, rain possible
- **Days**: Pleasant
- **What to wear**: Light layers, rain jacket
- **Tips**: Great for walking, parks blooming

### May
- **Avg temp**: 13-24°C
- **Weather**: Warm, pleasant
- **Days**: Long, sunny
- **What to wear**: Light clothes, evening layer
- **Tips**: Best month to visit

### June
- **Avg temp**: 17-28°C
- **Weather**: Warm to hot
- **Days**: Longest days
- **What to wear**: Summer clothes
- **Tips**: Terrace season begins

### July
- **Avg temp**: 19-32°C
- **Weather**: Hot, possible heatwaves
- **Days**: Peak summer
- **What to wear**: Light, breathable
- **Tips**: AC essential, stay hydrated

### August
- **Avg temp**: 18-32°C
- **Weather**: Similar to July, sometimes hotter
- **Days**: Hot
- **What to wear**: Light clothes
- **Tips**: Many locals on vacation, quieter city

### September
- **Avg temp**: 14-26°C
- **Weather**: Cooling, still warm
- **Days**: Shortening
- **What to wear**: Light with evening layer
- **Tips**: Excellent month to visit

### October
- **Avg temp**: 9-18°C
- **Weather**: Autumn colors, cooling
- **Days**: Shorter
- **What to wear**: Layers, jacket
- **Tips**: Beautiful parks

### November
- **Avg temp**: 4-10°C
- **Weather**: Cold, gray, rain
- **Days**: Short
- **What to wear**: Warm layers
- **Tips**: Prepare for winter

### December
- **Avg temp**: -1 to 4°C
- **Weather**: Cold, possible snow
- **Days**: Shortest (8 hours)
- **What to wear**: Winter gear
- **Tips**: Christmas markets, festive

---

## Weather Extremes

### Summer Heatwaves
- 40°C+ possible
- Usually July-August
- Multi-day events
- AC essential
- Elderly at risk

**Survival Tips**:
- Stay indoors 12-5pm
- Drink water constantly
- Malls/museums for AC
- Light, loose clothing
- Avoid alcohol in heat

### Winter Cold Snaps
- -15°C or colder possible
- Usually January-February
- Can last weeks
- Heating works well
- Pipes can freeze in old buildings

**Survival Tips**:
- Layer clothing (base, mid, outer)
- Warm boots essential
- Hat, gloves, scarf
- Keep moving outdoors
- Hot drinks help

### Storms
- Thunderstorms: Summer
- Can be intense
- Usually brief
- Flash flooding possible
- Stay indoors during electrical storms

---

## Seasonal Living

### Summer Strategy
- **Morning**: Best outdoor time (7-10am)
- **Midday**: Indoors, work, rest
- **Evening**: Outdoor dining, activities (after 6pm)
- **Night**: Still warm, nightlife thrives

### Winter Strategy
- **Morning**: Cold, dress warm
- **Day**: Get outdoor time while light
- **Evening**: Indoors, restaurants
- **Weekend**: Museums, malls, thermal baths

---

## What to Pack

### Summer Visit
- Light, breathable clothes
- Sunglasses
- Sunscreen
- Hat
- Light cardigan (AC can be cold)
- Comfortable walking shoes
- Umbrella (summer storms)

### Winter Visit
- Heavy winter coat
- Layers (thermal underwear helpful)
- Warm boots (waterproof)
- Hat, scarf, gloves
- Indoor lighter clothes

### Year-Round Essentials
- Comfortable walking shoes
- Rain jacket or umbrella
- Layers (temperature varies day to night)
- Phone charger

---

## Climate vs Western Europe

| Factor | Bucharest | Barcelona | London |
|--------|-----------|-----------|--------|
| Summer max | 35°C+ | 28-30°C | 22-25°C |
| Winter min | -10°C | 5-8°C | 2-4°C |
| Temperature range | 45°C | 25°C | 20°C |
| Snow | Yes | Rare | Rare |
| AC needed | Yes | Maybe | No |
| Heating needed | Yes | Maybe | Yes |

### Key Differences
- **More extreme** than Western Europe
- **Real winter** with snow
- **Hot summers** not coastal moderate
- **Less rain** than UK
- **More sunshine** than northern Europe

---

## Indoor Activities by Season

### Summer (Escaping Heat)
- Malls (AFI, Băneasa, Mega)
- Museums (National Art, Village Museum indoor sections)
- Therme București (cooled areas)
- Cinemas
- Coworking spaces (AC)

### Winter (Escaping Cold)
- Same malls
- Therme București (thermal pools)
- Coffee shops
- Museums
- Restaurants (extended meals)

---

## Parks & Outdoor

### Best Seasons
- **May**: Perfect weather, blooming
- **September-October**: Warm, fall colors
- **June, early July**: Before extreme heat

### Summer Parks
- Early morning (6-9am)
- Evening (7-9pm)
- Bring water
- Seek shade

### Winter Parks
- Midday warmest
- Shorter visits
- Dress warm
- Good for walks (not sitting)

---

## Weather Apps

Recommended apps for Bucharest weather:
- **Weather.com**
- **AccuWeather**
- **Yr.no** (accurate)
- **Local**: Various Romanian TV weather apps

---

## Heating & Cooling

### Residential Heating

**Central Heating (Old Buildings)**
- City-controlled
- On roughly Oct 15 - Apr 15
- No individual control
- Can be too hot or not enough
- Included in fees usually

**Individual Heating (Modern Buildings)**
- Your thermostat
- Gas-powered usually
- Costs more, better control
- Year-round availability

### Air Conditioning

**New Buildings**
- Usually installed
- Check before renting

**Old Buildings**
- Often none
- Can install portable unit
- Ask landlord permission

**Summer without AC**
- Fan + wet towels
- Malls/museums for relief
- Consider it a dealbreaker in summer

---

## Seasonal Events

### Spring
- Easter celebrations (Orthodox)
- Parks reopening
- Terrace season starting

### Summer
- Outdoor festivals
- Cinema in the park
- Extended daylight activities

### Autumn
- Wine harvest festivals
- Bucharest Jazz Festival
- Pleasant walking weather

### Winter
- Christmas Market (December)
- New Year's celebrations
- Occasional snow days

---

## Climate Change Notes

Recent trends:
- Summers getting hotter
- More frequent heatwaves
- Winter less consistently cold
- More variable precipitation
- Urban heat island effect in center
