# Business Setup in Bucharest

## Overview

Romania offers straightforward business setup, EU market access, and competitive costs. Good for:
- Tech startups
- Consulting/services
- E-commerce
- Digital businesses
- Eastern European expansion

---

## Business Structure Options

### SRL (Societate cu Răspundere Limitată)
**Romanian LLC — Most Common**

| Aspect | Details |
|--------|---------|
| Min capital | 200 RON (~€40) |
| Liability | Limited to capital |
| Shareholders | 1-50 |
| Director | Required, can be shareholder |
| Taxes | 1% turnover OR 16% profit |
| Use case | Most businesses |

### PFA (Persoană Fizică Autorizată)
**Sole Trader / Freelancer**

| Aspect | Details |
|--------|---------|
| Capital | None required |
| Liability | Personal (unlimited) |
| Setup | Simpler |
| Taxes | 10% income + social |
| Use case | Freelancers, consultants |

### SA (Societate pe Acțiuni)
**Joint Stock Company**

| Aspect | Details |
|--------|---------|
| Min capital | 90,000 RON (~€18,000) |
| Use case | Large companies, public trading |
| Complexity | High |

---

## Setting Up an SRL

### Requirements
1. Company name (check availability)
2. Registered address
3. Share capital (min 200 RON)
4. Articles of association
5. Shareholders' agreement
6. ID documents
7. Proof of address

### Process

| Step | Time | Notes |
|------|------|-------|
| 1. Name reservation | 1 day | Trade Registry |
| 2. Draft documents | 1-2 days | Lawyer/accountant |
| 3. Notarize | 1 day | Notary public |
| 4. Register | 3-5 days | Trade Registry (ONRC) |
| 5. Tax registration | 1-2 days | ANAF |
| 6. Bank account | 1-5 days | Any bank |
| **Total** | **1-2 weeks** | With professional help |

### Costs

| Item | Cost (EUR) |
|------|------------|
| Name reservation | €5-10 |
| Notary fees | €50-150 |
| Registration fees | €50-100 |
| Legal help (optional) | €300-1,000 |
| Accountant (monthly) | €100-300 |
| Registered address (if needed) | €50-150/month |

### DIY vs Professional
- **DIY**: Possible but time-consuming, Romanian needed
- **Professional**: €500-1,500 total, handles everything
- **Recommendation**: Use professional for first company

---

## Taxation

### Corporate Tax Options

**Option 1: Micro Company (1% Turnover)**
- Revenue under €500,000
- At least 1 employee
- Very attractive for small businesses
- No profit calculation needed

**Option 2: Profit Tax (16%)**
- Standard corporate tax
- Required above thresholds
- Deductions available

### Employee Costs

| Component | Rate | Notes |
|-----------|------|-------|
| Gross salary | 100% | What you budget |
| Income tax | 10% | Paid by employee |
| Social security (CAS) | 25% | Paid by employee |
| Health (CASS) | 10% | Paid by employee |
| **Net to employee** | ~55% | Of gross |
| Work insurance | 2.25% | Paid by employer |
| **Total employer cost** | ~102.25% | Of gross |

### Example

| Item | Amount (EUR) |
|------|--------------|
| Gross salary | €3,000 |
| Employee taxes | -€1,050 |
| Net salary | €1,950 |
| Employer cost | €3,068 |

### VAT
- Standard: 19%
- Reduced: 9% (food, hospitality), 5% (books, some services)
- Registration: Required above €88,500 revenue
- EU reverse charge: Applies for B2B

### Dividend Tax
- 8% flat rate
- Paid when distributing profits

---

## Accounting & Compliance

### Requirements
- Monthly tax declarations
- Quarterly VAT (if registered)
- Annual financial statements
- Audit (if thresholds met)

### Accountant Costs

| Business Size | Monthly |
|---------------|---------|
| Solo/micro | €100-150 |
| Small (1-5 employees) | €150-300 |
| Medium | €300-600 |
| Complex | €600+ |

### Software
- Many Romanian accounting packages
- Some integrate with banks
- Accountant usually provides

---

## Banking for Business

### Major Banks

| Bank | English | Online | Notes |
|------|---------|--------|-------|
| ING | Good | Excellent | Modern, recommended |
| BCR | Good | Good | Largest |
| BRD | Good | Good | Established |
| Raiffeisen | Good | Good | Solid |
| Banca Transilvania | Limited | Good | Growing |

### Opening Process
1. Book appointment
2. Bring: Company documents, ID, proof of address
3. Wait 1-5 days
4. Receive cards and access

### Costs
- Account maintenance: €0-30/month
- Transfers: €0-2 local, €5-20 international
- Cards: Usually free

### Recommendations
- **Revolut Business**: For international
- **ING**: For local operations
- **Both**: Optimal setup

---

## Office Space

### Options

| Type | Cost/Month | Notes |
|------|------------|-------|
| Virtual office | €50-150 | Address only |
| Coworking desk | €100-250 | Flexible |
| Private office (cowork) | €300-600 | Small team |
| Traditional office | €15-25/sqm | Long lease |

### Locations
- **Pipera**: Tech, modern, parking
- **Floreasca**: Trendy, expensive
- **Center**: Prestigious, older buildings
- **Emerging areas**: Cheaper, improving

### Tips
- Start with coworking
- Scale as needed
- Consider remote-first

---

## Hiring

### Employment Types
- **Full-time**: Standard, most protections
- **Part-time**: Allowed, proportional benefits
- **Contractor**: Through their PFA/SRL
- **Remote**: Legal, international possible

### Hiring Process
1. Job posting
2. Interviews
3. Offer letter
4. Employment contract
5. Registration with authorities
6. Medical examination (day 1)

### Employment Contracts
- Written required
- Romanian language
- Minimum 21 vacation days
- Notice period: 20-45 days typical

### HR Outsourcing
- Available for small companies
- €50-100/employee/month
- Handles payroll, compliance

---

## Legal Considerations

### Intellectual Property
- Romanian Patent Office (OSIM)
- EU trademarks through EUIPO
- Copyright automatic
- Software patents: Limited

### Contracts
- Romanian law applies (usually)
- English contracts: Valid but Romanian for courts
- Notarization: Sometimes required
- Get legal review for important contracts

### GDPR
- Full EU GDPR applies
- Data protection officer: Sometimes required
- Privacy policies: Required
- Fines: Can be significant

---

## Support Services

### Finding Help

| Service | Where to Find |
|---------|---------------|
| Lawyers | Recommendations, directories |
| Accountants | Recommendations, online |
| HR/Payroll | Specialized firms |
| IT Support | Freelancers, agencies |

### Business Associations
- AmCham Romania (American Chamber)
- Romanian Business Leaders
- Various industry associations

---

## Starting Costs Estimate

### Minimal (Solo Consultant)
| Item | Cost |
|------|------|
| Company setup | €500-800 |
| First year accounting | €1,200-1,800 |
| Virtual office | €600-1,200/year |
| Bank account | €0-200/year |
| **Total** | **€2,300-4,000** |

### Small Team (5 people)
| Item | Monthly |
|------|---------|
| Salaries (gross) | €15,000 |
| Office (cowork) | €500-1,000 |
| Accounting | €200-400 |
| Software/tools | €200-500 |
| Other | €500-1,000 |
| **Total** | **€16,400-17,900** |

---

## Timeline: From Idea to Operating

| Week | Activities |
|------|------------|
| 1 | Decision, name research, engage lawyer/accountant |
| 2 | Company registration, bank account |
| 3 | Office setup, initial hiring |
| 4 | Operations begin |

### Fast Track
With good preparation and professional help, can be operational in 1-2 weeks.

---

## Common Mistakes

1. **Underestimating bureaucracy** — Allow extra time
2. **DIY without Romanian** — Use professionals
3. **Ignoring accounting** — Set up from day 1
4. **Wrong structure** — Get advice first
5. **Not planning cash flow** — Tax timing matters
6. **Verbal agreements** — Get contracts signed
7. **Hiring too fast** — Hard to fire in Romania
