"""
bt-common 公共模块
提供宝塔API客户端、配置管理和工具函数
"""

from .api_endpoints import (
    API_ENDPOINTS,
    API_GROUPS,
    API_DESCRIPTIONS,
    PROJECT_TYPES,
    MIN_PANEL_VERSION,
    SOFTWARE_SERVICES,
    PHP_VERSIONS,
    SERVICE_LOG_PATHS,
    SPECIAL_SERVICE_APIS,
    get_endpoint,
    get_endpoints_by_group,
    list_endpoints,
    get_endpoint_description,
)
from .bt_client import (
    BtClient,
    BtClientManager,
    sign_request,
)
from .config import (
    Config,
    ServerConfig,
    ThresholdConfig,
    GlobalConfig,
    MIN_PANEL_VERSION as CONFIG_MIN_PANEL_VERSION,
    GLOBAL_CONFIG_FILE,
    load_config,
    load_config_object,
    get_servers,
    get_thresholds,
    find_config_file,
    get_global_config_path,
    create_default_global_config,
    add_server,
    remove_server,
    update_thresholds,
    get_config_info,
    normalize_host,
    validate_host,
)
from .utils import (
    Alert,
    format_bytes,
    format_uptime,
    format_timestamp,
    parse_system_monitor_data,
    check_thresholds,
    check_ssl_status,
    parse_php_site,
    parse_project_site,
    parse_proxy_site,
    parse_html_site,
    parse_all_sites,
    format_security_report,
    format_service_status,
    print_table,
    output_result,
    generate_summary_report,
)

__all__ = [
    # API端点
    "API_ENDPOINTS",
    "API_GROUPS",
    "API_DESCRIPTIONS",
    "PROJECT_TYPES",
    "MIN_PANEL_VERSION",
    "SOFTWARE_SERVICES",
    "PHP_VERSIONS",
    "SERVICE_LOG_PATHS",
    "SPECIAL_SERVICE_APIS",
    "get_endpoint",
    "get_endpoints_by_group",
    "list_endpoints",
    "get_endpoint_description",
    # 客户端
    "BtClient",
    "BtClientManager",
    "sign_request",
    # 配置
    "Config",
    "ServerConfig",
    "ThresholdConfig",
    "GlobalConfig",
    "CONFIG_MIN_PANEL_VERSION",
    "GLOBAL_CONFIG_FILE",
    "load_config",
    "load_config_object",
    "get_servers",
    "get_thresholds",
    "find_config_file",
    "get_global_config_path",
    "create_default_global_config",
    "add_server",
    "remove_server",
    "update_thresholds",
    "get_config_info",
    "normalize_host",
    "validate_host",
    # 工具
    "Alert",
    "format_bytes",
    "format_uptime",
    "format_timestamp",
    "parse_system_monitor_data",
    "check_thresholds",
    "check_ssl_status",
    "parse_php_site",
    "parse_project_site",
    "parse_proxy_site",
    "parse_html_site",
    "parse_all_sites",
    "format_security_report",
    "format_service_status",
    "print_table",
    "output_result",
    "generate_summary_report",
]
