---
name: testimonial-collector
description: Systematically gather and format client testimonials. Use when someone needs social proof, wants to collect feedback, or needs to turn happy clients into public advocates.
---

# Testimonial Collector

Here's the reality: your happiest clients will vouch for you. They want to help.

But they're busy. And you feel weird asking. So you don't.

Meanwhile, you're in sales calls with no social proof, trying to convince people you're good at what you do.

This skill fixes the asking part. I'll give you exactly what to say, when to say it, and how to format what you get back.

---

## When to Ask

Timing is everything. These are your windows:

✅ **Right after a win.** They just saw results? Ask now.
✅ **When they thank you unprompted.** That's your cue.
✅ **At project completion.** Natural checkpoint.
✅ **When they renew or extend.** They're voting with their wallet.

The moment of peak happiness is the moment to ask. Don't wait.

---

## How to Ask (Without Being Weird)

### The Direct Ask

Subject: Quick favor (30 seconds)

```
Hey [Name],

Loved working on [project] with you — especially seeing [specific result you noticed].

Would you be open to sharing a quick testimonial I could use on my site?

No pressure. If yes, I can either:
A) Send you 3 questions to answer
B) Write a draft for you to approve/edit

Whatever's easier.

Thanks either way.
```

Short. Gives them options. Doesn't make it a big deal.

---

### The Question Route

If they say "sure, what do you need?" — send this:

```
Awesome. Just 3 quick questions:

1. What was the situation before we worked together?
2. What changed or improved?
3. Would you recommend this to others? Why?

A few sentences each is perfect. I'll format it.
```

That's it. Don't overthink it.

---

### The Draft Route

Some people hate writing. Make it easy:

```
I drafted something based on our work together:

"[Your draft in their voice — keep it short and specific]"

Feel free to edit, tweak, or rewrite entirely. Whatever feels right to you.
```

Most people will approve with minor edits. You did the hard part.

---

## The Deep Dive (For Case Studies)

When you need more than a quote:

1. What was the situation before we started?
2. What almost stopped you from moving forward?
3. What was it like working together?
4. What changed as a result?
5. What would you tell someone considering this?

These five questions give you enough for a full case study.

---

## How to Format What You Get

### Short Format (Social/Website)

```
"[One punchy sentence about the result]"
— [Name], [Title] at [Company]
```

**Example:**
> "Brian helped us go from zero LinkedIn presence to 3 inbound leads per week in 6 weeks."
> — Sarah Chen, CEO at TechCo

This goes on your homepage, your proposals, your LinkedIn featured section.

---

### Medium Format (Proposals/About Page)

```
"[2-3 sentences: problem, experience, result]"
— [Name], [Title] at [Company]
```

**Example:**
> "We knew we needed to build our founder brand but had no idea where to start. Brian built us a complete content system in 6 weeks — now we're generating inbound leads for the first time. Can't recommend him enough."
> — Sarah Chen, CEO at TechCo

This goes in proposals, on your services page, in case studies.

---

### Long Format (Case Study Pages)

```
**What [Name] at [Company] Said:**

"[Full quote with context — the whole story]"
```

This goes on dedicated case study pages or in downloadable PDFs.

---

## Editing Rules (Stay Ethical)

**You can:**
- Fix grammar and typos
- Tighten for clarity
- Reorder sentences
- Cut filler

**You can't:**
- Add claims they didn't make
- Exaggerate results
- Change the meaning

**Always send edits back for approval.** Takes 30 seconds and keeps you honest.

---

## The Quality Checklist

Strong testimonials have:

- [ ] **Specific result** — Numbers or concrete outcomes
- [ ] **Before/after** — What changed
- [ ] **Credibility markers** — Name, title, company
- [ ] **Relevance** — Similar to your ideal client

**Weak:** "Great to work with!"
**Strong:** "Went from 0 to 3 inbound leads per week in 6 weeks."

Specificity is what makes people believe it.

---

## Where to Use Testimonials

| Location | Format | Purpose |
|----------|--------|---------|
| Homepage | Short | Trust at first glance |
| Sales pages | Medium | Overcome objections |
| Proposals | Medium | Relevant proof |
| LinkedIn | Short | Credibility |
| Case studies | Long | Deep proof |

---

## Following Up (If They Don't Respond)

Wait 5-7 days. Send one follow-up:

```
Hey [Name], just bumping this — no pressure at all. If timing's bad, totally get it. Let me know either way!
```

If they don't respond to that, let it go. Some people just won't, and that's fine.

---

## Build a Library

Create a simple doc or spreadsheet:

| Client | Date | Quote | Format | Permission | Used Where |
|--------|------|-------|--------|------------|------------|

Review it quarterly:
- Who haven't you asked?
- Which testimonials are getting stale?
- Any gaps in industries or use cases?

---

**Need help building your social proof library?**
→ [Book a strategy call](https://brianrwagner.com)

---

*Skill by Brian Wagner | AI Marketing Architect | brianrwagner.com*
