# Example Issue: Sales Tech (Series A, Founder-Led)

## Subject Line Options
1. `Your discovery calls are too long. Here is the 22-minute structure that converts.`
2. `We reviewed 140 demo recordings. This 1 change improved next-step rate.`
3. `Most SDR handoffs fail before the meeting. Fix the transition script.`

## Final Subject Line
`We reviewed 140 demo recordings. This 1 change improved next-step rate.`

## Newsletter Draft

Last quarter, our team reviewed 140 product demos across mid-market SaaS teams. The pattern was consistent: reps that won next steps did not present more features. They spent less time in product walkthrough and more time forcing agreement on one business pain before the first click.

Most demos fail because discovery and demonstration are treated as separate steps. They are not. High-performing reps use the first five minutes of the demo to confirm problem priority, then show only the workflow tied to that problem.

### The Pattern We Saw
- Demos with a clear pain confirmation had a 34% higher next-step rate.
- Demos that opened with a full platform tour had the lowest engagement by minute 12.
- Reps who used one quantified problem statement before screen-share moved deals faster.

The takeaway is simple: prospects do not buy product breadth in the first demo. They buy confidence that one painful process can be fixed quickly.

### The 3-Step Demo Transition Playbook
1. Pre-demo alignment
- Before the call, write one hypothesis: `The primary problem is [X] costing [Y].`
- Ask the AE to validate this in the opening 3 minutes.

2. Pain lock before product
- Use this line before any screens: `If we could cut [problem] by [target], would this become priority this quarter?`
- Wait for explicit confirmation. If you do not get it, continue discovery instead of demoing.

3. Show one workflow, not the platform
- Choose one workflow connected to the confirmed pain.
- Narrate outcome, not features: `This step removes manual reconciliation and saves ~4 hours/week.`
- End with implementation clarity: owner, timeline, first KPI.

### Mini Case
One 12-person sales team selling into IT services had stalled pipeline despite healthy top-of-funnel. Their demos averaged 44 minutes with low next-step conversion. They switched to a single-workflow demo structure and added the pain-lock question before screen-share. Within 5 weeks, demo-to-next-step rose from 31% to 43%.

### CTA
Reply with `DEMO STRUCTURE` and I will send the one-page checklist we use before every first demo.

## Send Plan
- Send time: Tuesday, 9:00 AM EST
- Amplification:
  - LinkedIn post summarizing the 3-step playbook
  - 8-post thread with the pain-lock script and metrics

## KPI Targets
- Open rate: 38%+
- CTR/reply intent: 6%+
- Qualified demo checklist requests: 20+
