# Newsletter Creation & Curation

Most B2B newsletters fail because they ignore industry context.

This skill is built for teams that need newsletters tailored to **industry + company stage + role + geography**, not generic writing prompts.

## Positioning

**The only newsletter framework that adapts to your industry, stage, and role.**

It helps agents and operators produce newsletters that are:
- Strategically aligned to GTM goals
- Executable with real workflows and approvals
- Consistent issue after issue

## What You Get

- `SKILL.md`: concise execution guide with decision tree + workflow
- `PLAYBOOK.md`: full strategic library (all detailed guidance preserved)
- `templates/`: industry-specific newsletter structures
- `examples/`: realistic finished issue samples

## Why Teams Use It

- Avoids one-size-fits-all newsletter advice
- Bakes in role-based approval logic (especially critical for fintech/enterprise)
- Converts strategy into repeatable publishing operations

## Time Savings

Typical manual process for one issue:
- 2-3 hours strategy and structure decisions
- 2-4 hours drafting and revisions

With this framework:
- 20-40 minutes to choose strategy path and template
- 60-120 minutes to produce a high-quality draft
- 30-45% less iteration time from clearer structure and constraints

## Quick Start

1. Open `SKILL.md` and answer the 5 decision-tree questions.
2. Pick your template from `templates/`.
3. Generate draft using the 4-step workflow.
4. Validate with role/compliance checks.
5. Use `PLAYBOOK.md` when you need deeper strategic guidance.

## Social Proof

- Created by Shashwat Ghosh (Fractional CMO, Helix GTM Consulting)
- Built from practical B2B SaaS newsletter frameworks across Sales Tech, HR Tech, Fintech, and Operations Tech
- Includes realistic examples with KPI targets for pipeline and thought-leadership outcomes

## Example Files

- `examples/example-sales-tech-issue.md`
- `examples/example-hr-tech-issue.md`

## Industry Coverage

- Sales Tech
- HR Tech
- Fintech
- Operations Tech

## Links

- ClawdHub: https://clawdhub.com/shashwatgtm/newsletter-creation-curation
- LinkedIn: https://linkedin.com/in/shashwatghosh-ai-b2b-gtm-fractionalcmo
- GitHub: https://github.com/shashwatgtm
