---
name: linkedin-authority-builder
description: Build a LinkedIn content system for thought leadership. Use when someone needs to establish authority, attract inbound leads, or build a consistent content presence. Covers positioning, content pillars, formats, and posting rhythm.
---

# LinkedIn Authority Builder

Here's what most people get wrong about LinkedIn: they're trying to go viral.

Viral doesn't pay your bills. Being remembered by the right 500 people when they need what you do — that pays your bills.

This skill builds a content system that makes you impossible to forget for your target audience. Not through hacks. Through consistency and clear positioning.

---

## Before We Build Anything

I need to understand your situation:

1. **What's your expertise?** What do you know cold?
2. **Who needs to remember you?** Specific titles, company stages, industries.
3. **What do you want from LinkedIn?** Leads? Job offers? Speaking gigs? Partnerships?
4. **What's your unfair advantage?** Experience, perspective, or access that others don't have.
5. **What are you doing now?** Posting? How often? What's working?

The strategy depends on the answers.

---

## Step 1: Nail Your Positioning

Before content, get clear on your angle.

**The one-liner:**
> I help [specific audience] with [specific outcome] through [unique approach].

**Example:**
> I help growth-stage founders build marketing systems that scale — combining 15 years of strategy with AI-powered execution.

If you can't say it in one sentence, your content will be unfocused.

**Your headline formula:**
```
[Role] | [What you do for who OR tagline]
```

**Examples:**
- "AI Marketing Architect | I build your AI marketing system. Then I run it."
- "Former Nike CMO → Now helping founders avoid the branding mistakes I made"

The headline is prime real estate. Don't waste it on your job title.

---

## Step 2: Pick Your Content Pillars

These are the 3-5 topics you'll own. Everything you post should fit into one of these buckets.

**Good pillars:**
- You have genuine expertise (not just interest)
- Your target audience cares about it
- You can produce content on it consistently
- It connects to what you sell

**Example pillars:**
1. AI-powered marketing (what I sell)
2. Founder marketing lessons (what I've learned)
3. Brand positioning (my expertise)
4. Behind-the-scenes building (makes me human)
5. Hot takes on marketing trends (keeps it interesting)

**The ratio:**
- 70% core expertise (builds authority)
- 20% adjacent insights (makes you interesting)
- 10% personal (makes you relatable)

---

## Step 3: Know Your Formats

Different formats for different goals:

| Format | Good For | Engagement |
|--------|----------|------------|
| Story | Connection | High |
| Framework/List | Authority | High |
| Hot take | Reach | Variable |
| Case study | Proof | Medium |
| Behind-the-scenes | Trust | Medium |

**The winning mix:**
- 2-3 frameworks per week (authority)
- 1-2 stories per week (connection)
- 1 case study or proof point per week (credibility)

---

## Step 4: Master the Hook

The first line determines if anyone reads the rest. Make it count.

**Hooks that work:**

> "Most founders get [topic] wrong. Here's why:"

> "I spent 15 years learning this the hard way:"

> "[Counterintuitive statement that makes them stop scrolling]"

> "The best [X] I know all do this one thing:"

**Hook principles:**
- Specific beats vague
- Numbers add credibility
- Tension creates curiosity
- Punchline first, context second

---

## Step 5: The Post Structures

### The Story Post
```
[Hook — the moment or realization]

[Setup — quick context]

[Tension — what was hard or went wrong]

[Turn — the insight]

[Lesson — the takeaway]

[Question — drives engagement]
```

### The Framework Post
```
[Hook — bold claim or problem]

[Why this matters — 1-2 sentences]

[The X-step framework:]
1. [Step + brief explanation]
2. [Step + brief explanation]
3. [Step + brief explanation]

[Key insight or summary]

[CTA or question]
```

### The Hot Take
```
[Controversial statement]

[Your reasoning — 2-3 sentences]

[The nuance people miss]

[What to do instead]

[Question to drive comments]
```

---

## Step 6: Set Your Rhythm

**Minimum viable presence:**
- 3x per week
- Same days/times
- At least 2 posts showing expertise

**If you want growth:**
- 5x per week (weekdays)
- Active commenting (20-30 min/day)
- 1 long-form article per month

**Best times (test for yourself):**
- Tuesday-Thursday mornings (7-9am)
- Tuesday-Thursday lunch (12-1pm)
- Avoid weekends for B2B

---

## Step 7: Engage Like a Human

Posting is half the game. Engaging is the other half.

**Comment strategy:**
- 5-10 thoughtful comments per day on posts from your target audience
- Add value, don't just say "Great post!"
- Share a relevant experience or insight
- Ask a follow-up question

**Comments that work:**
- "This is exactly what I saw at [company]. We also found that..."
- "Interesting take. What about the case where [alternative scenario]?"
- "Adding to this: [your framework or step they didn't mention]"

---

## What You Get Back

A complete LinkedIn strategy doc:

```
## Your Positioning
- Headline: [optimized]
- One-liner: [what you do for who]

## Content Pillars
1. [Pillar + what you'll cover]
2. [Pillar + what you'll cover]
3. [Pillar + what you'll cover]

## Weekly Schedule
- [Day]: [Format + Pillar]
- [Day]: [Format + Pillar]
- [Day]: [Format + Pillar]

## First 5 Post Ideas
1. [Hook + brief description]
2. [Hook + brief description]
3. [Hook + brief description]
4. [Hook + brief description]
5. [Hook + brief description]

## Engagement Plan
- Who to engage with
- How much time daily
- What kinds of comments
```

---

## What Not to Do

❌ Posting only about yourself and your company
❌ Inspirational quotes with no substance
❌ Engagement bait ("Comment YES if you agree!")
❌ Posting once then disappearing for 3 weeks
❌ Only broadcasting, never engaging
❌ Walls of text with no formatting

---

**Need help building your LinkedIn presence?**
→ [Book a strategy call](https://brianrwagner.com)

---

*Skill by Brian Wagner | AI Marketing Architect | brianrwagner.com*
