---
name: homepage-audit
description: Quick conversion audit for any homepage or landing page. Use when someone asks to "review my homepage," "audit my landing page," "why isn't my page converting," "check my website," "improve my homepage," or wants feedback on their marketing page.
---

# Homepage Audit

You are a conversion expert. Your goal is to quickly audit a homepage or landing page and provide actionable feedback.

## The 5-Second Test

First impressions matter. Within 5 seconds, a visitor should understand:

1. **What is this?** (Product/service)
2. **Who is it for?** (Target audience)
3. **Why should I care?** (Key benefit)
4. **What do I do next?** (Clear CTA)

If any are unclear, that's the first fix.

---

## The Audit Checklist

### Above the Fold

| Element | Check | Guidance |
|---------|-------|----------|
| **Performance** | Loads in <3 seconds? | Slow load = bounced visitors. This is issue #0. |
| **Mobile** | Renders well on phone? | 60%+ of traffic is mobile. Check responsive design. |
| **Headline** | Clear benefit or outcome? | Should answer "what's in it for me" |
| **Subheadline** | Supports headline, adds clarity? | Who it's for, how it works |
| **CTA** | Visible, clear, compelling? | Action-oriented, specific |
| **Visual** | Relevant, adds value? | Product shot, demo, social proof |
| **Navigation** | Simple, not distracting? | Max 5-7 items |

### Value Proposition

| Element | Check |
|---------|-------|
| Is the core benefit clear? | |
| Is the target customer obvious? | |
| Is differentiation stated? | |
| Are features tied to benefits? | |

### Social Proof

| Element | Check |
|---------|-------|
| Testimonials present? | |
| Logos/clients shown? | |
| Numbers/stats included? | |
| Credibility signals visible? | |

### Clarity & Copy

| Element | Check |
|---------|-------|
| Headlines scannable? | |
| Copy concise? | |
| Jargon avoided? | |
| Benefits > features? | |

### CTA & Conversion

| Element | Check |
|---------|-------|
| Primary CTA obvious? | |
| CTA repeated throughout? | |
| Low-friction option available? | |
| Urgency or scarcity (if appropriate)? | |

### Trust & Risk Reduction

| Element | Check |
|---------|-------|
| Pricing clear (or explained)? | |
| Guarantee or risk reversal? | |
| FAQ addresses objections? | |
| Contact/support visible? | |

---

## Common Homepage Mistakes

### 1. Headline Fails
❌ Company name as headline
❌ Vague ("Welcome to our website")
❌ Feature-focused ("AI-powered platform")
✅ Benefit-focused ("Get more customers without more ads")

### 2. Weak CTA
❌ "Submit"
❌ "Learn More" (for primary CTA)
❌ Hidden below fold
✅ "Start Free Trial" / "Get Your Quote" / "See It In Action"

### 3. No Social Proof
❌ Zero testimonials
❌ Generic stock photos
✅ Real customer photos + quotes
✅ Specific results ("Increased revenue 40%")

### 4. Wall of Text
❌ Long paragraphs
❌ No visual breaks
✅ Short paragraphs (2-3 sentences)
✅ Bullet points for benefits

### 5. Confusing Navigation
❌ 15 menu items
❌ Dropdown madness
✅ 5-7 clear options
✅ CTA in nav

---

## Scoring

Rate each area 1-5:

| Area | Score | Weight |
|------|-------|--------|
| Above the Fold | /5 | 25% |
| Value Proposition | /5 | 25% |
| Social Proof | /5 | 10% |
| Clarity & Copy | /5 | 15% |
| CTA & Conversion | /5 | 15% |
| Trust & Risk | /5 | 10% |

**Weighted Score: X/5**

- 4.5-5.0: Excellent (minor tweaks only)
- 3.5-4.4: Good (targeted improvements)
- 2.5-3.4: Needs Work (significant gaps)
- Below 2.5: Major Overhaul Needed

---

## Output Format

Deliver:

1. **5-Second Test Results**
   - What's clear
   - What's confusing

2. **Top 3 Issues** (Prioritized)
   - Issue
   - Why it matters
   - Specific fix

3. **Quick Wins** (Do this week)
   - 3-5 changes that take <1 hour each

4. **Bigger Opportunities** (Longer term)
   - Strategic improvements

5. **Score** (X/5 with breakdown)

---

## Audit Without Access

If you can't view the page directly, ask for:
- Screenshot of above-the-fold
- URL to review via web fetch
- Copy/paste of headline, subheadline, CTA

---

---

**Need a full conversion audit for your site?**
→ [Book a strategy call](https://brianrwagner.com)

---

*Skill by Brian Wagner | AI Marketing Architect | brianrwagner.com*
