---
name: cold-outreach-sequence
description: Build personalized cold outreach sequences for LinkedIn and email. Use when someone needs to reach prospects, warm up cold leads, or build a systematic outreach engine. Covers research, connection requests, follow-ups, and conversion.
---

# Cold Outreach Sequence

Here's what I've learned about cold outreach: the word "cold" is the problem.

If you're sending messages to strangers who've never heard of you, with templates you copied from some guru — yeah, that's cold. And it doesn't work.

But if you've done even 10 minutes of research, found something specific about them, and have a genuine reason to reach out? That's not cold. That's just... reaching out.

This skill helps you do the second thing.

---

## Before You Write a Single Message

The research is the work. Skip it and you'll sound like everyone else in their inbox.

**For each prospect, find:**

- **Recent news** — Funding, launches, hires, press
- **What they're posting about** — Their content tells you what they care about
- **Their likely pain** — Given their role and stage, what's keeping them up?
- **Your connection point** — What can you genuinely comment on?

**Where to look:**
- Their LinkedIn activity (posts, comments, shares)
- Company news (Crunchbase, TechCrunch, press releases)
- Their website (about page, blog, careers)
- Podcasts they've appeared on

**Time investment:** 10-15 minutes per high-value prospect.

This is what separates you from spam.

---

## The Connection Request (LinkedIn)

You have 300 characters. Don't waste them on a pitch.

**The formula:**
> [Specific observation] + [Simple reason to connect]

**Examples:**

> "Following [Company]'s growth — the [specific thing] is smart positioning. Would love to connect."

> "[Their recent post] resonated. Been thinking about the same thing. Happy to connect."

> "Congrats on [news]. Impressive trajectory."

**The rules:**
- No pitching. At all.
- Be specific (prove you looked)
- Keep it human
- No "I'd love to pick your brain"

---

## First Message (After They Accept)

Wait 24-48 hours. Then:

**The formula:**
> [Thanks] + [Bridge to relevance] + [Light value] + [Soft question]

**Example:**

> Thanks for connecting. I've been working at the intersection of [relevant area] — [one-line credibility].
>
> Curious if you have someone owning [relevant function] as you scale, or if that's still founder-led?
>
> Either way, happy to share what I'm seeing work in the space.

**The rules:**
- Still not a hard pitch
- Demonstrate relevance, not desperation
- Ask a question that invites dialogue
- Offer value without strings attached

---

## First Follow-Up (If No Response)

Wait 5-7 days. Then:

**The formula:**
> [Light nudge] + [New value or angle] + [Easy out]

**Example:**

> Bumping this up — know you're slammed. Came across [relevant thing] and thought of your situation at [Company]. Worth a look if helpful.

**Or:**

> Following up — been seeing [trend] hit companies at your stage. Happy to share what's working if useful. If not, no worries.

**The rules:**
- Don't just say "following up"
- Add something new
- Give them an easy out (takes the pressure off)

---

## The Break-Up (Final Attempt)

Wait 7-10 days. Then move on gracefully:

**Example:**

> I'll assume timing isn't right — totally get it. If [relevant pain point] becomes a priority down the road, happy to reconnect. Best of luck with [specific thing they're working on].

**The rules:**
- No guilt trips
- No "just checking in one last time"
- Leave with class
- They may come back later

---

## Email Version

Same principles, different format.

**Subject lines that work:**
- "[Company]'s marketing as you scale"
- "Saw your [post/news] — quick thought"
- "[Mutual connection] suggested I reach out"
- "Question about [specific thing they're doing]"

**Structure:**
```
[1-line hook tied to them]

[2-3 sentences: why you're reaching out + relevance]

[1 sentence: soft CTA]

[Simple signature]
```

**Example:**

```
Subject: [Company]'s GTM as you scale

Hey [Name],

Saw the [news] — congrats. [One specific observation].

I work with growth-stage companies on [relevant thing]. Helped [similar company] with [specific result].

Worth a quick chat to see if there's a fit?

[Your name]
```

---

## The Full Sequence Calendar

| Day | Action | Platform |
|-----|--------|----------|
| 0 | Research + Connection request | LinkedIn |
| 1-2 | Accept → Wait 24h → First message | LinkedIn |
| 7 | Follow-up #1 | LinkedIn |
| 14 | Follow-up #2 or try email | LinkedIn/Email |
| 21 | Break-up message | Same |

---

## Personalization Tiers

Not everyone deserves 15 minutes of research. Here's how to think about it:

**Tier 1 — Top 10 prospects:** Full research, fully custom messages
**Tier 2 — Next 20:** Template with personalized opener
**Tier 3 — Volume:** Template with minimal customization

The math: 10 highly personalized messages often beat 100 spray-and-pray.

---

## What You Get Back

A complete outreach doc for each prospect:

```
# Outreach: [Prospect Name]

## Research
- Company: [stage, news, situation]
- Their likely pain: [what they're dealing with]
- Connection point: [what you'll reference]

## Sequence
### Connection Request:
[Your message]

### First DM:
[Your message]

### Follow-up #1:
[Your message]

### Break-up:
[Your message]
```

---

## What Kills Outreach

❌ "I'd love to pick your brain"
❌ "Can I get 15 minutes of your time?"
❌ Long paragraphs about yourself
❌ Immediate pitch in connection request
❌ Same message to everyone
❌ Following up every 2 days
❌ "Hope this finds you well"

---

**Need help building an outreach system that actually works?**
→ [Book a strategy call](https://brianrwagner.com)

---

*Skill by Brian Wagner | AI Marketing Architect | brianrwagner.com*
