# AI Discoverability Query Bank

Ready-to-use queries organised by category. Copy/paste into ChatGPT, Perplexity, Claude, and Gemini.

---

## Brand Recognition Queries

### Direct Brand
- "What is [Company]?"
- "Tell me about [Company]"
- "What does [Company] do?"
- "Who founded [Company]?"
- "[Company] reviews"
- "Is [Company] legit?"
- "Is [Company] any good?"
- "[Company] pros and cons"

### Brand + Location
- "[Company] [City]"
- "Is [Company] based in [City]?"
- "[Company] headquarters"

### Brand + Category
- "Is [Company] a good [category] company?"
- "How does [Company] compare to other [category] providers?"

---

## Category Discovery Queries

### Best-of Lists
- "Best [category] companies"
- "Top [category] providers in [year]"
- "Best [category] for [use case]"
- "Best [category] for small businesses"
- "Best [category] for enterprises"
- "Affordable [category] options"
- "Premium [category] providers"

### Location-Based
- "Best [category] in [city]"
- "[Category] companies near me"
- "Top [category] in [state/region]"
- "Local [category] recommendations"

### Use-Case Specific
- "Best [category] for [specific need]"
- "[Category] for [industry]"
- "[Category] for startups"
- "[Category] for [target customer]"

### Alternative Queries
- "[Competitor] alternatives"
- "Companies like [Competitor]"
- "[Competitor] vs [Competitor]"
- "Cheaper alternatives to [Competitor]"

---

## Authority & Expertise Queries

### Expert Recognition
- "Who are the experts in [industry]?"
- "Top [industry] thought leaders"
- "[Industry] influencers to follow"
- "Best [industry] consultants"

### Knowledge Queries
- "Best practices for [topic]"
- "How to [solve problem]"
- "What should I know about [topic]?"
- "[Topic] guide"
- "[Topic] framework"

### Founder/Leader
- "[Founder name]"
- "Who is [Founder name]?"
- "[Founder name] [Company]"
- "[Founder name] expertise"

---

## Problem-Aware Queries

### Pain Point Queries
- "How to solve [problem brand solves]"
- "Why is [problem] so hard?"
- "[Problem] solutions"
- "Help with [problem]"

### Comparison Queries
- "Should I use [solution A] or [solution B]?"
- "[Your approach] vs [alternative approach]"
- "Pros and cons of [solution type]"

---

## Industry-Specific Templates

### SaaS/Tech
- "Best [category] software"
- "[Category] tools for [use case]"
- "[Category] platform comparison"
- "[Competitor] pricing vs alternatives"

### Professional Services
- "Best [service] firm in [city]"
- "[Service] consultants for [industry]"
- "How to choose a [service] provider"
- "[Service] firm reviews"

### Local Business
- "[Service] near me"
- "Best [service] in [neighborhood]"
- "[Service] open now"
- "Affordable [service] [city]"

### E-commerce/DTC
- "Best [product category]"
- "Where to buy [product]"
- "[Product] reviews"
- "[Brand] vs [Competitor] [product]"

---

## Monitoring Queries (Run Monthly)

Track these consistently to measure progress:

1. "[Company name]" - Direct brand recognition
2. "Best [primary category] companies" - Category presence
3. "[Main competitor] alternatives" - Competitive positioning
4. "[Founder name]" - Personal brand
5. "How to [primary problem you solve]" - Expertise citation

---

## Platform-Specific Notes

### ChatGPT
- Most widely used, largest influence
- Knowledge cutoff affects recency
- Web browsing mode accesses current info

### Perplexity
- Cites sources explicitly
- More current information
- Good for tracking which sources get cited

### Claude
- Strong reasoning, less browsing
- Good for testing brand understanding
- May have older knowledge cutoff

### Gemini
- Google integration
- Good for testing local/maps presence
- May favour Google properties

---

## Scoring Quick Reference

For each query, rate:

| Score | Recognition | Description |
|-------|-------------|-------------|
| 5 | Excellent | Featured prominently, accurate, positive |
| 4 | Good | Mentioned, mostly accurate |
| 3 | Moderate | Mentioned but vague or incomplete |
| 2 | Weak | Barely mentioned or with errors |
| 1 | None | Not mentioned at all |
