# 🎨 Icon & Badge Assets

This document describes the visual assets needed for the ClawHub listing.

---

## Required Assets

### 1. Main Icon (icon.png)
- **Size:** 512×512px (PNG)
- **Format:** Square with transparent background optional
- **Style:** Modern, minimal, tech-forward
- **Suggested Design:**
  - Golden/orange gradient background or flame motif
  - Stylized "A" or abstract neural network pattern
  - 4 small dots or circles representing the 4 council members
  - Lotus petal or dharma wheel element (subtle)

### 2. Hero Banner (banner.png)
- **Size:** 1280×640px (PNG)
- **Use:** ClawHub listing header
- **Style:** Wide banner with gradient
- **Suggested Elements:**
  - Left side: Product name "AGENTIC AI GOLD STANDARD"
  - Tagline: "The only agent framework that improves itself while you sleep"
  - Right side: Abstract visualization of 4 agents + 17 gates
  - Color scheme: Gold, orange, dark purple, black

### 3. Feature Badges (badge-*.png)
Create small 200×40px badges:

| Badge File | Text | Color |
|------------|------|-------|
| badge-tests.png | "16/17 TESTS PASSING" | Green |
| badge-research.png | "250K+ TOKENS" | Purple |
| badge-shakti.png | "SHAKTI FLOW ACTIVE" | Orange |
| badge-dharmic.png | "17 DHARMIC GATES" | Gold |
| badge-self-improve.png | "SELF-IMPROVING" | Red |

### 4. Architecture Diagram (architecture.png)
- **Size:** 1200×800px (PNG)
- **Content:** Visual representation of the stack:
  ```
  ┌─────────────────────────────────────┐
  │      PERSISTENT COUNCIL (4)         │
  ├─────────────────────────────────────┤
  │    LANGGRAPH + CREWAI + PYDANTIC    │
  ├─────────────────────────────────────┤
  │      5-LAYER MEMORY SYSTEM          │
  ├─────────────────────────────────────┤
  │       MCP + A2A PROTOCOLS           │
  ├─────────────────────────────────────┤
  │      4-TIER MODEL FALLBACK          │
  └─────────────────────────────────────┘
  ```

### 5. Pricing Cards (pricing.png)
- **Size:** 1000×600px (PNG)
- **3 columns:** Starter ($49) | Professional ($149) | Enterprise ($499)
- **Style:** Clean, SaaS pricing table design

---

## Color Palette

| Color | Hex | Usage |
|-------|-----|-------|
| Gold | #FFD700 | Primary accent, headers |
| Orange | #FF6B35 | Shakti/active elements |
| Deep Purple | #4A148C | Backgrounds, depth |
| Black | #0A0A0A | Text, dark backgrounds |
| White | #FFFFFF | Text on dark |
| Green | #00C853 | Success, tests passing |
| Red | #FF1744 | Shakti flow, active |

---

## Typography Suggestions

- **Headers:** Inter Bold or Poppins Bold
- **Body:** Inter Regular or Roboto Regular
- **Code:** JetBrains Mono or Fira Code

---

## Design Tools

Recommended for creating assets:
- **Figma** (free, collaborative)
- **Canva** (easy templates)
- **Adobe Illustrator** (professional)
- **GIMP** (free alternative)

---

## Quick Icon Generation Prompt (for AI image tools)

```
A modern, minimalist app icon for "Agentic AI Gold Standard". 
Golden orange gradient background. Abstract representation of 
4 connected nodes (agents) in a diamond pattern. Subtle lotus 
petal motif. Clean, geometric, tech-forward. Suitable for 
512x512px app icon. No text.
```

---

## Placeholder Strategy

Until custom assets are ready:
1. Use Font Awesome or Lucide icons
2. Create simple SVG versions
3. Use gradient backgrounds with text
4. Generate with DALL-E, Midjourney, or Stable Diffusion

---

*Asset specification v1.0 • February 2026*
