# 🎁 OpenClaw Browser Toggle Skill - 分享包

## 📦 发布信息

- **名称：** browser-toggle
- **版本：** v1.0.0
- **大小：** 8.1 KB
- **SHA256：** `52e6793d41094b6495ce5a9ae165b9fa03947989d739290399a352e76d8b52c7`
- **发布包位置：** `/home/ereala/.openclaw/workspace/skills/browser-toggle/dist/browser-toggle-v1.0.0.tar.gz`

---

## 🚀 安装说明（复制给其他用户）

```bash
# 1. 下载 Skill 包
# 方式 A：从 GitHub Releases 下载
wget https://github.com/your-username/browser-toggle/releases/download/v1.0.0/browser-toggle-v1.0.0.tar.gz

# 方式 B：从本地复制（如果在同一网络）
scp browser-toggle-v1.0.0.tar.gz user@remote-host:~/

# 2. 解压并安装
tar -xzf browser-toggle-v1.0.0.tar.gz
cd browser-toggle-v1.0.0
bash setup.sh

# 3. 验证安装
openclaw-browser --status
```

---

## 💡 使用示例

```bash
# 启用内置浏览器
openclaw-browser --enable
openclaw gateway restart

# 查看状态
openclaw-browser --status

# 禁用
openclaw-browser --disable
openclaw gateway restart
```

---

## 📋 完整文件列表

```
browser-toggle-v1.0.0/
├── setup.sh              # 安装脚本
├── browser_toggle.py     # 主程序
├── README.md             # 项目说明
├── INSTALL.md            # 安装指南
├── 使用指南.md           # 详细使用文档
├── SKILL.md              # Skill 描述
├── skill.conf            # 配置文件
├── RELEASE.md            # 发布说明
├── SHARE.md              # 分享说明
├── GITHUB_RELEASE.md     # GitHub 发布说明
├── install.sh            # 快速安装脚本
└── build.sh              # 构建脚本
```

---

## 📞 分享渠道

### 1. GitHub Releases

```
1. 创建 GitHub 仓库
2. 上传 browser-toggle-v1.0.0.tar.gz
3. 创建 Release v1.0.0
4. 使用 GITHUB_RELEASE.md 作为发布说明
```

### 2. 直接分享压缩包

```
1. 发送 browser-toggle-v1.0.0.tar.gz 文件
2. 附上安装说明（见上方）
```

### 3. ClawHub 分享

```
1. 打包成 ClawHub 兼容格式
2. 上传到 ClawHub
3. 分享安装命令
```

---

## 🎯 核心卖点

- ✅ **无需手动编辑配置文件** - 一条命令搞定
- ✅ **自动备份** - 修改前自动备份，失败可恢复
- ✅ **一键切换** - 启用/禁用只需一条命令
- ✅ **跨平台** - Linux/macOS/Windows 都支持
- ✅ **独立空间** - 不访问个人浏览器数据
- ✅ **小巧轻量** - 仅 8KB，无额外依赖

---

## 📊 对比优势

| 功能 | 手动配置 | Browser Toggle Skill |
|------|----------|---------------------|
| 修改配置 | 手动编辑 JSON | 一条命令 |
| 备份配置 | 手动复制 | 自动备份 |
| 恢复配置 | 手动找回 | 一键恢复 |
| 切换模式 | 反复编辑 | 一键切换 |
| 错误处理 | 自己解决 | 自动提示 |

---

## 📝 分享文案（可直接使用）

```
🎉 分享一个超实用的 OpenClaw Skill！

【Browser Toggle - 内置浏览器一键切换】

🤔 是否厌倦了手动编辑 openclaw.json？
🤔 是否担心配置改错无法恢复？
🤔 是否想要一键切换内置/扩展模式？

这个 Skill 帮你解决所有问题！

✨ 功能：
✅ 一键启用/禁用内置浏览器
✅ 自动备份配置文件
✅ 失败自动恢复
✅ 支持可视化/无头模式
✅ 跨平台（Linux/macOS/Windows）

📦 大小：仅 8KB
🚀 安装：解压 + bash setup.sh

GitHub: https://github.com/your-username/browser-toggle

#OpenClaw #Skill #浏览器 #自动化
```

---

## 🔗 分享链接

- **GitHub:** https://github.com/your-username/browser-toggle
- **发布包:** `dist/browser-toggle-v1.0.0.tar.gz`
- **文档:** `README.md`, `INSTALL.md`, `使用指南.md`

---

*创建时间：2026-02-28*  
*版本：v1.0.0*
