# 📖 内置浏览器 Skill - 使用指南

> 无需手动编辑配置文件，一键切换内置浏览器模式

---

## 🎯 为什么需要这个 Skill？

**问题：** 每次访问需要登录的网站（如百度网盘），都要：
1. 手动编辑 `~/.openclaw/openclaw.json`
2. 配置浏览器参数
3. 重启 OpenClaw
4. 如配置失败，还要手动恢复

**解决：** 用这个 Skill，一条命令搞定！

---

## 🚀 快速使用

### 启用内置浏览器

```bash
# 最简单的方式
cd /home/ereala/.openclaw/workspace/skills/browser-toggle
python3 browser_toggle.py --enable

# 重启 OpenClaw
openclaw gateway restart
```

### 禁用（恢复默认）

```bash
python3 browser_toggle.py --disable
openclaw gateway restart
```

### 查看状态

```bash
python3 browser_toggle.py --status
```

---

## 📋 完整命令

| 命令 | 说明 | 示例 |
|------|------|------|
| `--enable` | 启用内置浏览器 | `--enable` |
| `--enable --headless` | 启用（无头模式） | `--enable --headless` |
| `--disable` | 禁用内置浏览器 | `--disable` |
| `--status` | 查看状态 | `--status` |
| `--headless` | 切换到无头 | `--headless` |
| `--visible` | 切换到可视化 | `--visible` |
| `--restore <文件>` | 从备份恢复 | `--restore ~/.openclaw/workspace/backups/xxx.json` |

---

## 💡 使用场景

### 场景 1：访问百度网盘

```bash
# 1. 启用内置浏览器（可视化）
python3 browser_toggle.py --enable
openclaw gateway restart

# 2. 让 AI 打开百度网盘
# AI 会使用内置浏览器打开页面

# 3. 手动登录（在 AI 打开的浏览器窗口中）
# 登录状态会保存

# 4. 后续可以直接使用
# AI 会自动使用已登录的浏览器
```

### 场景 2：日常自动化

```bash
# 启用无头模式（后台运行）
python3 browser_toggle.py --enable --headless
openclaw gateway restart
```

### 场景 3：配置失败恢复

```bash
# 查看最近的备份
ls -lt ~/.openclaw/workspace/backups/

# 从备份恢复
python3 browser_toggle.py --restore ~/.openclaw/workspace/backups/openclaw-20260228-221416-before-browser-toggle.json
openclaw gateway restart
```

---

## 🔧 配置说明

### 启用后的配置

```json
{
  "browser": {
    "enabled": true,
    "defaultProfile": "openclaw",
    "headless": false,
    "noSandbox": false,
    "attachOnly": false,
    "executablePath": "/usr/bin/google-chrome"
  }
}
```

### 各参数说明

| 参数 | 说明 | 推荐值 |
|------|------|--------|
| `enabled` | 是否启用 | `true` |
| `defaultProfile` | 浏览器类型 | `openclaw` |
| `headless` | 无头模式 | `false`（首次）/`true`（后续） |
| `noSandbox` | 禁用沙箱 | `false` |
| `executablePath` | Chrome 路径 | 自动检测 |

---

## 📁 备份管理

### 自动备份

**每次修改配置前都会自动备份**

**备份位置：**
```
~/.openclaw/workspace/backups/
```

**备份文件名：**
```
openclaw-YYYYMMDD-HHMMSS-before-browser-toggle.json
```

### 手动恢复

```bash
# 1. 查看备份列表
ls -lt ~/.openclaw/workspace/backups/

# 2. 恢复指定备份
python3 browser_toggle.py --restore ~/.openclaw/workspace/backups/openclaw-20260228-221416-before-browser-toggle.json

# 3. 重启 OpenClaw
openclaw gateway restart
```

---

## ⚠️ 注意事项

### 1. 修改后需要重启

```bash
# 每次修改配置后
openclaw gateway restart
```

### 2. 首次使用需要手动登录

```
1. 启用内置浏览器（可视化模式）
2. 让 AI 打开网站（如百度网盘）
3. 在 AI 打开的浏览器窗口中手动登录
4. 登录状态会保存
```

### 3. 切换模式需要重新登录

```
从 chrome 切换到 openclaw = 换新浏览器
需要重新登录所有网站
```

### 4. 无头模式 vs 可视化

| 模式 | 优点 | 缺点 | 适用场景 |
|------|------|------|----------|
| 可视化 | 可以看到操作过程 | 占用桌面 | 首次登录、调试 |
| 无头 | 后台运行，不占桌面 | 看不到过程 | 日常使用 |

---

## 🐛 故障排除

### 问题 1：Chrome 未找到

**错误：** `Chrome executable not found`

**解决：**
```bash
# 安装 Chrome
wget https://dl.google.com/linux/direct/google-chrome-stable_current_amd64.deb
sudo dpkg -i google-chrome-stable_current_amd64.deb
sudo apt-get install -f -y

# 或找到 Chrome 路径
which google-chrome
which chromium

# 手动编辑配置
nano ~/.openclaw/openclaw.json
# 修改 executablePath
```

### 问题 2：配置失败

**解决：**
```bash
# 从备份恢复
python3 browser_toggle.py --restore <备份文件>

# 或手动恢复
cp ~/.openclaw/workspace/backups/openclaw-*.json ~/.openclaw/openclaw.json
openclaw gateway restart
```

### 问题 3：浏览器无法启动

**解决：**
```bash
# 检查 Chrome 是否安装
google-chrome --version

# 检查权限
ls -la /usr/bin/google-chrome

# 重新安装
sudo apt-get install --reinstall google-chrome-stable
```

---

## 📞 获取帮助

```bash
# 查看帮助
python3 browser_toggle.py --help

# 查看状态
python3 browser_toggle.py --status

# 查看日志
tail -f /tmp/openclaw/openclaw-*.log
```

---

## 🎯 最佳实践

### 推荐工作流程

```
1. 需要访问登录网站
   ↓
2. python3 browser_toggle.py --enable
   ↓
3. openclaw gateway restart
   ↓
4. 让 AI 打开网站，手动登录
   ↓
5. （可选）切换到无头模式
   python3 browser_toggle.py --headless
   ↓
6. 日常使用
   ↓
7. 不需要时禁用
   python3 browser_toggle.py --disable
```

### 配置建议

| 场景 | 推荐配置 |
|------|----------|
| 首次使用 | `--enable`（可视化） |
| 日常使用 | `--enable --headless` |
| 不需要 | `--disable` |
| 调试 | `--enable`（可视化） |

---

## 📚 相关文档

- [SKILL.md](SKILL.md) - Skill 说明
- [README.md](README.md) - 项目说明
- [browser_toggle.py](browser_toggle.py) - 源代码

---

*版本：v1.0*  
*最后更新：2026-02-28*
