# Brief Templates

Standard structures for different brief types. Override with user preferences.

## Executive Brief

For leadership, stakeholders, or when limited time/attention.

```
⚡ BOTTOM LINE
[One sentence: the key takeaway]

📊 STATUS: [On track / At risk / Blocked]

KEY POINTS (3 max)
• [Most important thing]
• [Second most important]
• [Third if truly needed]

🎯 DECISION NEEDED
[What you need from them, if anything]

📎 CONTEXT (optional)
[Brief background if they need it]
```

Principles: BLUF always. Ruthlessly short. Decision-focused.

## Project Brief

For project status updates, sprint reviews, stakeholder updates.

```
📋 PROJECT: [Name] — [Date]

⚡ STATUS: [emoji] [On track / Delayed / Blocked]

✅ COMPLETED
• [Done item 1]
• [Done item 2]

🔄 IN PROGRESS
• [Current work] — [% or ETA]

🚧 BLOCKERS
• [Blocker] — [Who can unblock]

📅 NEXT
• [Upcoming milestone] — [Date]

📊 METRICS (if applicable)
[Key numbers that matter]
```

Principles: Status first. Blockers visible. Clear next steps.

## Meeting Brief

For meeting preparation — sent before the meeting.

```
📋 MEETING: [Title] — [Date/Time]

🎯 PURPOSE
[Why this meeting exists — 1 sentence]

👥 ATTENDEES
[Key people and their role in this meeting]

📝 CONTEXT
[What happened since last time, relevant background]

❓ DECISIONS NEEDED
• [Decision 1]
• [Decision 2]

📎 PRE-READ (if any)
[Links to docs they should review]

✅ PREP CHECKLIST
• [ ] [Thing they should do/think about before]
```

Principles: Enable them to show up prepared. Surface decisions.

## Handoff Brief

For knowledge transfer, context passing, onboarding.

```
📋 HANDOFF: [Subject]

⚡ STATE
[Current state in 2-3 sentences]

🗺️ KEY CONTEXT
• [Important context 1]
• [Important context 2]
• [Why things are the way they are]

⚠️ GOTCHAS
• [Non-obvious thing that could bite them]
• [Common mistake to avoid]

📌 PRIORITIES
1. [Most important next thing]
2. [Second priority]
3. [Third priority]

🔗 RESOURCES
• [Link to relevant doc]
• [Key contact for questions]

❓ OPEN QUESTIONS
• [Unresolved thing they should know about]
```

Principles: Transfer all non-obvious knowledge. Prevent repeated mistakes.

## Decision Brief

For structured decision-making support.

```
📋 DECISION: [What needs to be decided]

⚡ RECOMMENDATION
[Your recommended choice — 1 sentence]

📊 OPTIONS

**Option A: [Name]**
• Pros: [benefits]
• Cons: [drawbacks]
• Risk: [Low/Med/High]

**Option B: [Name]**
• Pros: [benefits]
• Cons: [drawbacks]
• Risk: [Low/Med/High]

⚖️ KEY TRADEOFFS
[What you're trading off between options]

🎯 WHY [RECOMMENDATION]
[2-3 sentences on why this is the best choice]

⏰ DEADLINE
[When this decision needs to be made]
```

Principles: Clear recommendation upfront. Honest tradeoffs. Enable fast decision.
