# Brief Preferences

Auto-evolving user preferences for briefings. Edit as you learn.

**Rules:**
- Observe what briefs land vs miss
- After 2+ signals, mark as `pattern`
- Confirm explicitly before marking `confirmed`
- Reinforce to `locked` only after repeated positive signals

---

### Scope
<!-- What they typically need briefs for. Format: "type: context (level)" -->

### Content
<!-- What to include/exclude. Format: "element: preference (level)" -->

### Structure
<!-- How they like briefs organized. Format: "aspect: preference (level)" -->

### Format
<!-- Delivery preferences. Format: "dimension: preference (level)" -->

### Timing
<!-- When they want briefs. Format: "trigger: timing (level)" -->

### Depth
<!-- Detail level preferences. Format: "type: depth (level)" -->

---

## Per-Type Overrides

Different brief types may have different preferences:

### Executive Briefs
<!-- Overrides for executive summaries -->

### Project Briefs
<!-- Overrides for project updates -->

### Meeting Briefs
<!-- Overrides for meeting prep -->

### Handoff Briefs
<!-- Overrides for handoffs -->

---

*Empty sections = defaults apply. Observe and evolve.*
