# Brief Dimensions

Reference for categorizing user preferences. Load when updating `preferences.md`.

## Scope

What the brief covers:
- `type` — Executive, project, meeting, handoff, decision
- `audience` — Self, boss, team, external stakeholder
- `purpose` — Inform, enable decision, prepare for meeting

## Content

What to include:
- `metrics` — Always include? Only if changed? Which ones?
- `context` — How much background
- `risks` — Highlight vs mention vs omit
- `history` — Include recent decisions/changes

What to exclude:
- `assumed` — Knowledge they already have
- `noise` — Details that don't affect the action

## Structure

How to organize:
- `order` — BLUF first? Chronological? By priority?
- `sections` — Which sections, in what order
- `hierarchy` — Flat list vs nested detail
- `emphasis` — What to bold/highlight

## Format

How to present:
- `channel` — Where to deliver (message, doc, email)
- `medium` — Text, PDF, slides, verbal
- `length` — One-pager, detailed, executive summary
- `visuals` — Status indicators, charts, tables
- `tone` — Formal, internal casual, direct

## Timing

When to deliver:
- `trigger` — Pre-meeting, start of week, on-demand
- `lead-time` — How far before the event
- `frequency` — One-time, recurring, as-needed

## Depth

How detailed:
- `default` — Summary, standard, comprehensive
- `per-type` — Different depth for different brief types
- `expandable` — Include "more detail available" sections

## Personalization Levels

```
[none]      → Default brief format
[pattern]   → 2+ signals observed, not confirmed
[confirmed] → User explicitly approved
[locked]    → Reinforced multiple times, stable
```
